/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timers;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Prayer;
import net.runelite.api.Varbits;
import net.runelite.api.WorldType;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.LocalPlayerDeath;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetHiddenChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.timers.GameIndicator;
import net.runelite.client.plugins.timers.GameTimer;
import net.runelite.client.plugins.timers.IndicatorIndicator;
import net.runelite.client.plugins.timers.TeleportWidget;
import net.runelite.client.plugins.timers.TimerTimer;
import net.runelite.client.plugins.timers.TimersConfig;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Timers", description="Show various timers in an infobox", tags={"combat", "items", "magic", "potions", "prayer", "overlay", "abyssal", "sire"})
public class TimersPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TimersPlugin.class);
    private static final String ANTIFIRE_DRINK_MESSAGE = "You drink some of your antifire potion.";
    private static final String ANTIFIRE_EXPIRED_MESSAGE = "<col=7f007f>Your antifire potion has expired.</col>";
    private static final String ANTIVENOM_DRINK_MESSAGE = "You drink some of your anti-venom potion";
    private static final String CANNON_FURNACE_MESSAGE = "You add the furnace.";
    private static final String CANNON_PICKUP_MESSAGE = "You pick up the cannon. It's really heavy.";
    private static final String CANNON_REPAIR_MESSAGE = "You repair your cannon, restoring it to working order.";
    private static final String CHARGE_EXPIRED_MESSAGE = "<col=ef1020>Your magical charge fades away.</col>";
    private static final String CHARGE_MESSAGE = "<col=ef1020>You feel charged with magic power.</col>";
    private static final String DEADMAN_HALF_TELEBLOCK_MESSAGE = "<col=4f006f>A teleblock spell has been cast on you. It will expire in 1 minute, 15 seconds.</col>";
    private static final String EXTENDED_ANTIFIRE_DRINK_MESSAGE = "You drink some of your extended antifire potion.";
    private static final String EXTENDED_SUPER_ANTIFIRE_DRINK_MESSAGE = "You drink some of your extended super antifire potion.";
    private static final String FROZEN_MESSAGE = "<col=ef1020>You have been frozen!</col>";
    private static final String FULL_TELEBLOCK_MESSAGE = "<col=4f006f>A teleblock spell has been cast on you. It will expire in 5 minutes, 0 seconds.</col>";
    private static final String GOD_WARS_ALTAR_MESSAGE = "you recharge your prayer.";
    private static final String HALF_TELEBLOCK_MESSAGE = "<col=4f006f>A teleblock spell has been cast on you. It will expire in 2 minutes, 30 seconds.</col>";
    private static final String IMBUED_HEART_READY_MESSAGE = "<col=ef1020>Your imbued heart has regained its magical power.</col>";
    private static final String MAGIC_IMBUE_EXPIRED_MESSAGE = "Your Magic Imbue charge has ended.";
    private static final String MAGIC_IMBUE_MESSAGE = "You are charged to combine runes!";
    private static final String SANFEW_SERUM_DRINK_MESSAGE = "You drink some of your Sanfew serum.";
    private static final String STAFF_OF_THE_DEAD_SPEC_EXPIRED_MESSAGE = "Your protection fades away";
    private static final String STAFF_OF_THE_DEAD_SPEC_MESSAGE = "Spirits of deceased evildoers offer you their protection";
    private static final String STAMINA_DRINK_MESSAGE = "You drink some of your stamina potion.";
    private static final String STAMINA_SHARED_DRINK_MESSAGE = "You have received a shared dose of stamina potion.";
    private static final String STAMINA_EXPIRED_MESSAGE = "<col=8f4808>Your stamina potion has expired.</col>";
    private static final String SUPER_ANTIFIRE_DRINK_MESSAGE = "You drink some of your super antifire potion";
    private static final String SUPER_ANTIFIRE_EXPIRED_MESSAGE = "<col=7f007f>Your super antifire potion has expired.</col>";
    private static final String SUPER_ANTIVENOM_DRINK_MESSAGE = "You drink some of your anti-venom+ potion";
    private TimerTimer freezeTimer;
    private int freezeTime = -1;
    private int lastRaidVarb;
    private int lastWildernessVarb;
    private int lastVengCooldownVarb;
    private int lastIsVengeancedVarb;
    private WorldPoint lastPoint;
    private TeleportWidget lastTeleportClicked;
    private int lastAnimation;
    private boolean loggedInRace;
    private boolean widgetHiddenChangedOnPvpWorld;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private Client client;
    @Inject
    private TimersConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;

    @Provides
    TimersConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(TimersConfig.class);
    }

    @Override
    protected void shutDown() throws Exception {
        this.infoBoxManager.removeIf(t -> t instanceof TimerTimer);
        this.lastRaidVarb = -1;
        this.lastPoint = null;
        this.lastTeleportClicked = null;
        this.lastAnimation = -1;
        this.loggedInRace = false;
        this.widgetHiddenChangedOnPvpWorld = false;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int inWilderness;
        int raidVarb = this.client.getVar(Varbits.IN_RAID);
        int vengCooldownVarb = this.client.getVar(Varbits.VENGEANCE_COOLDOWN);
        int isVengeancedVarb = this.client.getVar(Varbits.VENGEANCE_ACTIVE);
        if (this.lastRaidVarb != raidVarb) {
            this.removeGameTimer(GameTimer.OVERLOAD_RAID);
            this.removeGameTimer(GameTimer.PRAYER_ENHANCE);
            this.lastRaidVarb = raidVarb;
        }
        if (this.lastVengCooldownVarb != vengCooldownVarb && this.config.showVengeance()) {
            if (vengCooldownVarb == 1) {
                this.createGameTimer(GameTimer.VENGEANCE);
            } else {
                this.removeGameTimer(GameTimer.VENGEANCE);
            }
            this.lastVengCooldownVarb = vengCooldownVarb;
        }
        if (this.lastIsVengeancedVarb != isVengeancedVarb && this.config.showVengeanceActive()) {
            if (isVengeancedVarb == 1) {
                this.createGameIndicator(GameIndicator.VENGEANCE_ACTIVE);
            } else {
                this.removeGameIndicator(GameIndicator.VENGEANCE_ACTIVE);
            }
            this.lastIsVengeancedVarb = isVengeancedVarb;
        }
        if (this.lastWildernessVarb != (inWilderness = this.client.getVar(Varbits.IN_WILDERNESS)) && this.client.getGameState() == GameState.LOGGED_IN && !this.loggedInRace) {
            if (!WorldType.isPvpWorld(this.client.getWorldType()) && inWilderness == 0) {
                log.debug("Left wilderness in non-PVP world, clearing Teleblock timer.");
                this.removeTbTimers();
            }
            this.lastWildernessVarb = inWilderness;
        }
    }

    @Subscribe
    public void onWidgetHiddenChanged(WidgetHiddenChanged event) {
        Widget widget = event.getWidget();
        if (WorldType.isPvpWorld(this.client.getWorldType()) && WidgetInfo.TO_GROUP(widget.getId()) == 90) {
            this.widgetHiddenChangedOnPvpWorld = true;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!this.config.showHomeMinigameTeleports()) {
            this.removeGameTimer(GameTimer.HOME_TELEPORT);
            this.removeGameTimer(GameTimer.MINIGAME_TELEPORT);
        }
        if (!this.config.showAntiPoison()) {
            this.removeGameTimer(GameTimer.ANTIDOTEPLUS);
            this.removeGameTimer(GameTimer.ANTIDOTEPLUSPLUS);
            this.removeGameTimer(GameTimer.SANFEW);
            this.removeGameTimer(GameTimer.ANTIVENOM);
            this.removeGameTimer(GameTimer.ANTIVENOMPLUS);
            this.removeGameTimer(GameTimer.ANTIVENOM_ANTIPOISON);
            this.removeGameTimer(GameTimer.ANTIVENOMPLUS_ANTIPOSION);
        }
        if (!this.config.showAntiFire()) {
            this.removeGameTimer(GameTimer.ANTIFIRE);
            this.removeGameTimer(GameTimer.EXANTIFIRE);
            this.removeGameTimer(GameTimer.SUPERANTIFIRE);
        }
        if (!this.config.showStamina()) {
            this.removeGameTimer(GameTimer.STAMINA);
        }
        if (!this.config.showOverload()) {
            this.removeGameTimer(GameTimer.OVERLOAD);
            this.removeGameTimer(GameTimer.OVERLOAD_RAID);
        }
        if (!this.config.showPrayerEnhance()) {
            this.removeGameTimer(GameTimer.PRAYER_ENHANCE);
        }
        if (!this.config.showCannon()) {
            this.removeGameTimer(GameTimer.CANNON);
        }
        if (!this.config.showMagicImbue()) {
            this.removeGameTimer(GameTimer.MAGICIMBUE);
        }
        if (!this.config.showCharge()) {
            this.removeGameTimer(GameTimer.CHARGE);
        }
        if (!this.config.showImbuedHeart()) {
            this.removeGameTimer(GameTimer.IMBUEDHEART);
        }
        if (!this.config.showStaffOfTheDead()) {
            this.removeGameTimer(GameTimer.STAFF_OF_THE_DEAD);
        }
        if (!this.config.showVengeance()) {
            this.removeGameTimer(GameTimer.VENGEANCE);
        }
        if (!this.config.showVengeanceActive()) {
            this.removeGameIndicator(GameIndicator.VENGEANCE_ACTIVE);
        }
        if (!this.config.showTeleblock()) {
            this.removeTbTimers();
        }
        if (!this.config.showFreezes()) {
            this.removeGameTimer(GameTimer.BIND);
            this.removeGameTimer(GameTimer.HALFBIND);
            this.removeGameTimer(GameTimer.SNARE);
            this.removeGameTimer(GameTimer.HALFSNARE);
            this.removeGameTimer(GameTimer.ENTANGLE);
            this.removeGameTimer(GameTimer.HALFENTANGLE);
            this.removeGameTimer(GameTimer.ICERUSH);
            this.removeGameTimer(GameTimer.ICEBURST);
            this.removeGameTimer(GameTimer.ICEBLITZ);
            this.removeGameTimer(GameTimer.ICEBARRAGE);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (this.config.showAntiPoison() && event.getMenuOption().contains("Drink") && (event.getId() == 5958 || event.getId() == 5956 || event.getId() == 5954 || event.getId() == 5952)) {
            this.createGameTimer(GameTimer.ANTIDOTEPLUSPLUS);
            return;
        }
        if (this.config.showAntiPoison() && event.getMenuOption().contains("Drink") && (event.getId() == 5949 || event.getId() == 5947 || event.getId() == 5945 || event.getId() == 5943 || event.getId() == 11503 || event.getId() == 11501)) {
            this.createGameTimer(GameTimer.ANTIDOTEPLUS);
            return;
        }
        if (this.config.showAntiPoison() && event.getMenuOption().contains("Drink") && (event.getId() == 179 || event.getId() == 177 || event.getId() == 175 || event.getId() == 2446 || event.getId() == 11435 || event.getId() == 11433)) {
            this.createGameTimer(GameTimer.ANTIPOISON);
            return;
        }
        if (this.config.showAntiPoison() && event.getMenuOption().contains("Drink") && (event.getId() == 185 || event.getId() == 183 || event.getId() == 181 || event.getId() == 2448 || event.getId() == 11475 || event.getId() == 11473)) {
            this.createGameTimer(GameTimer.SUPERANTIPOISON);
            return;
        }
        if (this.config.showStamina() && event.getMenuOption().contains("Drink") && (event.getId() == 12635 || event.getId() == 12633)) {
            this.createGameTimer(GameTimer.STAMINA);
            return;
        }
        if (this.config.showAntiFire() && event.getMenuOption().contains("Drink") && (event.getId() == 11507 || event.getId() == 11505)) {
            this.createGameTimer(GameTimer.ANTIFIRE);
            return;
        }
        if (this.config.showAntiFire() && event.getMenuOption().contains("Drink") && (event.getId() == 11962 || event.getId() == 11960)) {
            this.createGameTimer(GameTimer.EXANTIFIRE);
            return;
        }
        if (this.config.showAntiFire() && event.getMenuOption().contains("Drink") && (event.getId() == 21997 || event.getId() == 21994)) {
            this.createGameTimer(GameTimer.SUPERANTIFIRE);
            return;
        }
        if (this.config.showAntiFire() && event.getMenuOption().contains("Drink") && (event.getId() == 22224 || event.getId() == 22221)) {
            this.createGameTimer(GameTimer.EXSUPERANTIFIRE);
            return;
        }
        TeleportWidget teleportWidget = TeleportWidget.of(event.getWidgetId());
        if (teleportWidget != null) {
            this.lastTeleportClicked = teleportWidget;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (this.config.showStamina() && (event.getMessage().equals(STAMINA_DRINK_MESSAGE) || event.getMessage().equals(STAMINA_SHARED_DRINK_MESSAGE))) {
            this.createGameTimer(GameTimer.STAMINA);
        }
        if (this.config.showStamina() && event.getMessage().equals(STAMINA_EXPIRED_MESSAGE)) {
            this.removeGameTimer(GameTimer.STAMINA);
        }
        if (this.config.showAntiFire() && event.getMessage().equals(ANTIFIRE_DRINK_MESSAGE)) {
            this.createGameTimer(GameTimer.ANTIFIRE);
        }
        if (this.config.showAntiFire() && event.getMessage().equals(EXTENDED_ANTIFIRE_DRINK_MESSAGE)) {
            this.createGameTimer(GameTimer.EXANTIFIRE);
        }
        if (this.config.showGodWarsAltar() && event.getMessage().equalsIgnoreCase(GOD_WARS_ALTAR_MESSAGE)) {
            this.createGameTimer(GameTimer.GOD_WARS_ALTAR);
        }
        if (this.config.showAntiFire() && event.getMessage().equals(EXTENDED_SUPER_ANTIFIRE_DRINK_MESSAGE)) {
            this.createGameTimer(GameTimer.EXSUPERANTIFIRE);
        }
        if (this.config.showAntiFire() && event.getMessage().equals(ANTIFIRE_EXPIRED_MESSAGE)) {
            this.removeGameTimer(GameTimer.ANTIFIRE);
            this.removeGameTimer(GameTimer.EXANTIFIRE);
        }
        if (this.config.showOverload() && event.getMessage().startsWith("You drink some of your") && event.getMessage().contains("overload")) {
            if (this.client.getVar(Varbits.IN_RAID) == 1) {
                this.createGameTimer(GameTimer.OVERLOAD_RAID);
            } else {
                this.createGameTimer(GameTimer.OVERLOAD);
            }
        }
        if (this.config.showCannon() && (event.getMessage().equals(CANNON_FURNACE_MESSAGE) || event.getMessage().contains(CANNON_REPAIR_MESSAGE))) {
            this.createGameTimer(GameTimer.CANNON);
        }
        if (this.config.showCannon() && event.getMessage().equals(CANNON_PICKUP_MESSAGE)) {
            this.removeGameTimer(GameTimer.CANNON);
        }
        if (this.config.showAntiPoison() && event.getMessage().contains(SUPER_ANTIVENOM_DRINK_MESSAGE)) {
            this.createGameTimer(GameTimer.ANTIVENOMPLUS);
            this.createGameTimer(GameTimer.ANTIVENOMPLUS_ANTIPOSION);
        }
        if (this.config.showMagicImbue() && event.getMessage().equals(MAGIC_IMBUE_MESSAGE)) {
            this.createGameTimer(GameTimer.MAGICIMBUE);
        }
        if (event.getMessage().equals(MAGIC_IMBUE_EXPIRED_MESSAGE)) {
            this.removeGameTimer(GameTimer.MAGICIMBUE);
        }
        if (this.config.showTeleblock() && event.getMessage().equals(FULL_TELEBLOCK_MESSAGE)) {
            this.createGameTimer(GameTimer.FULLTB);
        }
        if (this.config.showTeleblock() && event.getMessage().equals(HALF_TELEBLOCK_MESSAGE)) {
            if (this.client.getWorldType().contains((Object)WorldType.DEADMAN) && !this.client.getWorldType().contains((Object)WorldType.SEASONAL_DEADMAN) && !this.client.getWorldType().contains((Object)WorldType.DEADMAN_TOURNAMENT)) {
                this.createGameTimer(GameTimer.DMM_FULLTB);
            } else {
                this.createGameTimer(GameTimer.HALFTB);
            }
        }
        if (this.config.showTeleblock() && event.getMessage().equals(DEADMAN_HALF_TELEBLOCK_MESSAGE)) {
            this.createGameTimer(GameTimer.DMM_HALFTB);
        }
        if (this.config.showAntiFire() && event.getMessage().contains(SUPER_ANTIFIRE_DRINK_MESSAGE)) {
            this.createGameTimer(GameTimer.SUPERANTIFIRE);
        }
        if (this.config.showAntiFire() && event.getMessage().equals(SUPER_ANTIFIRE_EXPIRED_MESSAGE)) {
            this.removeGameTimer(GameTimer.SUPERANTIFIRE);
        }
        if (this.config.showImbuedHeart() && event.getMessage().equals(IMBUED_HEART_READY_MESSAGE)) {
            this.removeGameTimer(GameTimer.IMBUEDHEART);
        }
        if (this.config.showAntiPoison() && event.getMessage().contains(ANTIVENOM_DRINK_MESSAGE)) {
            this.createGameTimer(GameTimer.ANTIVENOM);
            this.createGameTimer(GameTimer.ANTIVENOM_ANTIPOISON);
        }
        if (this.config.showAntiPoison() && event.getMessage().contains(SANFEW_SERUM_DRINK_MESSAGE)) {
            this.createGameTimer(GameTimer.SANFEW);
        }
        if (this.config.showPrayerEnhance() && event.getMessage().startsWith("You drink some of your") && event.getMessage().contains("prayer enhance")) {
            this.createGameTimer(GameTimer.PRAYER_ENHANCE);
        }
        if (this.config.showCharge() && event.getMessage().equals(CHARGE_MESSAGE)) {
            this.createGameTimer(GameTimer.CHARGE);
        }
        if (this.config.showCharge() && event.getMessage().equals(CHARGE_EXPIRED_MESSAGE)) {
            this.removeGameTimer(GameTimer.CHARGE);
        }
        if (this.config.showStaffOfTheDead() && event.getMessage().contains(STAFF_OF_THE_DEAD_SPEC_MESSAGE)) {
            this.createGameTimer(GameTimer.STAFF_OF_THE_DEAD);
        }
        if (this.config.showStaffOfTheDead() && event.getMessage().contains(STAFF_OF_THE_DEAD_SPEC_EXPIRED_MESSAGE)) {
            this.removeGameTimer(GameTimer.STAFF_OF_THE_DEAD);
        }
        if (this.config.showFreezes() && event.getMessage().equals(FROZEN_MESSAGE)) {
            this.freezeTimer = this.createGameTimer(GameTimer.ICEBARRAGE);
            this.freezeTime = this.client.getTickCount();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.loggedInRace = false;
        Player player = this.client.getLocalPlayer();
        WorldPoint currentWorldPoint = player.getWorldLocation();
        if (this.freezeTimer != null && this.freezeTime != this.client.getTickCount() && !currentWorldPoint.equals(this.lastPoint)) {
            this.removeGameTimer(this.freezeTimer.getTimer());
            this.freezeTimer = null;
        }
        this.lastPoint = currentWorldPoint;
        if (!this.widgetHiddenChangedOnPvpWorld) {
            return;
        }
        this.widgetHiddenChangedOnPvpWorld = false;
        Widget widget = this.client.getWidget(WidgetInfo.PVP_WORLD_SAFE_ZONE);
        if (widget != null && !widget.isSelfHidden()) {
            log.debug("Entered safe zone in PVP world, clearing Teleblock timer.");
            this.removeTbTimers();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case HOPPING: 
            case LOGIN_SCREEN: {
                this.removeTbTimers();
                break;
            }
            case LOGGED_IN: {
                this.loggedInRace = true;
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Actor actor = event.getActor();
        if (this.config.showAbyssalSireStun() && actor instanceof NPC) {
            int npcId = ((NPC)actor).getId();
            switch (npcId) {
                case 5887: {
                    this.createGameTimer(GameTimer.ABYSSAL_SIRE_STUN);
                    break;
                }
                case 5886: 
                case 5888: 
                case 5889: 
                case 5890: 
                case 5891: 
                case 5908: {
                    this.removeGameTimer(GameTimer.ABYSSAL_SIRE_STUN);
                }
            }
        }
        if (actor != this.client.getLocalPlayer()) {
            return;
        }
        this.lastAnimation = this.client.getLocalPlayer().getAnimation();
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        Actor actor = event.getActor();
        if (actor != this.client.getLocalPlayer()) {
            return;
        }
        if (this.config.showImbuedHeart() && actor.getGraphic() == GameTimer.IMBUEDHEART.getGraphicId().intValue()) {
            this.createGameTimer(GameTimer.IMBUEDHEART);
        }
        if (this.config.showFreezes()) {
            if (actor.getGraphic() == GameTimer.BIND.getGraphicId().intValue()) {
                if (this.client.isPrayerActive(Prayer.PROTECT_FROM_MAGIC) && !this.client.getWorldType().contains((Object)WorldType.SEASONAL_DEADMAN) && !this.client.getWorldType().contains((Object)WorldType.DEADMAN_TOURNAMENT)) {
                    this.createGameTimer(GameTimer.HALFBIND);
                } else {
                    this.createGameTimer(GameTimer.BIND);
                }
            }
            if (actor.getGraphic() == GameTimer.SNARE.getGraphicId().intValue()) {
                if (this.client.isPrayerActive(Prayer.PROTECT_FROM_MAGIC) && !this.client.getWorldType().contains((Object)WorldType.SEASONAL_DEADMAN) && !this.client.getWorldType().contains((Object)WorldType.DEADMAN_TOURNAMENT)) {
                    this.createGameTimer(GameTimer.HALFSNARE);
                } else {
                    this.createGameTimer(GameTimer.SNARE);
                }
            }
            if (actor.getGraphic() == GameTimer.ENTANGLE.getGraphicId().intValue()) {
                if (this.client.isPrayerActive(Prayer.PROTECT_FROM_MAGIC) && !this.client.getWorldType().contains((Object)WorldType.SEASONAL_DEADMAN) && !this.client.getWorldType().contains((Object)WorldType.DEADMAN_TOURNAMENT)) {
                    this.createGameTimer(GameTimer.HALFENTANGLE);
                } else {
                    this.createGameTimer(GameTimer.ENTANGLE);
                }
            }
            if (this.freezeTime == this.client.getTickCount()) {
                if (actor.getGraphic() == GameTimer.ICERUSH.getGraphicId().intValue()) {
                    this.removeGameTimer(GameTimer.ICEBARRAGE);
                    this.freezeTimer = this.createGameTimer(GameTimer.ICERUSH);
                }
                if (actor.getGraphic() == GameTimer.ICEBURST.getGraphicId().intValue()) {
                    this.removeGameTimer(GameTimer.ICEBARRAGE);
                    this.freezeTimer = this.createGameTimer(GameTimer.ICEBURST);
                }
                if (actor.getGraphic() == GameTimer.ICEBLITZ.getGraphicId().intValue()) {
                    this.removeGameTimer(GameTimer.ICEBARRAGE);
                    this.freezeTimer = this.createGameTimer(GameTimer.ICEBLITZ);
                }
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        ItemContainer container = itemContainerChanged.getItemContainer();
        if (container == this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            Item[] items = container.getItems();
            int weaponIdx = EquipmentInventorySlot.WEAPON.getSlotIdx();
            if (items == null || weaponIdx >= items.length) {
                this.removeGameTimer(GameTimer.STAFF_OF_THE_DEAD);
                return;
            }
            Item weapon = items[weaponIdx];
            if (weapon == null) {
                this.removeGameTimer(GameTimer.STAFF_OF_THE_DEAD);
                return;
            }
            switch (weapon.getId()) {
                case 11791: 
                case 12902: 
                case 12904: 
                case 22296: {
                    return;
                }
            }
            this.removeGameTimer(GameTimer.STAFF_OF_THE_DEAD);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        if (!npc.isDead()) {
            return;
        }
        int npcId = npc.getId();
        if (npcId == 8062 || npcId == 8063) {
            this.removeGameTimer(GameTimer.ICEBARRAGE);
        }
    }

    @Subscribe
    public void onLocalPlayerDeath(LocalPlayerDeath event) {
        this.infoBoxManager.removeIf(t -> t instanceof TimerTimer && ((TimerTimer)t).getTimer().isRemovedOnDeath());
    }

    private TimerTimer createGameTimer(GameTimer timer) {
        this.removeGameTimer(timer);
        BufferedImage image = timer.getImage(this.itemManager, this.spriteManager);
        TimerTimer t = new TimerTimer(timer, this, image);
        t.setTooltip(timer.getDescription());
        this.infoBoxManager.addInfoBox(t);
        return t;
    }

    private void removeGameTimer(GameTimer timer) {
        this.infoBoxManager.removeIf(t -> t instanceof TimerTimer && ((TimerTimer)t).getTimer() == timer);
    }

    private IndicatorIndicator createGameIndicator(GameIndicator gameIndicator) {
        this.removeGameIndicator(gameIndicator);
        BufferedImage image = gameIndicator.getImage(this.itemManager, this.spriteManager);
        IndicatorIndicator indicator = new IndicatorIndicator(gameIndicator, image, this);
        indicator.setTooltip(gameIndicator.getDescription());
        this.infoBoxManager.addInfoBox(indicator);
        return indicator;
    }

    private void removeGameIndicator(GameIndicator indicator) {
        this.infoBoxManager.removeIf(t -> t instanceof IndicatorIndicator && ((IndicatorIndicator)t).getIndicator() == indicator);
    }

    private void removeTbTimers() {
        this.removeGameTimer(GameTimer.FULLTB);
        this.removeGameTimer(GameTimer.HALFTB);
        this.removeGameTimer(GameTimer.DMM_FULLTB);
        this.removeGameTimer(GameTimer.DMM_HALFTB);
    }
}

