/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timers;

import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.timers.GameTimer;
import net.runelite.client.ui.overlay.infobox.InfoBoxPriority;
import net.runelite.client.ui.overlay.infobox.Timer;

class TimerTimer
extends Timer {
    private final GameTimer timer;

    TimerTimer(GameTimer timer, Plugin plugin, BufferedImage image) {
        super(timer.getDuration().toMillis(), ChronoUnit.MILLIS, image, plugin);
        this.timer = timer;
        this.setPriority(InfoBoxPriority.MED);
    }

    @Override
    public boolean render() {
        boolean rendered = super.render();
        if (rendered) {
            Duration fromStart = Duration.between(this.getStartTime(), Instant.now());
            return !fromStart.minus(this.timer.getInitialDelay()).isNegative();
        }
        return false;
    }

    public GameTimer getTimer() {
        return this.timer;
    }
}

