/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timers;

import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.timers.GameTimerImageType;

enum GameTimer {
    STAMINA(12625, GameTimerImageType.ITEM, "Stamina", 2L, ChronoUnit.MINUTES, true),
    ANTIFIRE(2452, GameTimerImageType.ITEM, "Antifire", 6L, ChronoUnit.MINUTES),
    EXANTIFIRE(11951, GameTimerImageType.ITEM, "Extended antifire", 12L, ChronoUnit.MINUTES),
    OVERLOAD(11730, GameTimerImageType.ITEM, "Overload", 5L, ChronoUnit.MINUTES, true),
    CANNON(10, GameTimerImageType.ITEM, "Cannon", 25L, ChronoUnit.MINUTES),
    MAGICIMBUE(552, GameTimerImageType.SPRITE, "Magic imbue", 12L, ChronoUnit.SECONDS),
    FULLTB(352, GameTimerImageType.SPRITE, "Full Teleblock", 5L, ChronoUnit.MINUTES, true),
    HALFTB(352, GameTimerImageType.SPRITE, "Half Teleblock", 150L, ChronoUnit.SECONDS, true),
    DMM_FULLTB(352, GameTimerImageType.SPRITE, "Deadman Mode Full Teleblock", 150L, ChronoUnit.SECONDS, true),
    DMM_HALFTB(352, GameTimerImageType.SPRITE, "Deadman Mode Half Teleblock", 75L, ChronoUnit.SECONDS, true),
    ANTIVENOMPLUS(12913, GameTimerImageType.ITEM, "Anti-venom+", 3L, ChronoUnit.MINUTES, true),
    ANTIVENOMPLUS_ANTIPOSION(2448, GameTimerImageType.ITEM, "Anti-venom+ Antipoison", 15L, ChronoUnit.MINUTES, 3L),
    SUPERANTIFIRE(21978, GameTimerImageType.ITEM, "Super antifire", 3L, ChronoUnit.MINUTES),
    ANTIDOTEPLUSPLUS(5952, GameTimerImageType.ITEM, "Antidote++", 12L, ChronoUnit.MINUTES),
    BIND(319, GameTimerImageType.SPRITE, "Bind", 181, 5L, ChronoUnit.SECONDS, true),
    HALFBIND(319, GameTimerImageType.SPRITE, "Half Bind", 181, 2500L, ChronoUnit.MILLIS, true),
    SNARE(320, GameTimerImageType.SPRITE, "Snare", 180, 10L, ChronoUnit.SECONDS, true),
    HALFSNARE(320, GameTimerImageType.SPRITE, "Half Snare", 180, 5L, ChronoUnit.SECONDS, true),
    ENTANGLE(321, GameTimerImageType.SPRITE, "Entangle", 179, 15L, ChronoUnit.SECONDS, true),
    HALFENTANGLE(321, GameTimerImageType.SPRITE, "Half Entangle", 179, 7500L, ChronoUnit.MILLIS, true),
    ICERUSH(325, GameTimerImageType.SPRITE, "Ice rush", 361, 5L, ChronoUnit.SECONDS, true),
    ICEBURST(326, GameTimerImageType.SPRITE, "Ice burst", 363, 10L, ChronoUnit.SECONDS, true),
    ICEBLITZ(327, GameTimerImageType.SPRITE, "Ice blitz", 367, 15L, ChronoUnit.SECONDS, true),
    ICEBARRAGE(328, GameTimerImageType.SPRITE, "Ice barrage", 369, 20L, ChronoUnit.SECONDS, true),
    IMBUEDHEART(20724, GameTimerImageType.ITEM, "Imbued heart", (Integer)1316, 420L, ChronoUnit.SECONDS),
    VENGEANCE(564, GameTimerImageType.SPRITE, "Vengeance", 30L, ChronoUnit.SECONDS),
    ANTIDOTEPLUS(5943, GameTimerImageType.ITEM, "Antidote+", 518L, ChronoUnit.SECONDS),
    ANTIVENOM(12905, GameTimerImageType.ITEM, "Anti-venom", 1L, ChronoUnit.MINUTES, true),
    ANTIVENOM_ANTIPOISON(2446, GameTimerImageType.ITEM, "Anti-venom Antipoison", 12L, ChronoUnit.MINUTES, 1L),
    EXSUPERANTIFIRE(22209, GameTimerImageType.ITEM, "Extended Super AntiFire", 6L, ChronoUnit.MINUTES),
    SANFEW(10925, GameTimerImageType.ITEM, "Sanfew serum", 6L, ChronoUnit.MINUTES, true),
    OVERLOAD_RAID(20996, GameTimerImageType.ITEM, "Overload", 5L, ChronoUnit.MINUTES, true),
    PRAYER_ENHANCE(20964, GameTimerImageType.ITEM, "Prayer enhance", 290L, ChronoUnit.SECONDS, true),
    GOD_WARS_ALTAR(201, GameTimerImageType.SPRITE, "God wars altar", 10L, ChronoUnit.MINUTES),
    ANTIPOISON(2446, GameTimerImageType.ITEM, "Antipoison", 90L, ChronoUnit.SECONDS),
    SUPERANTIPOISON(2448, GameTimerImageType.ITEM, "Superantipoison", 346L, ChronoUnit.SECONDS),
    CHARGE(322, GameTimerImageType.SPRITE, "Charge", 6L, ChronoUnit.MINUTES),
    STAFF_OF_THE_DEAD(11791, GameTimerImageType.ITEM, "Staff of the Dead", 1L, ChronoUnit.MINUTES),
    ABYSSAL_SIRE_STUN(13262, GameTimerImageType.ITEM, "Abyssal Sire Stun", 30L, ChronoUnit.SECONDS, true),
    HOME_TELEPORT(356, GameTimerImageType.SPRITE, "Home Teleport", 30L, ChronoUnit.MINUTES),
    MINIGAME_TELEPORT(1053, GameTimerImageType.SPRITE, "Minigame Teleport", 20L, ChronoUnit.MINUTES);

    private final Duration duration;
    private final Integer graphicId;
    private final String description;
    private final boolean removedOnDeath;
    private final Duration initialDelay;
    private final int imageId;
    private final GameTimerImageType imageType;

    private GameTimer(int imageId, GameTimerImageType idType, String description, Integer graphicId, long time, ChronoUnit unit, long delay, boolean removedOnDeath) {
        this.description = description;
        this.graphicId = graphicId;
        this.duration = Duration.of(time, unit);
        this.imageId = imageId;
        this.imageType = idType;
        this.removedOnDeath = removedOnDeath;
        this.initialDelay = Duration.of(delay, unit);
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description, Integer graphicId, long time, ChronoUnit unit, boolean removedOnDeath) {
        this(imageId, idType, description, graphicId, time, unit, 0L, removedOnDeath);
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description, long time, ChronoUnit unit, boolean removeOnDeath) {
        this(imageId, idType, description, null, time, unit, removeOnDeath);
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description, long time, ChronoUnit unit) {
        this(imageId, idType, description, null, time, unit, false);
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description, Integer graphicId, long time, ChronoUnit unit) {
        this(imageId, idType, description, graphicId, time, unit, false);
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description, long time, ChronoUnit unit, long delay) {
        this(imageId, idType, description, null, time, unit, delay, false);
    }

    BufferedImage getImage(ItemManager itemManager, SpriteManager spriteManager) {
        switch (this.imageType) {
            case ITEM: {
                return itemManager.getImage(this.imageId);
            }
            case SPRITE: {
                return spriteManager.getSprite(this.imageId, 0);
            }
        }
        return null;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Integer getGraphicId() {
        return this.graphicId;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRemovedOnDeath() {
        return this.removedOnDeath;
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }
}

