/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timers;

import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.timers.GameTimerImageType;

enum GameIndicator {
    VENGEANCE_ACTIVE(561, GameTimerImageType.SPRITE, "Vengeance active");

    private final String description;
    private String text;
    private Color textColor;
    private final int imageId;
    private final GameTimerImageType imageType;

    private GameIndicator(int imageId, GameTimerImageType idType, String description, String text, Color textColor) {
        this.imageId = imageId;
        this.imageType = idType;
        this.description = description;
        this.text = text;
        this.textColor = textColor;
    }

    private GameIndicator(int imageId, GameTimerImageType idType, String description) {
        this(imageId, idType, description, "", null);
    }

    BufferedImage getImage(ItemManager itemManager, SpriteManager spriteManager) {
        switch (this.imageType) {
            case ITEM: {
                return itemManager.getImage(this.imageId);
            }
            case SPRITE: {
                return spriteManager.getSprite(this.imageId, 0);
            }
        }
        return null;
    }

    String getDescription() {
        return this.description;
    }

    String getText() {
        return this.text;
    }

    Color getTextColor() {
        return this.textColor;
    }
}

