/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.tileindicators;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.tileindicators.TileIndicatorsConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class TileIndicatorsOverlay
extends Overlay {
    private final Client client;
    private final TileIndicatorsConfig config;

    @Inject
    private TileIndicatorsOverlay(Client client2, TileIndicatorsConfig config) {
        this.client = client2;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.MED);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.config.highlightHoveredTile()) {
            if (!this.client.isMenuOpen()) {
                Point p = this.client.getMouseCanvasPosition();
                p = new Point(p.getX() - this.client.getViewportXOffset(), p.getY() - this.client.getViewportYOffset());
                this.client.setCheckClick(true);
                this.client.setMouseCanvasHoverPosition(p);
            }
            if (this.client.getSelectedSceneTile() != null) {
                this.renderTile(graphics, this.client.getSelectedSceneTile().getLocalLocation(), this.config.highlightHoveredColor());
            }
        }
        if (this.config.highlightDestinationTile()) {
            this.renderTile(graphics, this.client.getLocalDestinationLocation(), this.config.highlightDestinationColor());
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, LocalPoint dest, Color color) {
        if (dest == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly(this.client, dest);
        if (poly == null) {
            return;
        }
        OverlayUtil.renderPolygon(graphics, poly, color);
    }
}

