/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.tearsofguthix;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Point;
import net.runelite.client.plugins.tearsofguthix.TearsOfGuthixPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;

class TearsOfGuthixOverlay
extends Overlay {
    private static final Color CYAN_ALPHA = new Color(Color.CYAN.getRed(), Color.CYAN.getGreen(), Color.CYAN.getBlue(), 100);
    private static final Duration MAX_TIME = Duration.ofSeconds(9L);
    private final TearsOfGuthixPlugin plugin;

    @Inject
    private TearsOfGuthixOverlay(TearsOfGuthixPlugin plugin) {
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        this.plugin.getStreams().forEach((object, timer) -> {
            Point position = object.getCanvasLocation(100);
            if (position == null) {
                return;
            }
            ProgressPieComponent progressPie = new ProgressPieComponent();
            progressPie.setDiameter(15);
            progressPie.setFill(CYAN_ALPHA);
            progressPie.setBorderColor(Color.CYAN);
            progressPie.setPosition(position);
            Duration duration = Duration.between(timer, Instant.now());
            progressPie.setProgress(1.0 - (duration.compareTo(MAX_TIME) < 0 ? (double)duration.toMillis() / (double)MAX_TIME.toMillis() : 1.0));
            progressPie.render(graphics);
        });
        return null;
    }
}

