/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.teamcapes;

import com.google.inject.Provides;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.teamcapes.TeamCapesConfig;
import net.runelite.client.plugins.teamcapes.TeamCapesOverlay;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Team Capes", description="Show the different team capes in your area and the amount of each", tags={"overlay", "players"}, enabledByDefault=false)
public class TeamCapesPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TeamCapesOverlay overlay;
    private Map<Integer, Integer> teams = new HashMap<Integer, Integer>();

    @Provides
    TeamCapesConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(TeamCapesConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.teams.clear();
    }

    @Schedule(period=1800L, unit=ChronoUnit.MILLIS)
    public void update() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        List<Player> players = this.client.getPlayers();
        this.teams.clear();
        for (Player player : players) {
            int team = player.getTeam();
            if (team <= 0) continue;
            if (this.teams.containsKey(team)) {
                this.teams.put(team, this.teams.get(team) + 1);
                continue;
            }
            this.teams.put(team, 1);
        }
        this.teams = this.teams.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue, Comparator.reverseOrder()).thenComparingInt(Map.Entry::getKey)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public Map<Integer, Integer> getTeams() {
        return this.teams;
    }
}

