/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.teamcapes;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.teamcapes.TeamCapesConfig;
import net.runelite.client.plugins.teamcapes.TeamCapesPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class TeamCapesOverlay
extends Overlay {
    private final PanelComponent panelComponent = new PanelComponent();
    private final TeamCapesPlugin plugin;
    private final TeamCapesConfig config;
    private final ItemManager manager;

    @Inject
    private TeamCapesOverlay(TeamCapesPlugin plugin, TeamCapesConfig config, ItemManager manager) {
        super(plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.plugin = plugin;
        this.config = config;
        this.manager = manager;
        this.panelComponent.setOrientation(PanelComponent.Orientation.HORIZONTAL);
        this.panelComponent.setWrapping(4);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Teamcapes overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Map<Integer, Integer> teams = this.plugin.getTeams();
        if (teams.isEmpty()) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        for (Map.Entry<Integer, Integer> team : teams.entrySet()) {
            if (team.getValue() < this.config.getMinimumCapeCount()) continue;
            int teamcapeNumber = team.getKey() - 1;
            int itemID = teamcapeNumber < 50 ? 2 * teamcapeNumber + 4315 : 3 * (teamcapeNumber - 50) + 20211;
            this.panelComponent.getChildren().add(new ImageComponent(this.manager.getImage(itemID, team.getValue(), true)));
        }
        return this.panelComponent.render(graphics);
    }
}

