/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.suppliestracker;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.VarPlayer;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.suppliestracker.ActionType;
import net.runelite.client.plugins.suppliestracker.MenuAction;
import net.runelite.client.plugins.suppliestracker.SuppliesTrackerConfig;
import net.runelite.client.plugins.suppliestracker.SuppliesTrackerItem;
import net.runelite.client.plugins.suppliestracker.SuppliesTrackerPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.item.ItemPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Supplies Used Tracker", description="Tracks supplies used during the session", tags={"cost"}, enabledByDefault=false)
public class SuppliesTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SuppliesTrackerPlugin.class);
    private static final String POTION_PATTERN = "[(]\\d[)]";
    private static final String EAT_PATTERN = "^eat";
    private static final String DRINK_PATTERN = "^drink";
    private static final String TELEPORT_PATTERN = "^teleport";
    private static final String TELETAB_PATTERN = "^break";
    private static final String SPELL_PATTERN = "^cast|^grand\\sexchange|^outside|^seers|^yanille";
    private static final int EQUIPMENT_MAINHAND_SLOT = EquipmentInventorySlot.WEAPON.getSlotIdx();
    private static final int EQUIPMENT_AMMO_SLOT = EquipmentInventorySlot.AMMO.getSlotIdx();
    private static final int EQUIPMENT_CAPE_SLOT = EquipmentInventorySlot.CAPE.getSlotIdx();
    private static final double NO_AVAS_PERCENT = 1.0;
    private static final double ASSEMBLER_PERCENT = 0.2;
    private static final double ACCUMULATOR_PERCENT = 0.28;
    private static final double ATTRACTOR_PERCENT = 0.4;
    private static final int BLOWPIPE_TICKS_RAPID_PVM = 2;
    private static final int BLOWPIPE_TICKS_RAPID_PVP = 3;
    private static final int BLOWPIPE_TICKS_NORMAL_PVM = 3;
    private static final int BLOWPIPE_TICKS_NORMAL_PVP = 4;
    private static final double SCALES_PERCENT = 0.66;
    private static final int POTION_DOSES = 4;
    private static final int CAKE_DOSES = 3;
    private static final int PIZZA_PIE_DOSES = 2;
    private static final Random random = new Random();
    private static final int[] THROWING_IDS = new int[]{806, 807, 808, 3093, 809, 810, 811, 11230, 864, 863, 865, 869, 866, 867, 868, 800, 801, 802, 803, 804, 805, 22804, 22812, 22814, 22808, 22810, 22806, 20849, 10033, 10034, 11959};
    private static final int[] RUNE_IDS = new int[]{556, 555, 557, 558, 559, 564, 562, 561, 563, 560, 9075, 565, 566, 21880, 4695, 4696, 4698, 4697, 4694, 4699};
    private static HashMap<Integer, SuppliesTrackerItem> suppliesEntry = new HashMap();
    private ItemContainer old;
    private Deque<MenuAction> actionStack = new ArrayDeque<MenuAction>();
    private int ammoId = 0;
    private int ammoAmount = 0;
    private int thrownId = 0;
    private int thrownAmount = 0;
    private boolean ammoLoaded = false;
    private boolean throwingAmmoLoaded = false;
    private boolean mainHandThrowing = false;
    private int mainHand = 0;
    private SuppliesTrackerPanel panel;
    private NavigationButton navButton;
    private String[] RAIDS_CONSUMABLES = new String[]{"xeric's", "elder", "twisted", "revitalisation", "overload", "prayer enhance", "pysk", "suphi", "leckish", "brawk", "mycil", "roqed", "kyren", "guanic", "prael", "giral", "phluxia", "kryket", "murng", "psykk"};
    private int attackStyleVarbit = -1;
    private int ticks = 0;
    private int ticksInAnimation;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SuppliesTrackerConfig config;
    @Inject
    private Client client;

    @Override
    protected void startUp() throws Exception {
        this.panel = new SuppliesTrackerPanel(this.itemManager, this);
        BufferedImage header = ImageUtil.getResourceStreamFromClass(this.getClass(), "panel_icon.png");
        this.panel.loadHeaderIcon(header);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "panel_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Supplies Tracker").icon(icon).priority(5).panel(this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Override
    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Provides
    SuppliesTrackerConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(SuppliesTrackerConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        Player player = this.client.getLocalPlayer();
        if (player.getAnimation() == 5061) {
            ++this.ticks;
        }
        if (this.ticks == this.ticksInAnimation && player.getAnimation() == 5061) {
            double ava_percent = this.getAccumulatorPercent();
            if (random.nextDouble() <= ava_percent) {
                this.buildEntries(this.config.blowpipeAmmo().getDartID());
            }
            if (random.nextDouble() <= 0.66) {
                this.buildEntries(12934);
            }
            this.ticks = 0;
        }
    }

    private double getAccumulatorPercent() {
        double percent = 1.0;
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment != null && equipment.getItems().length > EQUIPMENT_CAPE_SLOT) {
            int capeID = equipment.getItems()[EQUIPMENT_CAPE_SLOT].getId();
            switch (capeID) {
                case 21898: 
                case 22109: {
                    percent = 0.2;
                    break;
                }
                case 9756: 
                case 10499: 
                case 13337: {
                    percent = 0.28;
                    break;
                }
                case 10498: {
                    percent = 0.4;
                }
            }
        }
        return percent;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.attackStyleVarbit == -1 || this.attackStyleVarbit != this.client.getVar(VarPlayer.ATTACK_STYLE)) {
            this.attackStyleVarbit = this.client.getVar(VarPlayer.ATTACK_STYLE);
            if (this.attackStyleVarbit == 0 || this.attackStyleVarbit == 3) {
                this.ticksInAnimation = 3;
                if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getInteracting() instanceof Player) {
                    this.ticksInAnimation = 4;
                }
            } else if (this.attackStyleVarbit == 1) {
                this.ticksInAnimation = 2;
                if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getInteracting() instanceof Player) {
                    this.ticksInAnimation = 3;
                }
            }
        }
    }

    private void checkUsedRunes(ItemContainer itemContainer, Item[] oldInv) {
        try {
            for (int i = 0; i < itemContainer.getItems().length; ++i) {
                Item newItem = itemContainer.getItems()[i];
                Item oldItem = oldInv[i];
                boolean isRune = false;
                for (int runeId : RUNE_IDS) {
                    if (oldItem.getId() != runeId) continue;
                    isRune = true;
                }
                if (!isRune || newItem.getId() == oldItem.getId() && newItem.getQuantity() == oldItem.getQuantity()) continue;
                int quantity = oldItem.getQuantity();
                if (newItem.getId() == oldItem.getId()) {
                    quantity -= newItem.getQuantity();
                }
                this.buildEntries(oldItem.getId(), quantity);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        if (animationChanged.getActor() == this.client.getLocalPlayer()) {
            if (animationChanged.getActor().getAnimation() == 1167) {
                if (this.mainHand == 11907 || this.mainHand == 22288 || this.mainHand == 11905) {
                    this.buildEntries(562);
                    this.buildEntries(560);
                    this.buildEntries(554, 5);
                    this.buildEntries(995, 10);
                } else if (this.mainHand == 22292 || this.mainHand == 12899 || this.mainHand == 22294 || this.mainHand == 12900) {
                    this.buildEntries(562);
                    this.buildEntries(560);
                    this.buildEntries(554, 5);
                    this.buildEntries(12934);
                } else if (this.mainHand == 22323 || this.mainHand == 22481) {
                    this.buildEntries(565, 3);
                } else {
                    this.old = this.client.getItemContainer(InventoryID.INVENTORY);
                    if (this.old != null && this.old.getItems() != null && this.actionStack.stream().noneMatch(a -> a.getType() == ActionType.CAST)) {
                        MenuAction newAction = new MenuAction(ActionType.CAST, this.old.getItems());
                        this.actionStack.push(newAction);
                    }
                }
            } else if (animationChanged.getActor().getAnimation() == 1162) {
                this.old = this.client.getItemContainer(InventoryID.INVENTORY);
                if (this.old != null && this.old.getItems() != null && this.actionStack.stream().noneMatch(a -> a.getType() == ActionType.CAST)) {
                    MenuAction newAction = new MenuAction(ActionType.CAST, this.old.getItems());
                    this.actionStack.push(newAction);
                }
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        ItemContainer itemContainer = itemContainerChanged.getItemContainer();
        if (itemContainer == this.client.getItemContainer(InventoryID.INVENTORY) && this.old != null && !this.actionStack.isEmpty()) {
            while (!this.actionStack.isEmpty()) {
                MenuAction frame = this.actionStack.pop();
                ActionType type = frame.getType();
                Item[] oldInv = frame.getOldInventory();
                switch (type) {
                    case CONSUMABLE: {
                        MenuAction.ItemAction itemFrame = (MenuAction.ItemAction)frame;
                        int nextItem = itemFrame.getItemID();
                        int nextSlot = itemFrame.getSlot();
                        if (itemContainer.getItems()[nextSlot].getId() == oldInv[nextSlot].getId()) break;
                        this.buildEntries(nextItem);
                        break;
                    }
                    case TELEPORT: {
                        MenuAction.ItemAction itemFrame = (MenuAction.ItemAction)frame;
                        int teleid = itemFrame.getItemID();
                        int slot = itemFrame.getSlot();
                        if (itemContainer.getItems()[slot].getId() == oldInv[slot].getId() && itemContainer.getItems()[slot].getQuantity() == oldInv[slot].getQuantity()) break;
                        this.buildEntries(teleid);
                        break;
                    }
                    case CAST: {
                        this.checkUsedRunes(itemContainer, oldInv);
                    }
                }
            }
        }
        if (itemContainer == this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            Item ammoSlot;
            if (itemContainer.getItems().length > EQUIPMENT_MAINHAND_SLOT) {
                this.mainHand = itemContainer.getItems()[EQUIPMENT_MAINHAND_SLOT].getId();
                Item mainHandItem = itemContainer.getItems()[EQUIPMENT_MAINHAND_SLOT];
                for (int throwingIDs : THROWING_IDS) {
                    if (this.mainHand == throwingIDs) {
                        this.mainHandThrowing = true;
                        break;
                    }
                    this.mainHandThrowing = false;
                }
                if (this.mainHandThrowing) {
                    if (this.throwingAmmoLoaded) {
                        if (this.thrownId == mainHandItem.getId()) {
                            if (this.thrownAmount - 1 == mainHandItem.getQuantity()) {
                                this.buildEntries(mainHandItem.getId());
                                this.thrownAmount = mainHandItem.getQuantity();
                            } else {
                                this.thrownAmount = mainHandItem.getQuantity();
                            }
                        } else {
                            this.thrownId = mainHandItem.getId();
                            this.thrownAmount = mainHandItem.getQuantity();
                        }
                    } else {
                        this.thrownId = mainHandItem.getId();
                        this.thrownAmount = mainHandItem.getQuantity();
                        this.throwingAmmoLoaded = true;
                    }
                }
            }
            if (itemContainer.getItems().length > EQUIPMENT_AMMO_SLOT && (ammoSlot = itemContainer.getItems()[EQUIPMENT_AMMO_SLOT]) != null) {
                if (this.ammoLoaded) {
                    if (this.ammoId == ammoSlot.getId()) {
                        if (this.ammoAmount - 1 == ammoSlot.getQuantity()) {
                            this.buildEntries(ammoSlot.getId());
                            this.ammoAmount = ammoSlot.getQuantity();
                        } else {
                            this.ammoAmount = ammoSlot.getQuantity();
                        }
                    } else {
                        this.ammoId = ammoSlot.getId();
                        this.ammoAmount = ammoSlot.getQuantity();
                    }
                } else {
                    this.ammoId = ammoSlot.getId();
                    this.ammoAmount = ammoSlot.getQuantity();
                    this.ammoLoaded = true;
                }
            }
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        Pattern spellPattern;
        MenuAction newAction;
        Pattern eatPattern = Pattern.compile(EAT_PATTERN);
        Pattern drinkPattern = Pattern.compile(DRINK_PATTERN);
        if ((eatPattern.matcher(event.getMenuTarget().toLowerCase()).find() || drinkPattern.matcher(event.getMenuTarget().toLowerCase()).find()) && this.actionStack.stream().noneMatch(a -> {
            if (a instanceof MenuAction.ItemAction) {
                MenuAction.ItemAction i = (MenuAction.ItemAction)a;
                return i.getItemID() == event.getId();
            }
            return false;
        })) {
            this.old = this.client.getItemContainer(InventoryID.INVENTORY);
            int slot = event.getActionParam();
            if (this.old.getItems() != null) {
                int pushItem = this.old.getItems()[event.getActionParam()].getId();
                MenuAction.ItemAction newAction2 = new MenuAction.ItemAction(ActionType.CONSUMABLE, this.old.getItems(), pushItem, slot);
                this.actionStack.push(newAction2);
            }
        }
        Pattern teleportPattern = Pattern.compile(TELEPORT_PATTERN);
        Pattern teletabPattern = Pattern.compile(TELETAB_PATTERN);
        if (teleportPattern.matcher(event.getMenuTarget().toLowerCase()).find() || teletabPattern.matcher(event.getMenuTarget().toLowerCase()).find()) {
            this.old = this.client.getItemContainer(InventoryID.INVENTORY);
            if (this.old != null && this.old.getItems() != null && this.actionStack.stream().noneMatch(a -> a.getType() == ActionType.TELEPORT)) {
                int teleid = event.getId();
                newAction = new MenuAction.ItemAction(ActionType.TELEPORT, this.old.getItems(), teleid, event.getActionParam());
                this.actionStack.push(newAction);
            }
        }
        if ((spellPattern = Pattern.compile(SPELL_PATTERN)).matcher(event.getMenuOption().toLowerCase()).find()) {
            this.old = this.client.getItemContainer(InventoryID.INVENTORY);
            if (this.old != null && this.old.getItems() != null && this.actionStack.stream().noneMatch(a -> a.getType() == ActionType.CAST)) {
                newAction = new MenuAction(ActionType.CAST, this.old.getItems());
                this.actionStack.push(newAction);
            }
        }
    }

    static boolean isPotion(String name) {
        return name.contains("(4)") || name.contains("(3)") || name.contains("(2)") || name.contains("(1)");
    }

    static boolean isPizzaPie(String name) {
        return name.toLowerCase().contains("pizza") || name.toLowerCase().contains(" pie");
    }

    static boolean isCake(String name, int itemId) {
        return name.toLowerCase().contains("cake") || itemId == 1901;
    }

    private long scalePriceByDoses(String name, int itemId, long price) {
        if (SuppliesTrackerPlugin.isPotion(name)) {
            return price / 4L;
        }
        if (SuppliesTrackerPlugin.isPizzaPie(name)) {
            return price / 2L;
        }
        if (SuppliesTrackerPlugin.isCake(name, itemId)) {
            return price / 3L;
        }
        return price;
    }

    private void buildEntries(int itemId) {
        this.buildEntries(itemId, 1);
    }

    private void buildEntries(int itemId, int count) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        String name = itemComposition.getName();
        for (String raidsConsumables : this.RAIDS_CONSUMABLES) {
            if (!name.toLowerCase().contains(raidsConsumables)) continue;
            return;
        }
        if (SuppliesTrackerPlugin.isPotion(name)) {
            name = name.replaceAll(POTION_PATTERN, "(4)");
            itemId = this.getPotionID(name);
        }
        if (SuppliesTrackerPlugin.isPizzaPie(name)) {
            itemId = this.getFullVersionItemID(itemId);
            name = this.itemManager.getItemComposition(itemId).getName();
        }
        if (SuppliesTrackerPlugin.isCake(name, itemId)) {
            itemId = this.getFullVersionItemID(itemId);
            name = this.itemManager.getItemComposition(itemId).getName();
        }
        int newQuantity = suppliesEntry.containsKey(itemId) ? suppliesEntry.get(itemId).getQuantity() + count : count;
        long calculatedPrice = (long)this.itemManager.getItemPrice(itemId) * (long)newQuantity;
        calculatedPrice = this.scalePriceByDoses(name, itemId, calculatedPrice);
        SuppliesTrackerItem newEntry = new SuppliesTrackerItem(itemId, name, newQuantity, calculatedPrice);
        suppliesEntry.put(itemId, newEntry);
        SwingUtilities.invokeLater(() -> this.panel.addItem(newEntry));
    }

    void clearSupplies() {
        suppliesEntry.clear();
    }

    void clearItem(int itemId) {
        suppliesEntry.remove(itemId);
    }

    private int getPotionID(String name) {
        int itemId = 0;
        List<ItemPrice> items = this.itemManager.search(name);
        for (ItemPrice item : items) {
            if (!item.getName().contains(name)) continue;
            itemId = item.getId();
        }
        return itemId;
    }

    private int getFullVersionItemID(int itemId) {
        switch (itemId) {
            case 2299: {
                itemId = 2297;
                break;
            }
            case 2295: {
                itemId = 2293;
                break;
            }
            case 2303: {
                itemId = 2301;
                break;
            }
            case 2291: {
                itemId = 2289;
                break;
            }
            case 2333: {
                itemId = 2325;
                break;
            }
            case 7180: {
                itemId = 7178;
                break;
            }
            case 7220: {
                itemId = 7218;
                break;
            }
            case 7190: {
                itemId = 7188;
                break;
            }
            case 19659: {
                itemId = 19662;
                break;
            }
            case 21687: {
                itemId = 21690;
                break;
            }
            case 7200: {
                itemId = 7198;
                break;
            }
            case 7210: {
                itemId = 7208;
                break;
            }
            case 2335: {
                itemId = 2323;
                break;
            }
            case 2331: {
                itemId = 2327;
                break;
            }
            case 1893: 
            case 1895: {
                itemId = 1891;
                break;
            }
            case 1899: 
            case 1901: {
                itemId = 1897;
            }
        }
        return itemId;
    }
}

