/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.suppliestracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.AsyncBufferedImage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.suppliestracker.ItemType;
import net.runelite.client.plugins.suppliestracker.SuppliesTrackerItem;
import net.runelite.client.plugins.suppliestracker.SuppliesTrackerPanel;
import net.runelite.client.plugins.suppliestracker.SuppliesTrackerPlugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.StackFormatter;
import net.runelite.client.util.Text;
import net.runelite.http.api.item.ItemPrice;

class SuppliesBox
extends JPanel {
    private static final int ITEMS_PER_ROW = 5;
    private final JPanel itemContainer = new JPanel();
    private final JLabel priceLabel = new JLabel();
    private final JLabel subTitleLabel = new JLabel();
    private final ItemManager itemManager;
    private final String id;
    private final SuppliesTrackerPlugin plugin;
    private final SuppliesTrackerPanel panel;
    private final List<SuppliesTrackerItem> trackedItems = new ArrayList<SuppliesTrackerItem>();
    private long totalPrice;
    private final ItemType type;

    SuppliesBox(ItemManager itemManager, String id, SuppliesTrackerPlugin plugin, SuppliesTrackerPanel panel, ItemType type) {
        this.id = id;
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.panel = panel;
        this.type = type;
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel logTitle = new JPanel(new BorderLayout(5, 0));
        logTitle.setBorder(new EmptyBorder(7, 7, 7, 7));
        logTitle.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel titleLabel = new JLabel(Text.removeTags(id));
        titleLabel.setFont(FontManager.getRunescapeSmallFont());
        titleLabel.setForeground(Color.WHITE);
        logTitle.add((Component)titleLabel, "West");
        this.subTitleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.subTitleLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        logTitle.add((Component)this.subTitleLabel, "Center");
        this.priceLabel.setFont(FontManager.getRunescapeSmallFont());
        this.priceLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        logTitle.add((Component)this.priceLabel, "East");
        this.add((Component)logTitle, "North");
        this.add((Component)this.itemContainer, "Center");
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setComponentPopupMenu(popupMenu);
        JMenuItem reset = new JMenuItem("Reset Category");
        reset.addActionListener(e -> {
            for (SuppliesTrackerItem item : this.trackedItems) {
                plugin.clearItem(item.getId());
            }
            this.clearAll();
            this.rebuild();
            panel.updateOverall();
        });
        popupMenu.add(reset);
        this.setVisible(false);
    }

    void update(SuppliesTrackerItem item) {
        this.trackedItems.removeIf(r -> r.getId() == item.getId());
        this.trackedItems.add(item);
        this.setVisible(this.trackedItems.size() > 0);
    }

    private void remove(SuppliesTrackerItem item) {
        this.trackedItems.removeIf(r -> r.getId() == item.getId());
        this.plugin.clearItem(item.getId());
        this.setVisible(this.trackedItems.size() > 0);
    }

    void clearAll() {
        this.trackedItems.clear();
        this.setVisible(false);
    }

    long getTotalSupplies() {
        long totalSupplies = 0L;
        for (SuppliesTrackerItem item : this.trackedItems) {
            totalSupplies += (long)item.getQuantity();
        }
        return totalSupplies;
    }

    long getTotalPrice() {
        return this.totalPrice;
    }

    void rebuild() {
        this.buildItems();
        this.priceLabel.setText(StackFormatter.quantityToStackSize(this.totalPrice) + " gp");
        this.priceLabel.setToolTipText(StackFormatter.formatNumber(this.totalPrice) + " gp");
        long supplies = this.getTotalSupplies();
        if (supplies > 0L) {
            this.subTitleLabel.setText("x " + supplies);
        } else {
            this.subTitleLabel.setText("");
        }
        this.validate();
        this.repaint();
    }

    private void buildItems() {
        ArrayList<SuppliesTrackerItem> items = new ArrayList<SuppliesTrackerItem>(this.trackedItems);
        this.totalPrice = 0L;
        for (SuppliesTrackerItem item : items) {
            this.totalPrice += item.getPrice();
        }
        items.sort((i1, i2) -> Long.compare(i2.getPrice(), i1.getPrice()));
        int rowSize = (items.size() % 5 == 0 ? 0 : 1) + items.size() / 5;
        this.itemContainer.removeAll();
        this.itemContainer.setLayout(new GridLayout(rowSize, 5, 1, 1));
        for (int i = 0; i < rowSize * 5; ++i) {
            JPanel slotContainer = new JPanel();
            slotContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            if (i < items.size()) {
                SuppliesTrackerItem item = (SuppliesTrackerItem)items.get(i);
                JLabel imageLabel = new JLabel();
                imageLabel.setToolTipText(SuppliesBox.buildToolTip(item));
                imageLabel.setVerticalAlignment(0);
                imageLabel.setHorizontalAlignment(0);
                AsyncBufferedImage itemImage = this.itemManager.getImage(this.getModifiedItemId(item.getName(), item.getId()), item.getQuantity(), item.getQuantity() > 1);
                itemImage.addTo(imageLabel);
                slotContainer.add(imageLabel);
                JPopupMenu popupMenu = new JPopupMenu();
                popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
                slotContainer.setComponentPopupMenu(popupMenu);
                JMenuItem reset = new JMenuItem("Reset");
                reset.addActionListener(e -> {
                    this.remove(item);
                    this.rebuild();
                    this.panel.updateOverall();
                });
                popupMenu.add(reset);
            }
            this.itemContainer.add(slotContainer);
        }
        this.itemContainer.repaint();
    }

    private int getModifiedItemId(String name, int itemId) {
        if (SuppliesTrackerPlugin.isPotion(name)) {
            return this.getSingleDose(name);
        }
        if (SuppliesTrackerPlugin.isCake(name, itemId)) {
            return this.getSlice(itemId);
        }
        if (SuppliesTrackerPlugin.isPizzaPie(name)) {
            return this.getHalf(itemId);
        }
        return itemId;
    }

    private int getSlice(int itemId) {
        switch (itemId) {
            case 1891: {
                itemId = 1895;
                break;
            }
            case 1897: {
                itemId = 1901;
            }
        }
        return itemId;
    }

    private int getHalf(int itemId) {
        switch (itemId) {
            case 2297: {
                itemId = 2299;
                break;
            }
            case 2293: {
                itemId = 2295;
                break;
            }
            case 2301: {
                itemId = 2303;
                break;
            }
            case 2289: {
                itemId = 2291;
                break;
            }
            case 2325: {
                itemId = 2333;
                break;
            }
            case 7178: {
                itemId = 7180;
                break;
            }
            case 7218: {
                itemId = 7220;
                break;
            }
            case 7188: {
                itemId = 7190;
                break;
            }
            case 19662: {
                itemId = 19659;
                break;
            }
            case 21690: {
                itemId = 21687;
                break;
            }
            case 7198: {
                itemId = 7200;
                break;
            }
            case 7208: {
                itemId = 7210;
                break;
            }
            case 2323: {
                itemId = 2335;
                break;
            }
            case 2327: {
                itemId = 2331;
            }
        }
        return itemId;
    }

    private int getSingleDose(String name) {
        String nameModified = name.replace("(4)", "(1)");
        int itemId = 0;
        List<ItemPrice> itemList = this.itemManager.search(nameModified);
        for (ItemPrice item : itemList) {
            itemId = item.getId();
        }
        return itemId;
    }

    private static String buildToolTip(SuppliesTrackerItem item) {
        String name = item.getName();
        int quantity = item.getQuantity();
        long price = item.getPrice();
        return name + " x " + quantity + " (" + StackFormatter.quantityToStackSize(price) + ") ";
    }

    String getId() {
        return this.id;
    }

    public List<SuppliesTrackerItem> getTrackedItems() {
        return this.trackedItems;
    }

    public ItemType getType() {
        return this.type;
    }
}

