/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.statusbars;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.VarPlayer;
import net.runelite.api.Varbits;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.itemstats.Effect;
import net.runelite.client.plugins.itemstats.ItemStatChangesService;
import net.runelite.client.plugins.itemstats.StatChange;
import net.runelite.client.plugins.itemstats.StatsChanges;
import net.runelite.client.plugins.statusbars.StatusBarsConfig;
import net.runelite.client.plugins.statusbars.Viewport;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.ImageUtil;

class StatusBarsOverlay
extends Overlay {
    private static final Color PRAYER_COLOR = new Color(50, 200, 200, 175);
    private static final Color QUICK_PRAYER_COLOR = new Color(57, 255, 186, 225);
    private static final Color BACKGROUND = new Color(0, 0, 0, 150);
    private static final Color HEALTH_COLOR = new Color(225, 35, 0, 125);
    private static final Color POISONED_COLOR = new Color(0, 145, 0, 150);
    private static final Color VENOMED_COLOR = new Color(0, 65, 0, 150);
    private static final Color HEAL_COLOR = new Color(255, 112, 6, 150);
    private static final Color PRAYER_HEAL_COLOR = new Color(57, 255, 186, 75);
    private static final Color OVERHEAL_COLOR = new Color(216, 255, 139, 150);
    private static final int HEIGHT = 252;
    private static final int RESIZED_BOTTOM_HEIGHT = 272;
    private static final int WIDTH = 20;
    private static final int PADDING = 1;
    private static final int IMAGE_SIZE = 17;
    private static final int HEALTH_LOCATION_X = 0;
    private static final int PRAYER_LOCATION_X = 1;
    private static final int RESIZED_BOTTOM_OFFSET_Y = 12;
    private static final int RESIZED_BOTTOM_OFFSET_X = 10;
    private static final int OVERHEAL_OFFSET = 2;
    private static final int HEAL_OFFSET = 3;
    private static final int ICON_AND_COUNTER_OFFSET_X = 1;
    private static final int ICON_AND_COUNTER_OFFSET_Y = 21;
    private static final int SKILL_ICON_HEIGHT = 35;
    private static final int COUNTER_ICON_HEIGHT = 18;
    private static final int OFFSET = 2;
    private final Client client;
    private final StatusBarsConfig config;
    private final SkillIconManager skillIconManager;
    private final TextComponent textComponent = new TextComponent();
    private final ItemStatChangesService itemStatService;
    private final Image prayerImage;

    @Inject
    private StatusBarsOverlay(Client client2, StatusBarsConfig config, SkillIconManager skillIconManager, ItemStatChangesService itemstatservice) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client2;
        this.config = config;
        this.skillIconManager = skillIconManager;
        this.itemStatService = itemstatservice;
        this.prayerImage = ImageUtil.resizeImage(skillIconManager.getSkillImage(Skill.PRAYER, true), 17, 17);
    }

    @Override
    public Dimension render(Graphics2D g) {
        int offsetPrayerY;
        int offsetPrayerX;
        int offsetHealthY;
        int offsetHealthX;
        int height;
        Widget widgetBankTitleBar = this.client.getWidget(WidgetInfo.BANK_TITLE_BAR);
        if (widgetBankTitleBar != null && !widgetBankTitleBar.isHidden()) {
            return null;
        }
        Viewport curViewport = null;
        Widget curWidget = null;
        for (Viewport viewport : Viewport.values()) {
            Widget viewportWidget = this.client.getWidget(viewport.getViewport());
            if (viewportWidget == null || viewportWidget.isHidden()) continue;
            curViewport = viewport;
            curWidget = viewportWidget;
            break;
        }
        if (curViewport == null || curWidget.isHidden()) {
            return null;
        }
        Point offsetLeft = curViewport.getOffsetLeft();
        Point offsetRight = curViewport.getOffsetRight();
        Point location = curWidget.getCanvasLocation();
        if (curViewport == Viewport.RESIZED_BOTTOM) {
            height = 272;
            offsetHealthX = location.getX() + 10 - offsetLeft.getX();
            offsetHealthY = location.getY() - 12 - offsetRight.getY();
            offsetPrayerX = location.getX() + 10 - offsetRight.getX();
            offsetPrayerY = location.getY() - 12 - offsetRight.getY();
        } else {
            height = 252;
            offsetHealthX = location.getX() - offsetLeft.getX();
            offsetHealthY = location.getY() - offsetLeft.getY();
            offsetPrayerX = location.getX() - offsetRight.getX() + curWidget.getWidth();
            offsetPrayerY = location.getY() - offsetRight.getY();
        }
        int poisonState = this.client.getVar(VarPlayer.IS_POISONED);
        Color healthBar = poisonState >= 1000000 ? VENOMED_COLOR : (poisonState > 0 ? POISONED_COLOR : HEALTH_COLOR);
        int maxHealth = this.client.getRealSkillLevel(Skill.HITPOINTS);
        int maxPrayer = this.client.getRealSkillLevel(Skill.PRAYER);
        int currentHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        int currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        int quickPrayerState = this.client.getVar(Varbits.QUICK_PRAYER);
        Color prayerBar = quickPrayerState == 1 ? QUICK_PRAYER_COLOR : PRAYER_COLOR;
        StatusBarsOverlay.renderBar(g, offsetHealthX, offsetHealthY, maxHealth, currentHealth, height, healthBar);
        StatusBarsOverlay.renderBar(g, offsetPrayerX, offsetPrayerY, maxPrayer, currentPrayer, height, prayerBar);
        if (this.config.enableRestorationBars()) {
            Effect change;
            MenuEntry[] menu = this.client.getMenuEntries();
            int menuSize = menu.length;
            MenuEntry entry = menuSize > 0 ? menu[menuSize - 1] : null;
            int prayerHealValue = 0;
            int foodHealValue = 0;
            if (entry != null && entry.getParam1() == WidgetInfo.INVENTORY.getId() && (change = this.itemStatService.getItemStatChanges(entry.getIdentifier())) != null) {
                StatsChanges statsChanges = change.calculate(this.client);
                for (StatChange c : statsChanges.getStatChanges()) {
                    int theoreticalBoost = c.getTheoretical();
                    if (c.getStat().getName().equals(Skill.HITPOINTS.getName())) {
                        foodHealValue = theoreticalBoost;
                    }
                    if (c.getStat().getName().equals(Skill.PRAYER.getName())) {
                        prayerHealValue = theoreticalBoost;
                    }
                    if (foodHealValue != 0 && prayerHealValue != 0) break;
                }
            }
            StatusBarsOverlay.renderHealingBar(g, offsetHealthX, offsetHealthY, maxHealth, currentHealth, height, foodHealValue, HEAL_COLOR);
            StatusBarsOverlay.renderHealingBar(g, offsetPrayerX, offsetPrayerY, maxPrayer, currentPrayer, height, prayerHealValue, PRAYER_HEAL_COLOR);
        }
        if (this.config.enableSkillIcon() || this.config.enableCounter()) {
            BufferedImage healthImage = this.skillIconManager.getSkillImage(Skill.HITPOINTS, true);
            int counterHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
            int counterPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
            String counterHealthText = Integer.toString(counterHealth);
            String counterPrayerText = Integer.toString(counterPrayer);
            this.renderIconsAndCounters(g, offsetPrayerX, offsetPrayerY, this.prayerImage, counterPrayerText, 1);
            this.renderIconsAndCounters(g, offsetHealthX, offsetHealthY, healthImage, counterHealthText, 0);
        }
        return null;
    }

    private static void renderBar(Graphics2D graphics, int x, int y, int max, int current, int height, Color filled) {
        graphics.setColor(BACKGROUND);
        graphics.drawRect(x, y, 19, height - 1);
        graphics.fillRect(x, y, 20, height);
        int filledHeight = StatusBarsOverlay.getBarHeight(max, current, height);
        graphics.setColor(filled);
        graphics.fillRect(x + 1, y + 1 + (height - filledHeight), 18, filledHeight - 2);
    }

    private static void renderHealingBar(Graphics2D graphics, int x, int y, int max, int current, int height, int heal, Color color) {
        if (heal <= 0) {
            return;
        }
        int filledCurrentHeight = StatusBarsOverlay.getBarHeight(max, current, height);
        int filledHeight = StatusBarsOverlay.getBarHeight(max, heal, height);
        graphics.setColor(color);
        if (filledHeight + filledCurrentHeight > height) {
            int overHeal = filledHeight + filledCurrentHeight - height;
            filledHeight = filledHeight - overHeal + 2;
            graphics.setColor(OVERHEAL_COLOR);
            graphics.fillRect(x + 1, y - filledCurrentHeight + (height - filledHeight) + 3, 18, filledHeight - 2);
        } else {
            graphics.fillRect(x + 1, y - 2 - filledCurrentHeight + (height - filledHeight) + 3, 18, filledHeight + 2 - 2);
        }
    }

    private static int getBarHeight(int base, int current, int size) {
        double ratio = (double)current / (double)base;
        if (ratio >= 1.0) {
            return size;
        }
        return (int)Math.round(ratio * (double)size);
    }

    private void renderIconsAndCounters(Graphics2D graphics, int x, int y, Image image, String counterText, int counterPadding) {
        int widthOfCounter = graphics.getFontMetrics().stringWidth(counterText);
        int centerText = 9 - widthOfCounter / 2;
        if (this.config.enableCounter()) {
            graphics.setFont(FontManager.getRunescapeSmallFont());
            this.textComponent.setColor(Color.WHITE);
            this.textComponent.setText(counterText);
            this.textComponent.setPosition(new java.awt.Point(x + centerText + counterPadding, y + 18));
        } else {
            this.textComponent.setText("");
        }
        if (this.config.enableSkillIcon()) {
            graphics.drawImage(image, x + 1 + 1, y + 21 - image.getWidth(null), null);
            this.textComponent.setPosition(new java.awt.Point(x + centerText + counterPadding, y + 35));
        }
        this.textComponent.render(graphics);
    }
}

