/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.specialcounter;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.VarPlayer;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.specialcounter.Boss;
import net.runelite.client.plugins.specialcounter.SpecialCounter;
import net.runelite.client.plugins.specialcounter.SpecialCounterUpdate;
import net.runelite.client.plugins.specialcounter.SpecialWeapon;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ws.PartyService;
import net.runelite.client.ws.WSClient;

@PluginDescriptor(name="Special Attack Counter", description="Track DWH, Arclight, Darklight, and BGS special attacks used on NPCs", tags={"combat", "npcs", "overlay"}, enabledByDefault=false)
public class SpecialCounterPlugin
extends Plugin {
    private int currentWorld = -1;
    private int specialPercentage = -1;
    private int specialHitpointsExperience = -1;
    private boolean specialUsed;
    private double modifier = 1.0;
    private SpecialWeapon specialWeapon;
    private final Set<Integer> interactedNpcIds = new HashSet<Integer>();
    private final SpecialCounter[] specialCounter = new SpecialCounter[SpecialWeapon.values().length];
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private WSClient wsClient;
    @Inject
    private PartyService party;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;

    @Override
    protected void startUp() {
        this.wsClient.registerMessage(SpecialCounterUpdate.class);
    }

    @Override
    protected void shutDown() {
        this.removeCounters();
        this.wsClient.unregisterMessage(SpecialCounterUpdate.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            if (this.currentWorld == -1) {
                this.currentWorld = this.client.getWorld();
            } else if (this.currentWorld != this.client.getWorld()) {
                this.currentWorld = this.client.getWorld();
                this.removeCounters();
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int specialPercentage = this.client.getVar(VarPlayer.SPECIAL_ATTACK_PERCENT);
        if (this.specialPercentage == -1 || specialPercentage >= this.specialPercentage) {
            this.specialPercentage = specialPercentage;
            return;
        }
        this.specialPercentage = specialPercentage;
        this.specialWeapon = this.usedSpecialWeapon();
        this.checkInteracting();
        this.specialUsed = true;
        this.specialHitpointsExperience = this.client.getSkillExperience(Skill.HITPOINTS);
    }

    @Subscribe
    private void onGameTick(GameTick tick) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        int interactingId = this.checkInteracting();
        if (interactingId > -1 && this.specialHitpointsExperience != -1 && this.specialUsed) {
            this.specialUsed = false;
            int hpXp = this.client.getSkillExperience(Skill.HITPOINTS);
            int deltaExperience = hpXp - this.specialHitpointsExperience;
            this.specialHitpointsExperience = -1;
            if (deltaExperience > 0 && this.specialWeapon != null) {
                int hit = this.getHit(this.specialWeapon, deltaExperience);
                this.updateCounter(this.specialWeapon, null, hit);
                if (!this.party.getMembers().isEmpty()) {
                    SpecialCounterUpdate specialCounterUpdate = new SpecialCounterUpdate(interactingId, this.specialWeapon, hit);
                    specialCounterUpdate.setMemberId(this.party.getLocalMember().getMemberId());
                    this.wsClient.send(specialCounterUpdate);
                }
            }
        }
    }

    private int checkInteracting() {
        Player localPlayer = this.client.getLocalPlayer();
        Actor interacting = localPlayer.getInteracting();
        if (interacting instanceof NPC) {
            int interactingId = ((NPC)interacting).getId();
            if (!this.interactedNpcIds.contains(interactingId)) {
                this.removeCounters();
                this.addInteracting(interactingId);
            }
            return interactingId;
        }
        return -1;
    }

    private void addInteracting(int npcId) {
        this.modifier = 1.0;
        this.interactedNpcIds.add(npcId);
        Boss boss = Boss.getBoss(npcId);
        if (boss != null) {
            this.modifier = boss.getModifier();
            this.interactedNpcIds.addAll(boss.getIds());
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC actor = npcDespawned.getNpc();
        if (actor.isDead() && this.interactedNpcIds.contains(actor.getId())) {
            this.removeCounters();
        }
    }

    @Subscribe
    public void onSpecialCounterUpdate(SpecialCounterUpdate event) {
        if (this.party.getLocalMember().getMemberId().equals(event.getMemberId())) {
            return;
        }
        String name = this.party.getMemberById(event.getMemberId()).getName();
        if (name == null) {
            return;
        }
        this.clientThread.invoke(() -> {
            if (this.interactedNpcIds.isEmpty()) {
                this.addInteracting(event.getNpcId());
            }
            if (this.interactedNpcIds.contains(event.getNpcId())) {
                this.updateCounter(event.getWeapon(), name, event.getHit());
            }
        });
    }

    private SpecialWeapon usedSpecialWeapon() {
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment == null) {
            return null;
        }
        Item[] items = equipment.getItems();
        int weaponIdx = EquipmentInventorySlot.WEAPON.getSlotIdx();
        if (items == null || weaponIdx >= items.length) {
            return null;
        }
        Item weapon = items[weaponIdx];
        for (SpecialWeapon specialWeapon : SpecialWeapon.values()) {
            if (specialWeapon.getItemID() != weapon.getId()) continue;
            return specialWeapon;
        }
        return null;
    }

    private void updateCounter(SpecialWeapon specialWeapon, String name, int hit) {
        SpecialCounter counter = this.specialCounter[specialWeapon.ordinal()];
        if (counter == null) {
            counter = new SpecialCounter(this.itemManager.getImage(specialWeapon.getItemID()), this, hit, specialWeapon);
            this.infoBoxManager.addInfoBox(counter);
            this.specialCounter[specialWeapon.ordinal()] = counter;
        } else {
            counter.addHits(hit);
        }
        Map<String, Integer> partySpecs = counter.getPartySpecs();
        if (!this.party.getMembers().isEmpty()) {
            if (partySpecs.containsKey(name)) {
                partySpecs.put(name, hit + partySpecs.get(name));
            } else {
                partySpecs.put(name, hit);
            }
        }
    }

    private void removeCounters() {
        this.interactedNpcIds.clear();
        for (int i = 0; i < this.specialCounter.length; ++i) {
            SpecialCounter counter = this.specialCounter[i];
            if (counter == null) continue;
            this.infoBoxManager.removeInfoBox(counter);
            this.specialCounter[i] = null;
        }
    }

    private int getHit(SpecialWeapon specialWeapon, int deltaExperience) {
        double modifierBase = 1.0 / this.modifier;
        double damageOutput = (double)deltaExperience * modifierBase / 1.3333;
        if (!specialWeapon.isDamage()) {
            return 1;
        }
        return (int)Math.round(damageOutput);
    }
}

