/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.specialcounter;

import com.google.common.collect.Sets;
import java.util.Set;

enum Boss {
    ABYSSAL_SIRE(1.25, 5886, 5887, 5888, 5889, 5890, 5891, 5908),
    CALLISTO(1.225, 6503, 6609),
    CERBERUS(1.15, 5862, 5863, 5866),
    CHAOS_ELEMENTAL(1.075, 2054, 6505),
    CORPOREAL_BEAST(1.55, 319),
    GENERAL_GRAARDOR(1.325, 2215, 6494),
    GIANT_MOLE(1.075, 5779, 6499),
    KALPHITE_QUEEN(1.05, 128, 963, 965, 4303, 4304, 6500, 6501),
    KING_BLACK_DRAGON(1.075, 239, 2642, 6502),
    KRIL_TSUROTH(1.375, 3129, 6495),
    VENETENATIS(1.4, 6504, 6610),
    VETION(1.225, 6611, 6612);

    private final Set<Integer> ids;
    private final double modifier;

    private Boss(double modifier, Integer ... ids) {
        this.modifier = modifier;
        this.ids = Sets.newHashSet(ids);
    }

    static Boss getBoss(int id) {
        for (Boss boss : Boss.values()) {
            if (!boss.ids.contains(id)) continue;
            return boss;
        }
        return null;
    }

    public Set<Integer> getIds() {
        return this.ids;
    }

    public double getModifier() {
        return this.modifier;
    }

    public String toString() {
        return "Boss." + this.name() + "(ids=" + this.getIds() + ", modifier=" + this.getModifier() + ")";
    }
}

