/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.slayer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.plugins.slayer.SlayerConfig;
import net.runelite.client.plugins.slayer.SlayerPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class TargetMinimapOverlay
extends Overlay {
    private final SlayerConfig config;
    private final SlayerPlugin plugin;

    @Inject
    TargetMinimapOverlay(SlayerConfig config, SlayerPlugin plugin) {
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.config.highlightTargets()) {
            return null;
        }
        List<NPC> targets = this.plugin.getHighlightedTargets();
        for (NPC target : targets) {
            this.renderTargetOverlay(graphics, target, this.config.getTargetColor());
        }
        return null;
    }

    private void renderTargetOverlay(Graphics2D graphics, NPC actor, Color color) {
        Point minimapLocation = actor.getMinimapLocation();
        if (minimapLocation != null) {
            OverlayUtil.renderMinimapLocation(graphics, minimapLocation, color);
        }
    }
}

