/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.slayer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.NPC;
import net.runelite.client.plugins.slayer.SlayerConfig;
import net.runelite.client.plugins.slayer.SlayerPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class TargetClickboxOverlay
extends Overlay {
    private final SlayerConfig config;
    private final SlayerPlugin plugin;

    @Inject
    TargetClickboxOverlay(SlayerConfig config, SlayerPlugin plugin) {
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.config.highlightTargets()) {
            return null;
        }
        List<NPC> targets = this.plugin.getHighlightedTargets();
        for (NPC target : targets) {
            this.renderTargetOverlay(graphics, target, this.config.getTargetColor());
        }
        return null;
    }

    private void renderTargetOverlay(Graphics2D graphics, NPC actor, Color color) {
        Polygon objectClickbox = actor.getConvexHull();
        if (objectClickbox != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.draw(objectClickbox);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(objectClickbox);
        }
    }
}

