/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.slayer;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import java.awt.Color;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import joptsimple.internal.Strings;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MessageNode;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.ExperienceChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.vars.SlayerUnlock;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ChatInput;
import net.runelite.client.game.AsyncBufferedImage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.slayer.SlayerConfig;
import net.runelite.client.plugins.slayer.SlayerOverlay;
import net.runelite.client.plugins.slayer.TargetClickboxOverlay;
import net.runelite.client.plugins.slayer.TargetMinimapOverlay;
import net.runelite.client.plugins.slayer.TargetWeaknessOverlay;
import net.runelite.client.plugins.slayer.Task;
import net.runelite.client.plugins.slayer.TaskCounter;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.chat.ChatClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Slayer", description="Show additional slayer task related information", tags={"combat", "notifications", "overlay", "tasks"})
public class SlayerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SlayerPlugin.class);
    private static final Pattern CHAT_GEM_PROGRESS_MESSAGE = Pattern.compile("^(?:You're assigned to kill|You have received a new Slayer assignment from .*:) (?:[Tt]he )?(?<name>.+?)(?: (?:in|on|south of) (?:the )?(?<location>[^;]+))?(?:; only | \\()(?<amount>\\d+)(?: more to go\\.|\\))$");
    private static final String CHAT_GEM_COMPLETE_MESSAGE = "You need something new to hunt.";
    private static final Pattern CHAT_COMPLETE_MESSAGE = Pattern.compile("(?:\\d+,)*\\d+");
    private static final String CHAT_CANCEL_MESSAGE = "Your task has been cancelled.";
    private static final String CHAT_CANCEL_MESSAGE_JAD = "You no longer have a slayer task as you left the fight cave.";
    private static final String CHAT_SUPERIOR_MESSAGE = "A superior foe has appeared...";
    private static final String CHAT_BRACELET_SLAUGHTER = "Your bracelet of slaughter prevents your slayer";
    private static final Pattern CHAT_BRACELET_SLAUGHTER_REGEX = Pattern.compile("Your bracelet of slaughter prevents your slayer count decreasing. It has (\\d{1,2}) charge[s]? left.");
    private static final String CHAT_BRACELET_EXPEDITIOUS = "Your expeditious bracelet helps you progress your";
    private static final Pattern CHAT_BRACELET_EXPEDITIOUS_REGEX = Pattern.compile("Your expeditious bracelet helps you progress your slayer (?:task )?faster. It has (\\d{1,2}) charge[s]? left.");
    private static final String CHAT_BRACELET_SLAUGHTER_CHARGE = "Your bracelet of slaughter has ";
    private static final Pattern CHAT_BRACELET_SLAUGHTER_CHARGE_REGEX = Pattern.compile("Your bracelet of slaughter has (\\d{1,2}) charge[s]? left.");
    private static final String CHAT_BRACELET_EXPEDITIOUS_CHARGE = "Your expeditious bracelet has ";
    private static final Pattern CHAT_BRACELET_EXPEDITIOUS_CHARGE_REGEX = Pattern.compile("Your expeditious bracelet has (\\d{1,2}) charge[s]? left.");
    private static final Pattern COMBAT_BRACELET_TASK_UPDATE_MESSAGE = Pattern.compile("^You still need to kill (\\d+) monsters to complete your current Slayer assignment");
    private static final Pattern NPC_ASSIGN_MESSAGE = Pattern.compile(".*(?:Your new task is to kill|You are to bring balance to)\\s*(?<amount>\\d+) (?<name>.+?)(?: (?:in|on|south of) (?:the )?(?<location>.+))?\\.");
    private static final Pattern NPC_ASSIGN_BOSS_MESSAGE = Pattern.compile("^Excellent. You're now assigned to kill (?:the )?(.*) (\\d+) times.*Your reward point tally is (.*)\\.$");
    private static final Pattern NPC_ASSIGN_FIRST_MESSAGE = Pattern.compile("^We'll start you off hunting (.*), you'll need to kill (\\d*) of them.");
    private static final Pattern NPC_CURRENT_MESSAGE = Pattern.compile("^You're still (?:hunting|bringing balance to) (?<name>.+)(?: (?:in|on|south of) (?:the )?(?<location>.+), with|; you have) (?<amount>\\d+) to go\\..*");
    private static final Pattern REWARD_POINTS = Pattern.compile("Reward points: ((?:\\d+,)*\\d+)");
    private static final int GROTESQUE_GUARDIANS_REGION = 6727;
    private static final int EXPEDITIOUS_CHARGE = 30;
    private static final int SLAUGHTER_CHARGE = 30;
    private static final String TASK_COMMAND_STRING = "!task";
    private static final Pattern TASK_STRING_VALIDATION = Pattern.compile("[^a-zA-Z0-9' -]");
    private static final int TASK_STRING_MAX_LENGTH = 50;
    @Inject
    private Client client;
    @Inject
    private SlayerConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SlayerOverlay overlay;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TargetClickboxOverlay targetClickboxOverlay;
    @Inject
    private TargetWeaknessOverlay targetWeaknessOverlay;
    @Inject
    private TargetMinimapOverlay targetMinimapOverlay;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ChatClient chatClient;
    private List<NPC> highlightedTargets = new ArrayList<NPC>();
    private int amount;
    private int initialAmount;
    private String taskLocation;
    private int expeditiousChargeCount;
    private int slaughterChargeCount;
    private String taskName;
    private int streak;
    private int points;
    private TaskCounter counter;
    private int cachedXp;
    private Instant infoTimer;
    private boolean loginFlag;
    private List<String> targetNames = new ArrayList<String>();

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.overlayManager.add(this.targetClickboxOverlay);
        this.overlayManager.add(this.targetWeaknessOverlay);
        this.overlayManager.add(this.targetMinimapOverlay);
        if (this.client.getGameState() == GameState.LOGGED_IN && this.config.amount() != -1 && !this.config.taskName().isEmpty()) {
            this.points = this.config.points();
            this.streak = this.config.streak();
            this.setExpeditiousChargeCount(this.config.expeditious());
            this.setSlaughterChargeCount(this.config.slaughter());
            this.clientThread.invoke(() -> this.setTask(this.config.taskName(), this.config.amount(), this.config.initialAmount(), this.config.taskLocation()));
        }
        this.chatCommandManager.registerCommandAsync(TASK_COMMAND_STRING, this::taskLookup, this::taskSubmit);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.overlayManager.remove(this.targetClickboxOverlay);
        this.overlayManager.remove(this.targetWeaknessOverlay);
        this.overlayManager.remove(this.targetMinimapOverlay);
        this.removeCounter();
        this.highlightedTargets.clear();
        this.chatCommandManager.unregisterCommand(TASK_COMMAND_STRING);
    }

    @Provides
    SlayerConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(SlayerConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGGING_IN: {
                this.cachedXp = 0;
                this.taskName = "";
                this.amount = 0;
                this.loginFlag = true;
                this.highlightedTargets.clear();
                break;
            }
            case LOGGED_IN: {
                if (this.config.amount() == -1 || this.config.taskName().isEmpty() || !this.loginFlag) break;
                this.points = this.config.points();
                this.streak = this.config.streak();
                this.setExpeditiousChargeCount(this.config.expeditious());
                this.setSlaughterChargeCount(this.config.slaughter());
                this.setTask(this.config.taskName(), this.config.amount(), this.config.initialAmount(), this.config.taskLocation());
                this.loginFlag = false;
            }
        }
    }

    private void save() {
        this.config.amount(this.amount);
        this.config.initialAmount(this.initialAmount);
        this.config.taskName(this.taskName);
        this.config.taskLocation(this.taskLocation);
        this.config.points(this.points);
        this.config.streak(this.streak);
        this.config.expeditious(this.expeditiousChargeCount);
        this.config.slaughter(this.slaughterChargeCount);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (this.isTarget(npc)) {
            this.highlightedTargets.add(npc);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.highlightedTargets.remove(npc);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        Duration statTimeout;
        Duration timeSinceInfobox;
        Widget rewardsBarWidget;
        Widget braceletBreakWidget;
        Widget npcDialog = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
        if (npcDialog != null) {
            String location;
            int amount;
            String name;
            String npcText = Text.sanitizeMultilineText(npcDialog.getText());
            Matcher mAssign = NPC_ASSIGN_MESSAGE.matcher(npcText);
            Widget[] mAssignFirst = NPC_ASSIGN_FIRST_MESSAGE.matcher(npcText);
            Matcher mAssignBoss = NPC_ASSIGN_BOSS_MESSAGE.matcher(npcText);
            Matcher mCurrent = NPC_CURRENT_MESSAGE.matcher(npcText);
            if (mAssign.find()) {
                name = mAssign.group("name");
                amount = Integer.parseInt(mAssign.group("amount"));
                location = mAssign.group("location");
                this.setTask(name, amount, amount, location);
            } else if (mAssignFirst.find()) {
                int amount2 = Integer.parseInt(mAssignFirst.group(2));
                this.setTask(mAssignFirst.group(1), amount2, amount2);
            } else if (mAssignBoss.find()) {
                int amount3 = Integer.parseInt(mAssignBoss.group(2));
                this.setTask(mAssignBoss.group(1), amount3, amount3);
                this.points = Integer.parseInt(mAssignBoss.group(3).replaceAll(",", ""));
            } else if (mCurrent.find()) {
                name = mCurrent.group("name");
                amount = Integer.parseInt(mCurrent.group("amount"));
                location = mCurrent.group("location");
                this.setTask(name, amount, this.initialAmount, location);
            }
        }
        if ((braceletBreakWidget = this.client.getWidget(WidgetInfo.DIALOG_SPRITE_TEXT)) != null) {
            String braceletText = Text.removeTags(braceletBreakWidget.getText());
            if (braceletText.contains("bracelet of slaughter")) {
                this.slaughterChargeCount = 30;
                this.config.slaughter(this.slaughterChargeCount);
            } else if (braceletText.contains("expeditious bracelet")) {
                this.expeditiousChargeCount = 30;
                this.config.expeditious(this.expeditiousChargeCount);
            }
        }
        if ((rewardsBarWidget = this.client.getWidget(WidgetInfo.SLAYER_REWARDS_TOPBAR)) != null) {
            for (Widget w : rewardsBarWidget.getDynamicChildren()) {
                Matcher mPoints = REWARD_POINTS.matcher(w.getText());
                if (!mPoints.find()) continue;
                int prevPoints = this.points;
                this.points = Integer.parseInt(mPoints.group(1).replaceAll(",", ""));
                if (prevPoints == this.points) break;
                this.removeCounter();
                this.addCounter();
                break;
            }
        }
        if (this.infoTimer != null && (timeSinceInfobox = Duration.between(this.infoTimer, Instant.now())).compareTo(statTimeout = Duration.ofMinutes(this.config.statTimeout())) >= 0) {
            this.removeCounter();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher mExpeditious;
        Matcher mSlaughter;
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String chatMsg = Text.removeTags(event.getMessage());
        if (chatMsg.startsWith(CHAT_BRACELET_SLAUGHTER)) {
            mSlaughter = CHAT_BRACELET_SLAUGHTER_REGEX.matcher(chatMsg);
            ++this.amount;
            this.slaughterChargeCount = mSlaughter.find() ? Integer.parseInt(mSlaughter.group(1)) : 30;
            this.config.slaughter(this.slaughterChargeCount);
        }
        if (chatMsg.startsWith(CHAT_BRACELET_EXPEDITIOUS)) {
            mExpeditious = CHAT_BRACELET_EXPEDITIOUS_REGEX.matcher(chatMsg);
            --this.amount;
            this.expeditiousChargeCount = mExpeditious.find() ? Integer.parseInt(mExpeditious.group(1)) : 30;
            this.config.expeditious(this.expeditiousChargeCount);
        }
        if (chatMsg.startsWith(CHAT_BRACELET_EXPEDITIOUS_CHARGE)) {
            mExpeditious = CHAT_BRACELET_EXPEDITIOUS_CHARGE_REGEX.matcher(chatMsg);
            if (!mExpeditious.find()) {
                return;
            }
            this.expeditiousChargeCount = Integer.parseInt(mExpeditious.group(1));
            this.config.expeditious(this.expeditiousChargeCount);
        }
        if (chatMsg.startsWith(CHAT_BRACELET_SLAUGHTER_CHARGE)) {
            mSlaughter = CHAT_BRACELET_SLAUGHTER_CHARGE_REGEX.matcher(chatMsg);
            if (!mSlaughter.find()) {
                return;
            }
            this.slaughterChargeCount = Integer.parseInt(mSlaughter.group(1));
            this.config.slaughter(this.slaughterChargeCount);
        }
        if (chatMsg.endsWith("; return to a Slayer master.")) {
            Matcher mComplete = CHAT_COMPLETE_MESSAGE.matcher(chatMsg);
            ArrayList<String> matches = new ArrayList<String>();
            while (mComplete.find()) {
                matches.add(mComplete.group(0).replaceAll(",", ""));
            }
            switch (matches.size()) {
                case 0: {
                    this.streak = 1;
                    break;
                }
                case 1: {
                    this.streak = Integer.parseInt((String)matches.get(0));
                    break;
                }
                case 3: {
                    this.streak = Integer.parseInt((String)matches.get(0));
                    this.points = Integer.parseInt((String)matches.get(2));
                    break;
                }
                default: {
                    log.warn("Unreachable default case for message ending in '; return to Slayer master'");
                }
            }
            this.setTask("", 0, 0);
            return;
        }
        if (chatMsg.equals(CHAT_GEM_COMPLETE_MESSAGE) || chatMsg.equals(CHAT_CANCEL_MESSAGE) || chatMsg.equals(CHAT_CANCEL_MESSAGE_JAD)) {
            this.setTask("", 0, 0);
            return;
        }
        if (this.config.showSuperiorNotification() && chatMsg.equals(CHAT_SUPERIOR_MESSAGE)) {
            this.notifier.notify(CHAT_SUPERIOR_MESSAGE);
            return;
        }
        Matcher mProgress = CHAT_GEM_PROGRESS_MESSAGE.matcher(chatMsg);
        if (mProgress.find()) {
            String name = mProgress.group("name");
            int gemAmount = Integer.parseInt(mProgress.group("amount"));
            String location = mProgress.group("location");
            this.setTask(name, gemAmount, this.initialAmount, location);
            return;
        }
        Matcher bracerProgress = COMBAT_BRACELET_TASK_UPDATE_MESSAGE.matcher(chatMsg);
        if (bracerProgress.find()) {
            int taskAmount = Integer.parseInt(bracerProgress.group(1));
            this.setTask(this.taskName, taskAmount, this.initialAmount);
            ++this.amount;
        }
    }

    @Subscribe
    public void onExperienceChanged(ExperienceChanged event) {
        if (event.getSkill() != Skill.SLAYER) {
            return;
        }
        int slayerExp = this.client.getSkillExperience(Skill.SLAYER);
        if (slayerExp <= this.cachedXp) {
            return;
        }
        if (this.cachedXp == 0) {
            this.cachedXp = slayerExp;
            return;
        }
        this.killedOne();
        this.cachedXp = slayerExp;
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("slayer")) {
            return;
        }
        if (this.config.showInfobox()) {
            this.clientThread.invoke(this::addCounter);
        } else {
            this.removeCounter();
        }
    }

    @VisibleForTesting
    void killedOne() {
        if (this.amount == 0) {
            return;
        }
        --this.amount;
        if (this.doubleTroubleExtraKill()) {
            --this.amount;
        }
        this.config.amount(this.amount);
        if (!this.config.showInfobox()) {
            return;
        }
        this.addCounter();
        this.counter.setCount(this.amount);
        this.infoTimer = Instant.now();
    }

    private boolean doubleTroubleExtraKill() {
        return WorldPoint.fromLocalInstance(this.client, this.client.getLocalPlayer().getLocalLocation()).getRegionID() == 6727 && SlayerUnlock.GROTESQUE_GARDIAN_DOUBLE_COUNT.isEnabled(this.client);
    }

    private boolean isTarget(NPC npc) {
        if (this.targetNames.isEmpty()) {
            return false;
        }
        String name = npc.getName();
        if (name == null) {
            return false;
        }
        name = name.toLowerCase();
        for (String target : this.targetNames) {
            List<String> actions;
            NPCComposition composition;
            if (!name.contains(target) || (composition = npc.getTransformedComposition()) == null || !(actions = Arrays.asList(composition.getActions())).contains("Attack") && !actions.contains("Pick")) continue;
            return true;
        }
        return false;
    }

    private void rebuildTargetNames(Task task) {
        this.targetNames.clear();
        if (task != null) {
            Arrays.stream(task.getTargetNames()).map(String::toLowerCase).forEach(this.targetNames::add);
            this.targetNames.add(this.taskName.toLowerCase().replaceAll("s$", ""));
        }
    }

    private void rebuildTargetList() {
        this.highlightedTargets.clear();
        for (NPC npc : this.client.getNpcs()) {
            if (!this.isTarget(npc)) continue;
            this.highlightedTargets.add(npc);
        }
    }

    private void setTask(String name, int amt, int initAmt) {
        this.setTask(name, amt, initAmt, null);
    }

    private void setTask(String name, int amt, int initAmt, String location) {
        this.taskName = name;
        this.amount = amt;
        this.initialAmount = initAmt;
        this.taskLocation = location;
        this.save();
        this.removeCounter();
        this.addCounter();
        this.infoTimer = Instant.now();
        Task task = Task.getTask(name);
        this.rebuildTargetNames(task);
        this.rebuildTargetList();
    }

    private void addCounter() {
        if (!this.config.showInfobox() || this.counter != null || Strings.isNullOrEmpty(this.taskName)) {
            return;
        }
        Task task = Task.getTask(this.taskName);
        int itemSpriteId = 4155;
        if (task != null) {
            itemSpriteId = task.getItemSpriteId();
        }
        AsyncBufferedImage taskImg = this.itemManager.getImage(itemSpriteId);
        String taskTooltip = ColorUtil.wrapWithColorTag("%s", new Color(255, 119, 0)) + "</br>";
        if (this.taskLocation != null && !this.taskLocation.isEmpty()) {
            taskTooltip = taskTooltip + this.taskLocation + "</br>";
        }
        taskTooltip = taskTooltip + ColorUtil.wrapWithColorTag("Pts:", Color.YELLOW) + " %s</br>" + ColorUtil.wrapWithColorTag("Streak:", Color.YELLOW) + " %s";
        if (this.initialAmount > 0) {
            taskTooltip = taskTooltip + "</br>" + ColorUtil.wrapWithColorTag("Start:", Color.YELLOW) + " " + this.initialAmount;
        }
        this.counter = new TaskCounter(taskImg, this, this.amount);
        this.counter.setTooltip(String.format(taskTooltip, this.capsString(this.taskName), this.points, this.streak));
        this.infoBoxManager.addInfoBox(this.counter);
    }

    private void removeCounter() {
        if (this.counter == null) {
            return;
        }
        this.infoBoxManager.removeInfoBox(this.counter);
        this.counter = null;
    }

    void taskLookup(ChatMessage chatMessage, String message) {
        net.runelite.http.api.chat.Task task;
        if (!this.config.taskCommand()) {
            return;
        }
        ChatMessageType type = chatMessage.getType();
        String player = type.equals((Object)ChatMessageType.PRIVATECHATOUT) ? this.client.getLocalPlayer().getName() : Text.removeTags(chatMessage.getName()).replace('\u00a0', ' ');
        try {
            task = this.chatClient.getTask(player);
        }
        catch (IOException ex) {
            log.debug("unable to lookup slayer task", ex);
            return;
        }
        if (TASK_STRING_VALIDATION.matcher(task.getTask()).find() || task.getTask().length() > 50 || TASK_STRING_VALIDATION.matcher(task.getLocation()).find() || task.getLocation().length() > 50) {
            log.debug("Validation failed for task name or location: {}", (Object)task);
            return;
        }
        int killed = task.getInitialAmount() - task.getAmount();
        StringBuilder sb = new StringBuilder();
        sb.append(task.getTask());
        if (!Strings.isNullOrEmpty(task.getLocation())) {
            sb.append(" (").append(task.getLocation()).append(")");
        }
        sb.append(": ");
        if (killed < 0) {
            sb.append(task.getAmount()).append(" left");
        } else {
            sb.append(killed).append('/').append(task.getInitialAmount()).append(" killed");
        }
        String response = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Slayer Task: ").append(ChatColorType.HIGHLIGHT).append(sb.toString()).build();
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    private boolean taskSubmit(ChatInput chatInput, String value) {
        if (Strings.isNullOrEmpty(this.taskName)) {
            return false;
        }
        String playerName = this.client.getLocalPlayer().getName();
        this.executor.execute(() -> {
            try {
                this.chatClient.submitTask(playerName, this.capsString(this.taskName), this.amount, this.initialAmount, this.taskLocation);
            }
            catch (Exception ex) {
                log.warn("unable to submit slayer task", ex);
            }
            finally {
                chatInput.resume();
            }
        });
        return true;
    }

    private String capsString(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    List<NPC> getHighlightedTargets() {
        return this.highlightedTargets;
    }

    int getAmount() {
        return this.amount;
    }

    void setAmount(int amount) {
        this.amount = amount;
    }

    int getInitialAmount() {
        return this.initialAmount;
    }

    void setInitialAmount(int initialAmount) {
        this.initialAmount = initialAmount;
    }

    String getTaskLocation() {
        return this.taskLocation;
    }

    void setTaskLocation(String taskLocation) {
        this.taskLocation = taskLocation;
    }

    int getExpeditiousChargeCount() {
        return this.expeditiousChargeCount;
    }

    void setExpeditiousChargeCount(int expeditiousChargeCount) {
        this.expeditiousChargeCount = expeditiousChargeCount;
    }

    int getSlaughterChargeCount() {
        return this.slaughterChargeCount;
    }

    void setSlaughterChargeCount(int slaughterChargeCount) {
        this.slaughterChargeCount = slaughterChargeCount;
    }

    String getTaskName() {
        return this.taskName;
    }

    void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    int getStreak() {
        return this.streak;
    }

    int getPoints() {
        return this.points;
    }
}

