/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.slayer;

import com.google.common.collect.ImmutableSet;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.plugins.slayer.SlayerConfig;
import net.runelite.client.plugins.slayer.SlayerPlugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

class SlayerOverlay
extends WidgetItemOverlay {
    private static final Set<Integer> SLAYER_JEWELRY = ImmutableSet.of(Integer.valueOf(11873), Integer.valueOf(11872), Integer.valueOf(11871), Integer.valueOf(11870), Integer.valueOf(11869), Integer.valueOf(11868), new Integer[]{11867, 11866});
    private static final Set<Integer> ALL_SLAYER_ITEMS = ImmutableSet.of(Integer.valueOf(11864), Integer.valueOf(11865), Integer.valueOf(19639), Integer.valueOf(19641), Integer.valueOf(19643), Integer.valueOf(19645), new Integer[]{21264, 21266, 19647, 19649, 21888, 21890, 23073, 23075, 21268, 4155, 21270, 21183, 21177, 11873, 11872, 11871, 11870, 11869, 11868, 11867, 11866});
    private final SlayerConfig config;
    private final SlayerPlugin plugin;

    @Inject
    private SlayerOverlay(SlayerPlugin plugin, SlayerConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.showOnInventory();
        this.showOnEquipment();
    }

    @Override
    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (!ALL_SLAYER_ITEMS.contains(itemId)) {
            return;
        }
        if (!this.config.showItemOverlay()) {
            return;
        }
        int amount = this.plugin.getAmount();
        if (amount <= 0) {
            return;
        }
        int slaughterCount = this.plugin.getSlaughterChargeCount();
        int expeditiousCount = this.plugin.getExpeditiousChargeCount();
        graphics.setFont(FontManager.getRunescapeSmallFont());
        Rectangle bounds = itemWidget.getCanvasBounds();
        TextComponent textComponent = new TextComponent();
        switch (itemId) {
            case 21177: {
                textComponent.setText(String.valueOf(expeditiousCount));
                break;
            }
            case 21183: {
                textComponent.setText(String.valueOf(slaughterCount));
                break;
            }
            default: {
                textComponent.setText(String.valueOf(amount));
            }
        }
        textComponent.setPosition(new Point(bounds.x - 1, bounds.y - 1 + (SLAYER_JEWELRY.contains(itemId) ? bounds.height : graphics.getFontMetrics().getHeight())));
        textComponent.render(graphics);
    }
}

