/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.skillcalculator;

import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.skillcalculator.SkillCalculatorPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Skill Calculator", description="Enable the Skill Calculator panel", tags={"panel", "skilling"})
public class SkillCalculatorPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton uiNavigationButton;

    @Override
    protected void startUp() throws Exception {
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "calc.png");
        SkillCalculatorPanel uiPanel = new SkillCalculatorPanel(this.skillIconManager, this.client, this.spriteManager, this.itemManager);
        this.uiNavigationButton = NavigationButton.builder().tooltip("Skill Calculator").icon(icon).priority(6).panel(uiPanel).build();
        this.clientToolbar.addNavigation(this.uiNavigationButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.uiNavigationButton);
    }
}

