/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.skillcalculator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.skillcalculator.CacheSkillData;
import net.runelite.client.plugins.skillcalculator.CalculatorType;
import net.runelite.client.plugins.skillcalculator.UIActionSlot;
import net.runelite.client.plugins.skillcalculator.UICalculatorInputArea;
import net.runelite.client.plugins.skillcalculator.UICombinedActionSlot;
import net.runelite.client.plugins.skillcalculator.beans.SkillData;
import net.runelite.client.plugins.skillcalculator.beans.SkillDataBonus;
import net.runelite.client.plugins.skillcalculator.beans.SkillDataEntry;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.IconTextField;

class SkillCalculator
extends JPanel {
    private static final int MAX_XP_RATE = 50;
    private static final int MAX_XP = 200000000;
    private static final DecimalFormat XP_FORMAT = new DecimalFormat("#.#");
    private final UICalculatorInputArea uiInput;
    private final Client client;
    private final SpriteManager spriteManager;
    private final ItemManager itemManager;
    private final List<UIActionSlot> uiActionSlots = new ArrayList<UIActionSlot>();
    private final CacheSkillData cacheSkillData = new CacheSkillData();
    private final UICombinedActionSlot combinedActionSlot;
    private final ArrayList<UIActionSlot> combinedActionSlots = new ArrayList();
    private final List<JCheckBox> bonusCheckBoxes = new ArrayList<JCheckBox>();
    private final IconTextField searchBar = new IconTextField();
    private SkillData skillData;
    private int currentLevel = 1;
    private int currentXP = Experience.getXpForLevel(this.currentLevel);
    private int targetLevel = this.currentLevel + 1;
    private int targetXP = Experience.getXpForLevel(this.targetLevel);
    private float xpFactor = 1.0f;
    private int currentXPRate = 1;

    SkillCalculator(Client client2, UICalculatorInputArea uiInput, SpriteManager spriteManager, ItemManager itemManager) {
        this.client = client2;
        this.uiInput = uiInput;
        this.spriteManager = spriteManager;
        this.itemManager = itemManager;
        this.combinedActionSlot = new UICombinedActionSlot(spriteManager);
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.addKeyListener((KeyEvent e) -> this.onSearch());
        this.setLayout(new DynamicGridLayout(0, 1, 0, 5));
        uiInput.getUiFieldCurrentLevel().addActionListener(e -> {
            this.onFieldCurrentLevelUpdated();
            uiInput.getUiFieldTargetLevel().requestFocusInWindow();
        });
        uiInput.getUiFieldCurrentXP().addActionListener(e -> {
            this.onFieldCurrentXPUpdated();
            uiInput.getUiFieldTargetXP().requestFocusInWindow();
        });
        uiInput.getUiFieldTargetLevel().addActionListener(e -> this.onFieldTargetLevelUpdated());
        uiInput.getUiFieldTargetXP().addActionListener(e -> this.onFieldTargetXPUpdated());
        uiInput.getUiFieldXPRate().addActionListener(e -> this.onFieldXPRateUpdated());
    }

    void openCalculator(CalculatorType calculatorType) {
        this.skillData = this.cacheSkillData.getSkillData(calculatorType.getDataFile());
        this.xpFactor = 1.0f;
        this.currentXP = this.client.getSkillExperience(calculatorType.getSkill());
        this.currentLevel = Experience.getLevelForXp(this.currentXP);
        this.targetLevel = SkillCalculator.enforceSkillBounds(this.currentLevel + 1);
        this.targetXP = Experience.getXpForLevel(this.targetLevel);
        this.currentXPRate = 1;
        this.removeAll();
        this.searchBar.setText(null);
        this.renderBonusOptions();
        this.add(this.combinedActionSlot);
        this.add(this.searchBar);
        this.renderActionSlots();
        this.updateInputFields();
    }

    private void updateCombinedAction() {
        int size = this.combinedActionSlots.size();
        if (size > 1) {
            this.combinedActionSlot.setTitle(size + " actions selected");
        } else if (size == 1) {
            this.combinedActionSlot.setTitle("1 action selected");
        } else {
            this.combinedActionSlot.setTitle("No action selected");
            this.combinedActionSlot.setText("Shift-click to select multiple");
            return;
        }
        int actionCount = 0;
        int neededXP = this.targetXP - this.currentXP;
        double xp = 0.0;
        for (UIActionSlot slot : this.combinedActionSlots) {
            xp += slot.getValue();
        }
        if (neededXP > 0) {
            assert (xp != 0.0);
            actionCount = (int)Math.ceil((double)neededXP / xp);
        }
        this.combinedActionSlot.setText(this.formatXPActionString(xp, actionCount, "exp - "));
    }

    private void clearCombinedSlots() {
        for (UIActionSlot slot : this.combinedActionSlots) {
            slot.setSelected(false);
        }
        this.combinedActionSlots.clear();
    }

    private void renderBonusOptions() {
        if (this.skillData.getBonuses() != null) {
            for (SkillDataBonus bonus : this.skillData.getBonuses()) {
                JPanel checkboxPanel = this.buildCheckboxPanel(bonus);
                this.add(checkboxPanel);
                this.add(Box.createRigidArea(new Dimension(0, 5)));
            }
        }
    }

    private JPanel buildCheckboxPanel(SkillDataBonus bonus) {
        JPanel uiOption = new JPanel(new BorderLayout());
        JLabel uiLabel = new JLabel(bonus.getName());
        JCheckBox uiCheckbox = new JCheckBox();
        uiLabel.setForeground(Color.WHITE);
        uiLabel.setFont(FontManager.getRunescapeSmallFont());
        uiOption.setBorder(BorderFactory.createEmptyBorder(3, 7, 3, 0));
        uiOption.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        uiCheckbox.addActionListener(event -> this.adjustCheckboxes(uiCheckbox, bonus));
        uiCheckbox.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
        uiOption.add((Component)uiLabel, "West");
        uiOption.add((Component)uiCheckbox, "East");
        this.bonusCheckBoxes.add(uiCheckbox);
        return uiOption;
    }

    private void adjustCheckboxes(JCheckBox target, SkillDataBonus bonus) {
        this.adjustXPBonus(0.0f);
        this.bonusCheckBoxes.forEach(otherSelectedCheckbox -> {
            if (otherSelectedCheckbox != target) {
                otherSelectedCheckbox.setSelected(false);
            }
        });
        if (target.isSelected()) {
            this.adjustXPBonus(bonus.getValue());
        }
    }

    private void renderActionSlots() {
        this.uiActionSlots.clear();
        for (SkillDataEntry action : this.skillData.getActions()) {
            JLabel uiIcon = new JLabel();
            if (action.getIcon() != null) {
                this.itemManager.getImage(action.getIcon()).addTo(uiIcon);
            } else if (action.getSprite() != null) {
                this.spriteManager.addSpriteTo(uiIcon, (int)action.getSprite(), 0);
            }
            final UIActionSlot slot = new UIActionSlot(action, uiIcon);
            this.uiActionSlots.add(slot);
            this.add(slot);
            slot.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!e.isShiftDown()) {
                        SkillCalculator.this.clearCombinedSlots();
                    }
                    if (slot.isSelected()) {
                        SkillCalculator.this.combinedActionSlots.remove(slot);
                    } else {
                        SkillCalculator.this.combinedActionSlots.add(slot);
                    }
                    slot.setSelected(!slot.isSelected());
                    SkillCalculator.this.updateCombinedAction();
                }
            });
        }
        this.revalidate();
        this.repaint();
    }

    private void calculate() {
        for (UIActionSlot slot : this.uiActionSlots) {
            int actionCount = 0;
            int neededXP = this.targetXP - this.currentXP;
            SkillDataEntry action = slot.getAction();
            double xp = (action.isIgnoreBonus() ? action.getXp() : action.getXp() * (double)this.xpFactor) * (double)this.currentXPRate;
            if (neededXP > 0) {
                actionCount = (int)Math.ceil((double)neededXP / xp);
            }
            slot.setText("Lvl. " + action.getLevel() + " (" + this.formatXPActionString(xp, actionCount, "exp) - "));
            slot.setAvailable(this.currentLevel >= action.getLevel());
            slot.setOverlapping(action.getLevel() < this.targetLevel);
            slot.setValue(xp);
        }
        this.updateCombinedAction();
    }

    private String formatXPActionString(double xp, int actionCount, String expExpression) {
        return XP_FORMAT.format(xp) + expExpression + NumberFormat.getIntegerInstance().format(actionCount) + (actionCount > 1 ? " actions" : " action");
    }

    private void updateInputFields() {
        if (this.targetXP < this.currentXP) {
            this.targetLevel = SkillCalculator.enforceSkillBounds(this.currentLevel + 1);
            this.targetXP = Experience.getXpForLevel(this.targetLevel);
        }
        this.uiInput.setCurrentLevelInput(this.currentLevel);
        this.uiInput.setCurrentXPInput(this.currentXP);
        this.uiInput.setTargetLevelInput(this.targetLevel);
        this.uiInput.setTargetXPInput(this.targetXP);
        this.uiInput.setXPRate(this.currentXPRate);
        this.calculate();
    }

    private void adjustXPBonus(float value) {
        this.xpFactor = 1.0f + value;
        this.calculate();
    }

    private void onFieldCurrentLevelUpdated() {
        this.currentLevel = SkillCalculator.enforceSkillBounds(this.uiInput.getCurrentLevelInput());
        this.currentXP = Experience.getXpForLevel(this.currentLevel);
        this.updateInputFields();
    }

    private void onFieldCurrentXPUpdated() {
        this.currentXP = SkillCalculator.enforceXPBounds(this.uiInput.getCurrentXPInput());
        this.currentLevel = Experience.getLevelForXp(this.currentXP);
        this.updateInputFields();
    }

    private void onFieldTargetLevelUpdated() {
        this.targetLevel = SkillCalculator.enforceSkillBounds(this.uiInput.getTargetLevelInput());
        this.targetXP = Experience.getXpForLevel(this.targetLevel);
        this.updateInputFields();
    }

    private void onFieldTargetXPUpdated() {
        this.targetXP = SkillCalculator.enforceXPBounds(this.uiInput.getTargetXPInput());
        this.targetLevel = Experience.getLevelForXp(this.targetXP);
        this.updateInputFields();
    }

    private void onFieldXPRateUpdated() {
        this.currentXPRate = SkillCalculator.enforceXPRateBounds(this.uiInput.getXPRate());
        this.updateInputFields();
    }

    private static int enforceSkillBounds(int input) {
        return Math.min(126, Math.max(1, input));
    }

    private static int enforceXPRateBounds(int input) {
        return Math.min(50, Math.max(1, input));
    }

    private static int enforceXPBounds(int input) {
        return Math.min(200000000, Math.max(0, input));
    }

    private void onSearch() {
        this.uiActionSlots.forEach(slot -> {
            if (this.slotContainsText((UIActionSlot)slot, this.searchBar.getText())) {
                super.add((Component)slot);
            } else {
                super.remove((Component)slot);
            }
            this.revalidate();
        });
    }

    private boolean slotContainsText(UIActionSlot slot, String text) {
        return slot.getAction().getName().toLowerCase().contains(text.toLowerCase());
    }
}

