/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.screenshot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.EnumSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.WorldType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.LocalPlayerDeath;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.screenshot.ScreenshotConfig;
import net.runelite.client.plugins.screenshot.ScreenshotOverlay;
import net.runelite.client.plugins.screenshot.imgur.ImageUploadRequest;
import net.runelite.client.plugins.screenshot.imgur.ImageUploadResponse;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Screenshot", description="Enable the manual and automatic taking of screenshots", tags={"external", "images", "imgur", "integration", "notifications"}, enabledByDefault=false)
public class ScreenshotPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ScreenshotPlugin.class);
    private static final String IMGUR_CLIENT_ID = "30d71e5f6860809";
    private static final HttpUrl IMGUR_IMAGE_UPLOAD_URL = HttpUrl.parse("https://api.imgur.com/3/image");
    private static final MediaType JSON = MediaType.parse("application/json");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([0-9]+)");
    private static final Pattern LEVEL_UP_PATTERN = Pattern.compile(".*Your ([a-zA-Z]+) (?:level is|are)? now (\\d+)\\.");
    private static final Pattern BOSSKILL_MESSAGE_PATTERN = Pattern.compile("Your (.+) kill count is: <col=ff0000>(\\d+)</col>.");
    private static final Pattern VALUABLE_DROP_PATTERN = Pattern.compile(".*Valuable drop: ([^<>]+)(?:</col>)?");
    private static final Pattern UNTRADEABLE_DROP_PATTERN = Pattern.compile(".*Untradeable drop: ([^<>]+)(?:</col>)?");
    private static final Pattern DUEL_END_PATTERN = Pattern.compile("You have now (won|lost) ([0-9]+) duels?\\.");
    private static final ImmutableList<String> PET_MESSAGES = ImmutableList.of("You have a funny feeling like you're being followed", "You feel something weird sneaking into your backpack", "You have a funny feeling like you would have been followed");
    private String clueType;
    private Integer clueNumber;
    private Integer barrowsNumber;
    private Integer chambersOfXericNumber;
    private Integer chambersOfXericChallengeNumber;
    private Integer theatreOfBloodNumber;
    private boolean shouldTakeScreenshot;
    @Inject
    private ScreenshotConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ScreenshotOverlay screenshotOverlay;
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private ClientUI clientUi;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private DrawManager drawManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private KeyManager keyManager;
    @Inject
    private SpriteManager spriteManager;
    private BufferedImage reportButton;
    private NavigationButton titleBarButton;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.hotkey()){

        @Override
        public void hotkeyPressed() {
            ScreenshotPlugin.this.takeScreenshot(ScreenshotPlugin.format(new Date()));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String format(Date date) {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            return TIME_FORMAT.format(date);
        }
    }

    @Provides
    ScreenshotConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(ScreenshotConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.screenshotOverlay);
        RuneLite.SCREENSHOT_DIR.mkdirs();
        this.keyManager.registerKeyListener(this.hotkeyListener);
        BufferedImage iconImage = ImageUtil.getResourceStreamFromClass(this.getClass(), "screenshot.png");
        this.titleBarButton = NavigationButton.builder().tab(false).tooltip("Take screenshot").icon(iconImage).onClick(() -> this.takeScreenshot(ScreenshotPlugin.format(new Date()))).popup(ImmutableMap.builder().put("Open screenshot folder...", () -> {
            try {
                Desktop.getDesktop().open(RuneLite.SCREENSHOT_DIR);
            }
            catch (IOException ex) {
                log.warn("Error opening screenshot dir", ex);
            }
        }).build()).build();
        this.clientToolbar.addNavigation(this.titleBarButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.screenshotOverlay);
        this.clientToolbar.removeNavigation(this.titleBarButton);
        this.keyManager.unregisterKeyListener(this.hotkeyListener);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN && this.reportButton == null) {
            this.reportButton = this.spriteManager.getSprite(1024, 0);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.shouldTakeScreenshot) {
            return;
        }
        this.shouldTakeScreenshot = false;
        Object fileName = null;
        if (this.client.getWidget(WidgetInfo.LEVEL_UP_LEVEL) != null) {
            fileName = this.parseLevelUpWidget(WidgetInfo.LEVEL_UP_LEVEL);
        } else if (this.client.getWidget(WidgetInfo.DIALOG_SPRITE_TEXT) != null) {
            fileName = this.parseLevelUpWidget(WidgetInfo.DIALOG_SPRITE_TEXT);
        } else if (this.client.getWidget(WidgetInfo.QUEST_COMPLETED_NAME_TEXT) != null) {
            String text = this.client.getWidget(WidgetInfo.QUEST_COMPLETED_NAME_TEXT).getText();
            fileName = "Quest(" + text.substring(19, text.length() - 1) + ")";
        }
        if (fileName != null) {
            this.takeScreenshot((String)fileName);
        }
    }

    @Subscribe
    public void onLocalPlayerDeath(LocalPlayerDeath death) {
        if (this.config.screenshotPlayerDeath()) {
            this.takeScreenshot("Death " + ScreenshotPlugin.format(new Date()));
        }
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        if (this.config.screenshotKills()) {
            Player player = playerLootReceived.getPlayer();
            String name = player.getName();
            String fileName = "Kill " + name + " " + ScreenshotPlugin.format(new Date());
            this.takeScreenshot(fileName);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String fileName;
        String fileName2;
        Matcher m;
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.TRADE) {
            return;
        }
        String chatMessage = event.getMessage();
        if (chatMessage.contains("You have completed") && chatMessage.contains("Treasure") && (m = NUMBER_PATTERN.matcher(Text.removeTags(chatMessage))).find()) {
            this.clueNumber = Integer.valueOf(m.group());
            this.clueType = chatMessage.substring(chatMessage.lastIndexOf(m.group()) + m.group().length() + 1, chatMessage.indexOf("Treasure") - 1);
            return;
        }
        if (chatMessage.startsWith("Your Barrows chest count is") && (m = NUMBER_PATTERN.matcher(Text.removeTags(chatMessage))).find()) {
            this.barrowsNumber = Integer.valueOf(m.group());
            return;
        }
        if (chatMessage.startsWith("Your completed Chambers of Xeric count is:") && (m = NUMBER_PATTERN.matcher(Text.removeTags(chatMessage))).find()) {
            this.chambersOfXericNumber = Integer.valueOf(m.group());
            return;
        }
        if (chatMessage.startsWith("Your completed Chambers of Xeric Challenge Mode count is:") && (m = NUMBER_PATTERN.matcher(Text.removeTags(chatMessage))).find()) {
            this.chambersOfXericChallengeNumber = Integer.valueOf(m.group());
            return;
        }
        if (chatMessage.startsWith("Your completed Theatre of Blood count is:") && (m = NUMBER_PATTERN.matcher(Text.removeTags(chatMessage))).find()) {
            this.theatreOfBloodNumber = Integer.valueOf(m.group());
            return;
        }
        if (this.config.screenshotPet()) {
            if (PET_MESSAGES.stream().anyMatch(chatMessage::contains)) {
                String fileName3 = "Pet " + ScreenshotPlugin.format(new Date());
                this.takeScreenshot(fileName3);
            }
        }
        if (this.config.screenshotBossKills() && (m = BOSSKILL_MESSAGE_PATTERN.matcher(chatMessage)).matches()) {
            String bossName = m.group(1);
            String bossKillcount = m.group(2);
            fileName2 = bossName + "(" + bossKillcount + ")";
            this.takeScreenshot(fileName2);
        }
        if (this.config.screenshotValuableDrop() && (m = VALUABLE_DROP_PATTERN.matcher(chatMessage)).matches()) {
            String valuableDropName = m.group(1);
            fileName = "Valuable drop " + valuableDropName + " " + ScreenshotPlugin.format(new Date());
            this.takeScreenshot(fileName);
        }
        if (this.config.screenshotUntradeableDrop() && (m = UNTRADEABLE_DROP_PATTERN.matcher(chatMessage)).matches()) {
            String untradeableDropName = m.group(1);
            fileName = "Untradeable drop " + untradeableDropName + " " + ScreenshotPlugin.format(new Date());
            this.takeScreenshot(fileName);
        }
        if (this.config.screenshotDuels() && (m = DUEL_END_PATTERN.matcher(chatMessage)).find()) {
            String result = m.group(1);
            String count = m.group(2);
            fileName2 = "Duel " + result + " (" + count + ")";
            this.takeScreenshot(fileName2);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        String fileName;
        int groupId = event.getGroupId();
        switch (groupId) {
            case 23: 
            case 73: 
            case 155: 
            case 277: 
            case 539: {
                if (this.config.screenshotRewards()) break;
                return;
            }
            case 193: 
            case 233: {
                if (this.config.screenshotLevels()) break;
                return;
            }
            case 392: {
                if (this.config.screenshotKingdom()) break;
                return;
            }
        }
        switch (groupId) {
            case 392: {
                fileName = "Kingdom " + LocalDate.now();
                this.takeScreenshot(fileName);
                break;
            }
            case 539: {
                if (this.chambersOfXericNumber != null) {
                    fileName = "Chambers of Xeric(" + this.chambersOfXericNumber + ")";
                    this.chambersOfXericNumber = null;
                    break;
                }
                if (this.chambersOfXericChallengeNumber != null) {
                    fileName = "Chambers of Xeric Challenge Mode(" + this.chambersOfXericChallengeNumber + ")";
                    this.chambersOfXericChallengeNumber = null;
                    break;
                }
                return;
            }
            case 23: {
                if (this.theatreOfBloodNumber == null) {
                    return;
                }
                fileName = "Theatre of Blood(" + this.theatreOfBloodNumber + ")";
                this.theatreOfBloodNumber = null;
                break;
            }
            case 155: {
                if (this.barrowsNumber == null) {
                    return;
                }
                fileName = "Barrows(" + this.barrowsNumber + ")";
                this.barrowsNumber = null;
                break;
            }
            case 193: 
            case 233: 
            case 277: {
                this.shouldTakeScreenshot = true;
                return;
            }
            case 73: {
                if (this.clueType == null || this.clueNumber == null) {
                    return;
                }
                fileName = Character.toUpperCase(this.clueType.charAt(0)) + this.clueType.substring(1) + "(" + this.clueNumber + ")";
                this.clueType = null;
                this.clueNumber = null;
                break;
            }
            default: {
                return;
            }
        }
        this.takeScreenshot(fileName);
    }

    String parseLevelUpWidget(WidgetInfo levelUpLevel) {
        Widget levelChild = this.client.getWidget(levelUpLevel);
        if (levelChild == null) {
            return null;
        }
        Matcher m = LEVEL_UP_PATTERN.matcher(levelChild.getText());
        if (!m.matches()) {
            return null;
        }
        String skillName = m.group(1);
        String skillLevel = m.group(2);
        return skillName + "(" + skillLevel + ")";
    }

    private void takeScreenshot(String fileName) {
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            log.info("Login screenshot prevented");
            return;
        }
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> this.takeScreenshot(fileName, (Image)img));
        if (this.config.displayDate()) {
            this.screenshotOverlay.queueForTimestamp(imageCallback);
        } else {
            this.drawManager.requestNextFrameListener(imageCallback);
        }
    }

    private void takeScreenshot(String fileName, Image image) {
        File playerFolder;
        BufferedImage screenshot = this.config.includeFrame() ? new BufferedImage(this.clientUi.getWidth(), this.clientUi.getHeight(), 2) : new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics graphics = screenshot.getGraphics();
        int gameOffsetX = 0;
        int gameOffsetY = 0;
        if (this.config.includeFrame()) {
            try {
                SwingUtilities.invokeAndWait(() -> this.clientUi.paint(graphics));
            }
            catch (InterruptedException | InvocationTargetException e) {
                log.warn("unable to paint client UI on screenshot", e);
            }
            Point canvasOffset = this.clientUi.getCanvasOffset();
            gameOffsetX = canvasOffset.getX();
            gameOffsetY = canvasOffset.getY();
        }
        graphics.drawImage(image, gameOffsetX, gameOffsetY, null);
        if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null) {
            EnumSet<WorldType> worldTypes = this.client.getWorldType();
            boolean dmm = worldTypes.contains((Object)WorldType.DEADMAN);
            boolean sdmm = worldTypes.contains((Object)WorldType.SEASONAL_DEADMAN);
            boolean dmmt = worldTypes.contains((Object)WorldType.DEADMAN_TOURNAMENT);
            boolean isDmmWorld = dmm || sdmm || dmmt;
            Object playerDir = this.client.getLocalPlayer().getName();
            if (isDmmWorld) {
                playerDir = (String)playerDir + "-Deadman";
            }
            playerFolder = new File(RuneLite.SCREENSHOT_DIR, (String)playerDir);
        } else {
            playerFolder = RuneLite.SCREENSHOT_DIR;
        }
        playerFolder.mkdirs();
        try {
            File screenshotFile = new File(playerFolder, fileName + ".png");
            ImageIO.write((RenderedImage)screenshot, "PNG", screenshotFile);
            if (this.config.uploadScreenshot()) {
                this.uploadScreenshot(screenshotFile);
            } else if (this.config.notifyWhenTaken()) {
                this.notifier.notify("A screenshot was saved to " + screenshotFile, TrayIcon.MessageType.INFO);
            }
        }
        catch (IOException ex) {
            log.warn("error writing screenshot", ex);
        }
    }

    private void uploadScreenshot(File screenshotFile) throws IOException {
        String json = RuneLiteAPI.GSON.toJson(new ImageUploadRequest(screenshotFile));
        Request request = new Request.Builder().url(IMGUR_IMAGE_UPLOAD_URL).addHeader("Authorization", "Client-ID 30d71e5f6860809").post(RequestBody.create(JSON, json)).build();
        RuneLiteAPI.CLIENT.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException ex) {
                log.warn("error uploading screenshot", ex);
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                try (InputStream in = response.body().byteStream();){
                    ImageUploadResponse imageUploadResponse = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), ImageUploadResponse.class);
                    if (imageUploadResponse.isSuccess()) {
                        String link = imageUploadResponse.getData().getLink();
                        StringSelection selection = new StringSelection(link);
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clipboard.setContents(selection, selection);
                        if (ScreenshotPlugin.this.config.notifyWhenTaken()) {
                            ScreenshotPlugin.this.notifier.notify("A screenshot was uploaded and inserted into your clipboard!", TrayIcon.MessageType.INFO);
                        }
                    }
                }
            }
        });
    }

    @VisibleForTesting
    int getClueNumber() {
        return this.clueNumber;
    }

    @VisibleForTesting
    String getClueType() {
        return this.clueType;
    }

    @VisibleForTesting
    int getBarrowsNumber() {
        return this.barrowsNumber;
    }

    @VisibleForTesting
    int getChambersOfXericNumber() {
        return this.chambersOfXericNumber;
    }

    @VisibleForTesting
    int getChambersOfXericChallengeNumber() {
        return this.chambersOfXericChallengeNumber;
    }

    @VisibleForTesting
    int gettheatreOfBloodNumber() {
        return this.theatreOfBloodNumber;
    }

    BufferedImage getReportButton() {
        return this.reportButton;
    }
}

