/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.screenmarkers.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.plugins.screenmarkers.ScreenMarkerOverlay;
import net.runelite.client.plugins.screenmarkers.ScreenMarkerPlugin;
import net.runelite.client.plugins.screenmarkers.ui.ScreenMarkerCreationPanel;
import net.runelite.client.plugins.screenmarkers.ui.ScreenMarkerPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;

@Singleton
public class ScreenMarkerPluginPanel
extends PluginPanel {
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final Color DEFAULT_BORDER_COLOR;
    private static final Color DEFAULT_FILL_COLOR;
    private static final int DEFAULT_BORDER_THICKNESS = 3;
    private final JLabel addMarker = new JLabel(ADD_ICON);
    private final JLabel title = new JLabel();
    private final PluginErrorPanel noMarkersPanel = new PluginErrorPanel();
    @Inject
    private ScreenMarkerPlugin plugin;
    private Color selectedColor = DEFAULT_BORDER_COLOR;
    private Color selectedFillColor = DEFAULT_FILL_COLOR;
    private int selectedBorderThickness = 3;
    private ScreenMarkerCreationPanel creationPanel;

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        this.title.setText("Screen Markers");
        this.title.setForeground(Color.WHITE);
        northPanel.add((Component)this.title, "West");
        northPanel.add((Component)this.addMarker, "East");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel markerView = new JPanel(new GridBagLayout());
        markerView.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        for (ScreenMarkerOverlay marker : this.plugin.getScreenMarkers()) {
            markerView.add((Component)new ScreenMarkerPanel(this.plugin, marker), constraints);
            ++constraints.gridy;
            markerView.add(Box.createRigidArea(new Dimension(0, 10)), constraints);
            ++constraints.gridy;
        }
        this.noMarkersPanel.setContent("Screen Markers", "Highlight a region on your screen.");
        this.noMarkersPanel.setVisible(false);
        if (this.plugin.getScreenMarkers().isEmpty()) {
            this.noMarkersPanel.setVisible(true);
            this.title.setVisible(false);
        }
        markerView.add((Component)this.noMarkersPanel, constraints);
        ++constraints.gridy;
        this.creationPanel = new ScreenMarkerCreationPanel(this.plugin);
        this.creationPanel.setVisible(false);
        markerView.add((Component)this.creationPanel, constraints);
        ++constraints.gridy;
        this.addMarker.setToolTipText("Add new screen marker");
        this.addMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ScreenMarkerPluginPanel.this.setCreation(true);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ScreenMarkerPluginPanel.this.addMarker.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ScreenMarkerPluginPanel.this.addMarker.setIcon(ADD_ICON);
            }
        });
        centerPanel.add((Component)markerView, "Center");
        this.add((Component)northPanel, "North");
        this.add((Component)centerPanel, "Center");
    }

    public void rebuild() {
        this.removeAll();
        this.repaint();
        this.revalidate();
        this.init();
    }

    public void setCreation(boolean on) {
        if (on) {
            this.noMarkersPanel.setVisible(false);
            this.title.setVisible(true);
        } else {
            boolean empty = this.plugin.getScreenMarkers().isEmpty();
            this.noMarkersPanel.setVisible(empty);
            this.title.setVisible(!empty);
        }
        this.creationPanel.setVisible(on);
        this.addMarker.setVisible(!on);
        if (on) {
            this.creationPanel.lockConfirm();
            this.plugin.setMouseListenerEnabled(true);
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public Color getSelectedFillColor() {
        return this.selectedFillColor;
    }

    public int getSelectedBorderThickness() {
        return this.selectedBorderThickness;
    }

    public ScreenMarkerCreationPanel getCreationPanel() {
        return this.creationPanel;
    }

    static {
        DEFAULT_BORDER_COLOR = Color.GREEN;
        DEFAULT_FILL_COLOR = new Color(0, 255, 0, 0);
        BufferedImage addIcon = ImageUtil.getResourceStreamFromClass(ScreenMarkerPlugin.class, "add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset(addIcon, 0.53f));
    }
}

