/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.screenmarkers;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.client.plugins.screenmarkers.ScreenMarker;
import net.runelite.client.plugins.screenmarkers.ScreenMarkerRenderable;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class ScreenMarkerOverlay
extends Overlay {
    private final ScreenMarker marker;
    private final ScreenMarkerRenderable screenMarkerRenderable;

    ScreenMarkerOverlay(ScreenMarker marker) {
        this.marker = marker;
        this.screenMarkerRenderable = new ScreenMarkerRenderable();
        this.setPosition(OverlayPosition.DETACHED);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.setPriority(OverlayPriority.HIGH);
    }

    @Override
    public String getName() {
        return "marker" + this.marker.getId();
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.marker.isVisible()) {
            return null;
        }
        Dimension preferredSize = this.getPreferredSize();
        if (preferredSize == null) {
            return null;
        }
        this.screenMarkerRenderable.setBorderThickness(this.marker.getBorderThickness());
        this.screenMarkerRenderable.setColor(this.marker.getColor());
        this.screenMarkerRenderable.setFill(this.marker.getFill());
        this.screenMarkerRenderable.setStroke(new BasicStroke(this.marker.getBorderThickness()));
        this.screenMarkerRenderable.setPreferredSize(preferredSize);
        return this.screenMarkerRenderable.render(graphics);
    }

    public ScreenMarker getMarker() {
        return this.marker;
    }
}

