/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.runepouch;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.Varbits;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.runepouch.RunepouchConfig;
import net.runelite.client.plugins.runepouch.Runes;
import net.runelite.client.plugins.runepouch.config.RunePouchOverlayMode;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

public class RunepouchOverlay
extends WidgetItemOverlay {
    private static final Varbits[] AMOUNT_VARBITS = new Varbits[]{Varbits.RUNE_POUCH_AMOUNT1, Varbits.RUNE_POUCH_AMOUNT2, Varbits.RUNE_POUCH_AMOUNT3};
    private static final Varbits[] RUNE_VARBITS = new Varbits[]{Varbits.RUNE_POUCH_RUNE1, Varbits.RUNE_POUCH_RUNE2, Varbits.RUNE_POUCH_RUNE3};
    private static final Dimension IMAGE_SIZE = new Dimension(11, 11);
    private final Client client;
    private final RunepouchConfig config;
    private final TooltipManager tooltipManager;
    @Inject
    private ItemManager itemManager;

    @Inject
    RunepouchOverlay(Client client2, RunepouchConfig config, TooltipManager tooltipManager) {
        this.tooltipManager = tooltipManager;
        this.client = client2;
        this.config = config;
        this.showOnInventory();
        this.showOnBank();
    }

    @Override
    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (itemId != 12791 && itemId != 30006) {
            return;
        }
        assert (AMOUNT_VARBITS.length == RUNE_VARBITS.length);
        graphics.setFont(FontManager.getRunescapeSmallFont());
        Point location = itemWidget.getCanvasLocation();
        StringBuilder tooltipBuilder = new StringBuilder();
        for (int i = 0; i < AMOUNT_VARBITS.length; ++i) {
            BufferedImage image;
            Varbits runeVarbit;
            int runeId;
            Runes rune;
            Varbits amountVarbit = AMOUNT_VARBITS[i];
            int amount = this.client.getVar(amountVarbit);
            if (amount <= 0 || (rune = Runes.getRune(runeId = this.client.getVar(runeVarbit = RUNE_VARBITS[i]))) == null) continue;
            tooltipBuilder.append(amount).append(" ").append(ColorUtil.wrapWithColorTag(rune.getName(), Color.YELLOW)).append("</br>");
            if (this.config.runePouchOverlayMode() == RunePouchOverlayMode.MOUSE_HOVER) continue;
            graphics.setColor(Color.black);
            graphics.drawString(RunepouchOverlay.formatNumber(amount), location.getX() + (this.config.showIcons() ? 13 : 6), location.getY() + 14 + (graphics.getFontMetrics().getHeight() - 1) * i);
            graphics.setColor(this.config.fontColor());
            graphics.drawString(RunepouchOverlay.formatNumber(amount), location.getX() + (this.config.showIcons() ? 12 : 5), location.getY() + 13 + (graphics.getFontMetrics().getHeight() - 1) * i);
            if (!this.config.showIcons() || (image = this.getRuneImage(rune)) == null) continue;
            OverlayUtil.renderImageLocation(graphics, new Point(location.getX(), location.getY() + graphics.getFontMetrics().getHeight() * i), image);
        }
        String tooltip = tooltipBuilder.toString();
        if (!tooltip.isEmpty() && itemWidget.getCanvasBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY()) && (this.config.runePouchOverlayMode() == RunePouchOverlayMode.MOUSE_HOVER || this.config.runePouchOverlayMode() == RunePouchOverlayMode.BOTH)) {
            this.tooltipManager.add(new Tooltip(tooltip));
        }
    }

    private BufferedImage getRuneImage(Runes rune) {
        BufferedImage runeImg = rune.getImage();
        if (runeImg != null) {
            return runeImg;
        }
        runeImg = this.itemManager.getImage(rune.getItemId());
        if (runeImg == null) {
            return null;
        }
        BufferedImage resizedImg = new BufferedImage(RunepouchOverlay.IMAGE_SIZE.width, RunepouchOverlay.IMAGE_SIZE.height, 2);
        Graphics2D g = resizedImg.createGraphics();
        g.drawImage(runeImg, 0, 0, RunepouchOverlay.IMAGE_SIZE.width, RunepouchOverlay.IMAGE_SIZE.height, null);
        g.dispose();
        rune.setImage(resizedImg);
        return resizedImg;
    }

    private static String formatNumber(int amount) {
        return amount < 1000 ? String.valueOf(amount) : amount / 1000 + "K";
    }
}

