/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.runenergy;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Skill;
import net.runelite.api.Varbits;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.runenergy.RunEnergyConfig;
import net.runelite.client.plugins.runenergy.RunEnergyOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.StringUtils;

@PluginDescriptor(name="Run Energy", description="Show various information related to run energy", tags={"overlay", "stamina"})
public class RunEnergyPlugin
extends Plugin {
    private static final ImmutableSet<Integer> ALL_GRACEFUL_HOODS = ImmutableSet.of(Integer.valueOf(11851), Integer.valueOf(13579), Integer.valueOf(13580), Integer.valueOf(13591), Integer.valueOf(13592), Integer.valueOf(13603), new Integer[]{13604, 13615, 13616, 13627, 13628, 13667, 13668, 21061, 21063});
    private static final ImmutableSet<Integer> ALL_GRACEFUL_TOPS = ImmutableSet.of(Integer.valueOf(11855), Integer.valueOf(13583), Integer.valueOf(13584), Integer.valueOf(13595), Integer.valueOf(13596), Integer.valueOf(13607), new Integer[]{13608, 13619, 13620, 13631, 13632, 13671, 13672, 21067, 21069});
    private static final ImmutableSet<Integer> ALL_GRACEFUL_LEGS = ImmutableSet.of(Integer.valueOf(11857), Integer.valueOf(13585), Integer.valueOf(13586), Integer.valueOf(13597), Integer.valueOf(13598), Integer.valueOf(13609), new Integer[]{13610, 13621, 13622, 13633, 13634, 13673, 13674, 21070, 21072});
    private static final ImmutableSet<Integer> ALL_GRACEFUL_GLOVES = ImmutableSet.of(Integer.valueOf(11859), Integer.valueOf(13587), Integer.valueOf(13588), Integer.valueOf(13599), Integer.valueOf(13600), Integer.valueOf(13611), new Integer[]{13612, 13623, 13624, 13635, 13636, 13675, 13676, 21073, 21075});
    private static final ImmutableSet<Integer> ALL_GRACEFUL_BOOTS = ImmutableSet.of(Integer.valueOf(11861), Integer.valueOf(13589), Integer.valueOf(13590), Integer.valueOf(13601), Integer.valueOf(13602), Integer.valueOf(13613), new Integer[]{13614, 13625, 13626, 13637, 13638, 13677, 13678, 21076, 21078});
    private static final ImmutableSet<Integer> ALL_GRACEFUL_CAPES = ImmutableSet.of(Integer.valueOf(11853), Integer.valueOf(13581), Integer.valueOf(13582), Integer.valueOf(13593), Integer.valueOf(13594), Integer.valueOf(13605), new Integer[]{13606, 13617, 13618, 13629, 13630, 13669, 13670, 21064, 21066, 9771, 9772, 13280});
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RunEnergyOverlay energyOverlay;
    @Inject
    private RunEnergyConfig energyConfig;
    private boolean localPlayerRunningToDestination;
    private WorldPoint prevLocalPlayerLocation;

    @Provides
    RunEnergyConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(RunEnergyConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.energyOverlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.energyOverlay);
        this.localPlayerRunningToDestination = false;
        this.prevLocalPlayerLocation = null;
        this.resetRunOrbText();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.localPlayerRunningToDestination = this.prevLocalPlayerLocation != null && this.client.getLocalDestinationLocation() != null && this.prevLocalPlayerLocation.distanceTo(this.client.getLocalPlayer().getWorldLocation()) > 1;
        this.prevLocalPlayerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (this.energyConfig.replaceOrbText()) {
            this.setRunOrbText(this.getEstimatedRunTimeRemaining(true));
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("runenergy") && !this.energyConfig.replaceOrbText()) {
            this.resetRunOrbText();
        }
    }

    private void setRunOrbText(String text) {
        Widget runOrbText = this.client.getWidget(WidgetInfo.MINIMAP_RUN_ORB_TEXT);
        if (runOrbText != null) {
            runOrbText.setText(text);
        }
    }

    private void resetRunOrbText() {
        this.setRunOrbText(Integer.toString(this.client.getEnergy()));
    }

    String getEstimatedRunTimeRemaining(boolean inSeconds) {
        int effectiveWeight = Math.max(this.client.getWeight(), 0);
        double lossRate = (double)Math.min(effectiveWeight, 64) / 100.0 + 0.64;
        if (this.client.getVar(Varbits.RUN_SLOWED_DEPLETION_ACTIVE) != 0) {
            lossRate *= 0.3;
        }
        double secondsLeft = (double)this.client.getEnergy() * 0.6 / lossRate;
        if (inSeconds) {
            return Integer.toString((int)Math.floor(secondsLeft)) + "s";
        }
        int minutes = (int)Math.floor(secondsLeft / 60.0);
        int seconds = (int)Math.floor(secondsLeft - (double)minutes * 60.0);
        return Integer.toString(minutes) + ":" + StringUtils.leftPad(Integer.toString(seconds), 2, "0");
    }

    private boolean isLocalPlayerWearingFullGraceful() {
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment == null) {
            return false;
        }
        Item[] items = equipment.getItems();
        if (items == null || items.length <= EquipmentInventorySlot.BOOTS.getSlotIdx()) {
            return false;
        }
        return ALL_GRACEFUL_HOODS.contains(items[EquipmentInventorySlot.HEAD.getSlotIdx()].getId()) && ALL_GRACEFUL_TOPS.contains(items[EquipmentInventorySlot.BODY.getSlotIdx()].getId()) && ALL_GRACEFUL_LEGS.contains(items[EquipmentInventorySlot.LEGS.getSlotIdx()].getId()) && ALL_GRACEFUL_GLOVES.contains(items[EquipmentInventorySlot.GLOVES.getSlotIdx()].getId()) && ALL_GRACEFUL_BOOTS.contains(items[EquipmentInventorySlot.BOOTS.getSlotIdx()].getId()) && ALL_GRACEFUL_CAPES.contains(items[EquipmentInventorySlot.CAPE.getSlotIdx()].getId());
    }

    int getEstimatedRecoverTimeRemaining() {
        if (this.localPlayerRunningToDestination) {
            return -1;
        }
        double recoverRate = (double)(48 + this.client.getBoostedSkillLevel(Skill.AGILITY)) / 360.0;
        if (this.isLocalPlayerWearingFullGraceful()) {
            recoverRate *= 1.3;
        }
        double secondsLeft = (double)(100 - this.client.getEnergy()) / recoverRate;
        return (int)secondsLeft;
    }
}

