/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.runecraft;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.NPC;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.runecraft.AbyssOverlay;
import net.runelite.client.plugins.runecraft.AbyssRifts;
import net.runelite.client.plugins.runecraft.RunecraftConfig;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Runecraft", description="Show minimap icons and clickboxes for abyssal rifts", tags={"abyssal", "minimap", "overlay", "rifts", "rc", "runecrafting"})
public class RunecraftPlugin
extends Plugin {
    private static final String POUCH_DECAYED_NOTIFICATION_MESSAGE = "Your rune pouch has decayed.";
    private static final String POUCH_DECAYED_MESSAGE = "Your pouch has decayed through use.";
    private static final List<Integer> DEGRADED_POUCHES = ImmutableList.of(Integer.valueOf(5511), Integer.valueOf(5513), Integer.valueOf(5515));
    private final Set<DecorativeObject> abyssObjects = new HashSet<DecorativeObject>();
    private boolean degradedPouchInInventory;
    private NPC darkMage;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AbyssOverlay abyssOverlay;
    @Inject
    private RunecraftConfig config;
    @Inject
    private Notifier notifier;

    @Provides
    RunecraftConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(RunecraftConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.abyssOverlay);
        this.abyssOverlay.updateConfig();
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.abyssOverlay);
        this.abyssObjects.clear();
        this.darkMage = null;
        this.degradedPouchInInventory = false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.abyssOverlay.updateConfig();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (this.config.degradingNotification() && event.getMessage().contains(POUCH_DECAYED_MESSAGE)) {
            this.notifier.notify(POUCH_DECAYED_NOTIFICATION_MESSAGE);
        }
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        DecorativeObject decorativeObject = event.getDecorativeObject();
        if (AbyssRifts.getRift(decorativeObject.getId()) != null) {
            this.abyssObjects.add(decorativeObject);
        }
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        DecorativeObject decorativeObject = event.getDecorativeObject();
        this.abyssObjects.remove(decorativeObject);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState gameState = event.getGameState();
        switch (gameState) {
            case LOADING: {
                this.abyssObjects.clear();
                break;
            }
            case CONNECTION_LOST: 
            case HOPPING: 
            case LOGIN_SCREEN: {
                this.darkMage = null;
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        Item[] items = event.getItemContainer().getItems();
        this.degradedPouchInInventory = Stream.of(items).anyMatch(i -> DEGRADED_POUCHES.contains(i.getId()));
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (npc.getId() == 2583) {
            this.darkMage = npc;
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        NPC npc = event.getNpc();
        if (npc == this.darkMage) {
            this.darkMage = null;
        }
    }

    Set<DecorativeObject> getAbyssObjects() {
        return this.abyssObjects;
    }

    boolean isDegradedPouchInInventory() {
        return this.degradedPouchInInventory;
    }

    NPC getDarkMage() {
        return this.darkMage;
    }
}

