/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.runecraft;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.runecraft.AbyssRifts;
import net.runelite.client.plugins.runecraft.RunecraftConfig;
import net.runelite.client.plugins.runecraft.RunecraftPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class AbyssOverlay
extends Overlay {
    private static final Dimension IMAGE_SIZE = new Dimension(15, 14);
    private final Set<AbyssRifts> rifts = new HashSet<AbyssRifts>();
    private final Map<AbyssRifts, BufferedImage> abyssIcons = new HashMap<AbyssRifts, BufferedImage>();
    private final Client client;
    private final RunecraftPlugin plugin;
    private final RunecraftConfig config;
    @Inject
    private ItemManager itemManager;

    @Inject
    AbyssOverlay(Client client2, RunecraftPlugin plugin, RunecraftConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client2;
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.config.showRifts()) {
            for (DecorativeObject object : this.plugin.getAbyssObjects()) {
                this.renderRifts(graphics, object);
            }
        }
        if (this.config.hightlightDarkMage()) {
            this.highlightDarkMage(graphics);
        }
        return null;
    }

    private void highlightDarkMage(Graphics2D graphics) {
        if (!this.plugin.isDegradedPouchInInventory()) {
            return;
        }
        NPC darkMage = this.plugin.getDarkMage();
        if (darkMage == null) {
            return;
        }
        Polygon tilePoly = darkMage.getCanvasTilePoly();
        if (tilePoly == null) {
            return;
        }
        OverlayUtil.renderPolygon(graphics, tilePoly, Color.green);
    }

    private void renderRifts(Graphics2D graphics, DecorativeObject object) {
        AbyssRifts rift = AbyssRifts.getRift(object.getId());
        if (rift == null || !this.rifts.contains((Object)rift)) {
            return;
        }
        if (this.config.showClickBox()) {
            Point mousePosition = this.client.getMouseCanvasPosition();
            Area objectClickbox = object.getClickbox();
            if (objectClickbox != null) {
                if (objectClickbox.contains(mousePosition.getX(), mousePosition.getY())) {
                    graphics.setColor(Color.MAGENTA.darker());
                } else {
                    graphics.setColor(Color.MAGENTA);
                }
                graphics.draw(objectClickbox);
                graphics.setColor(new Color(255, 0, 255, 20));
                graphics.fill(objectClickbox);
            }
        }
        BufferedImage image = this.getImage(rift);
        Point miniMapImage = Perspective.getMiniMapImageLocation(this.client, object.getLocalLocation(), image);
        if (miniMapImage != null) {
            graphics.drawImage((Image)image, miniMapImage.getX(), miniMapImage.getY(), null);
        }
    }

    public BufferedImage getImage(AbyssRifts rift) {
        BufferedImage image = this.abyssIcons.get((Object)rift);
        if (image != null) {
            return image;
        }
        image = this.itemManager.getImage(rift.getItemId());
        BufferedImage resizedImage = new BufferedImage(AbyssOverlay.IMAGE_SIZE.width, AbyssOverlay.IMAGE_SIZE.height, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(image, 0, 0, AbyssOverlay.IMAGE_SIZE.width, AbyssOverlay.IMAGE_SIZE.height, null);
        g.dispose();
        this.abyssIcons.put(rift, resizedImage);
        return resizedImage;
    }

    public void updateConfig() {
        this.rifts.clear();
        if (this.config.showAir()) {
            this.rifts.add(AbyssRifts.AIR_RIFT);
        }
        if (this.config.showBlood()) {
            this.rifts.add(AbyssRifts.BLOOD_RIFT);
        }
        if (this.config.showBody()) {
            this.rifts.add(AbyssRifts.BODY_RIFT);
        }
        if (this.config.showChaos()) {
            this.rifts.add(AbyssRifts.CHAOS_RIFT);
        }
        if (this.config.showCosmic()) {
            this.rifts.add(AbyssRifts.COSMIC_RIFT);
        }
        if (this.config.showDeath()) {
            this.rifts.add(AbyssRifts.DEATH_RIFT);
        }
        if (this.config.showEarth()) {
            this.rifts.add(AbyssRifts.EARTH_RIFT);
        }
        if (this.config.showFire()) {
            this.rifts.add(AbyssRifts.FIRE_RIFT);
        }
        if (this.config.showLaw()) {
            this.rifts.add(AbyssRifts.LAW_RIFT);
        }
        if (this.config.showMind()) {
            this.rifts.add(AbyssRifts.MIND_RIFT);
        }
        if (this.config.showNature()) {
            this.rifts.add(AbyssRifts.NATURE_RIFT);
        }
        if (this.config.showSoul()) {
            this.rifts.add(AbyssRifts.SOUL_RIFT);
        }
        if (this.config.showWater()) {
            this.rifts.add(AbyssRifts.WATER_RIFT);
        }
    }
}

