/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.roguesden;

import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.events.GameObjectChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GroundObjectChanged;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.roguesden.Obstacles;
import net.runelite.client.plugins.roguesden.RoguesDenOverlay;
import net.runelite.client.ui.overlay.OverlayManager;

public class RoguesDenPlugin
extends Plugin {
    private final HashMap<TileObject, Tile> obstaclesHull = new HashMap();
    private final HashMap<TileObject, Tile> obstaclesTile = new HashMap();
    private boolean hasGem;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RoguesDenOverlay overlay;

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.obstaclesHull.clear();
        this.obstaclesTile.clear();
        this.hasGem = false;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        for (Item item : event.getItemContainer().getItems()) {
            if (item.getId() != 5561) continue;
            this.hasGem = true;
            return;
        }
        this.hasGem = false;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.onTileObject(event.getTile(), null, event.getGameObject());
    }

    @Subscribe
    public void onGameObjectChanged(GameObjectChanged event) {
        this.onTileObject(event.getTile(), event.getPrevious(), event.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.onTileObject(event.getTile(), event.getGameObject(), null);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.onTileObject(event.getTile(), null, event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectChanged(GroundObjectChanged event) {
        this.onTileObject(event.getTile(), event.getPrevious(), event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.onTileObject(event.getTile(), event.getGroundObject(), null);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.obstaclesHull.clear();
            this.obstaclesTile.clear();
        }
    }

    private void onTileObject(Tile tile, TileObject oldObject, TileObject newObject) {
        this.obstaclesHull.remove(oldObject);
        if (newObject != null && Obstacles.OBSTACLE_IDS_HULL.contains(newObject.getId())) {
            this.obstaclesHull.put(newObject, tile);
        }
        this.obstaclesTile.remove(oldObject);
        if (newObject != null && Obstacles.OBSTACLE_IDS_TILE.contains(newObject.getId())) {
            this.obstaclesTile.put(newObject, tile);
        }
    }

    HashMap<TileObject, Tile> getObstaclesHull() {
        return this.obstaclesHull;
    }

    HashMap<TileObject, Tile> getObstaclesTile() {
        return this.obstaclesTile;
    }

    boolean isHasGem() {
        return this.hasGem;
    }
}

