/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.roguesden;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.roguesden.RoguesDenPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class RoguesDenOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 2350;
    private final Client client;
    private final RoguesDenPlugin plugin;

    @Inject
    public RoguesDenOverlay(Client client2, RoguesDenPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client2;
        this.plugin = plugin;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isHasGem()) {
            return null;
        }
        LocalPoint playerLocation = this.client.getLocalPlayer().getLocalLocation();
        this.plugin.getObstaclesHull().forEach((obstacle, tile) -> {
            Polygon p;
            if (tile.getPlane() == this.client.getPlane() && obstacle.getLocalLocation().distanceTo(playerLocation) < 2350 && (p = tile.getGameObjects()[0].getConvexHull()) != null) {
                graphics.setColor(Color.CYAN);
                graphics.drawPolygon(p);
            }
        });
        this.plugin.getObstaclesTile().forEach((obstacle, tile) -> {
            Polygon p;
            if (tile.getPlane() == this.client.getPlane() && obstacle.getLocalLocation().distanceTo(playerLocation) < 2350 && (p = obstacle.getCanvasTilePoly()) != null) {
                graphics.setColor(Color.CYAN);
                graphics.drawPolygon(p);
            }
        });
        return null;
    }
}

