/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.reportbutton;

import com.google.inject.Provides;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.reportbutton.ReportButtonConfig;
import net.runelite.client.task.Schedule;

@PluginDescriptor(name="Report Button", description="Replace the text on the Report button with the current time", tags={"time", "utc"})
public class ReportButtonPlugin
extends Plugin {
    private static final ZoneId UTC = ZoneId.of("UTC");
    private static final ZoneId JAGEX = ZoneId.of("Europe/London");
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MMM. dd, yyyy");
    private Instant loginTime;
    private boolean ready;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ReportButtonConfig config;

    @Provides
    ReportButtonConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(ReportButtonConfig.class);
    }

    @Override
    public void startUp() {
        this.clientThread.invoke(this::updateReportButtonTime);
    }

    @Override
    public void shutDown() {
        this.clientThread.invoke(() -> {
            Widget reportButton = this.client.getWidget(WidgetInfo.CHATBOX_REPORT_TEXT);
            if (reportButton != null) {
                reportButton.setText("Report");
            }
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState state = event.getGameState();
        switch (state) {
            case LOGGING_IN: 
            case HOPPING: 
            case CONNECTION_LOST: {
                this.ready = true;
                break;
            }
            case LOGGED_IN: {
                if (!this.ready) break;
                this.loginTime = Instant.now();
                this.ready = false;
            }
        }
    }

    @Schedule(period=500L, unit=ChronoUnit.MILLIS)
    public void updateSchedule() {
        this.updateReportButtonTime();
    }

    private void updateReportButtonTime() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        Widget reportButton = this.client.getWidget(WidgetInfo.CHATBOX_REPORT_TEXT);
        if (reportButton == null) {
            return;
        }
        switch (this.config.time()) {
            case UTC: {
                reportButton.setText(ReportButtonPlugin.getUTCTime());
                break;
            }
            case JAGEX: {
                reportButton.setText(ReportButtonPlugin.getJagexTime());
                break;
            }
            case LOCAL_TIME: {
                reportButton.setText(ReportButtonPlugin.getLocalTime());
                break;
            }
            case LOGIN_TIME: {
                reportButton.setText(this.getLoginTime());
                break;
            }
            case DATE: {
                reportButton.setText(ReportButtonPlugin.getDate());
                break;
            }
            case OFF: {
                reportButton.setText("Report");
            }
        }
    }

    private String getLoginTime() {
        if (this.loginTime == null) {
            return "Report";
        }
        Duration duration = Duration.between(this.loginTime, Instant.now());
        LocalTime time = LocalTime.ofSecondOfDay(duration.getSeconds());
        return time.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    private static String getLocalTime() {
        return LocalTime.now().format(DATE_TIME_FORMAT);
    }

    private static String getUTCTime() {
        LocalTime time = LocalTime.now(UTC);
        return time.format(DATE_TIME_FORMAT);
    }

    private static String getJagexTime() {
        LocalTime time = LocalTime.now(JAGEX);
        return time.format(DATE_TIME_FORMAT);
    }

    private static String getDate() {
        return DATE_FORMAT.format(new Date());
    }
}

