/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.raids.solver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.runelite.client.plugins.raids.RaidRoom;

public class RotationSolver {
    private static final Rotation[] ROTATIONS = new Rotation[]{new Rotation<RaidRoom.Boss>(Arrays.asList(RaidRoom.Boss.TEKTON, RaidRoom.Boss.VASA, RaidRoom.Boss.GUARDIANS, RaidRoom.Boss.MYSTICS, RaidRoom.Boss.SHAMANS, RaidRoom.Boss.MUTTADILES, RaidRoom.Boss.VANGUARDS, RaidRoom.Boss.VESPULA)), new Rotation<RaidRoom.Boss>(Arrays.asList(RaidRoom.Boss.TEKTON, RaidRoom.Boss.MUTTADILES, RaidRoom.Boss.GUARDIANS, RaidRoom.Boss.VESPULA, RaidRoom.Boss.SHAMANS, RaidRoom.Boss.VASA, RaidRoom.Boss.VANGUARDS, RaidRoom.Boss.MYSTICS)), new Rotation<RaidRoom.Boss>(Arrays.asList(RaidRoom.Boss.VESPULA, RaidRoom.Boss.VANGUARDS, RaidRoom.Boss.MUTTADILES, RaidRoom.Boss.SHAMANS, RaidRoom.Boss.MYSTICS, RaidRoom.Boss.GUARDIANS, RaidRoom.Boss.VASA, RaidRoom.Boss.TEKTON)), new Rotation<RaidRoom.Boss>(Arrays.asList(RaidRoom.Boss.MYSTICS, RaidRoom.Boss.VANGUARDS, RaidRoom.Boss.VASA, RaidRoom.Boss.SHAMANS, RaidRoom.Boss.VESPULA, RaidRoom.Boss.GUARDIANS, RaidRoom.Boss.MUTTADILES, RaidRoom.Boss.TEKTON))};

    public static boolean solve(RaidRoom[] rooms) {
        if (rooms == null) {
            return false;
        }
        Rotation match = null;
        Integer start = null;
        Integer index = null;
        int known = 0;
        for (int i = 0; i < rooms.length; ++i) {
            if (rooms[i] == null || rooms[i].getBoss() == null || rooms[i].getBoss() == RaidRoom.Boss.UNKNOWN) continue;
            if (start == null) {
                start = i;
            }
            ++known;
        }
        if (known < 2) {
            return false;
        }
        if (known == rooms.length) {
            return true;
        }
        block1: for (Rotation rotation : ROTATIONS) {
            for (int i = 0; i < rotation.size(); ++i) {
                if (rooms[start].getBoss() != rotation.get(i)) continue;
                for (int j = start + 1; j < rooms.length; ++j) {
                    if (rooms[j].getBoss() != null && rooms[j].getBoss() != RaidRoom.Boss.UNKNOWN && rooms[j].getBoss() != rotation.get(i + j - start)) continue block1;
                }
                if (match != null && match != rotation) {
                    return false;
                }
                index = i - start;
                match = rotation;
            }
        }
        if (match == null) {
            return false;
        }
        for (int i = 0; i < rooms.length; ++i) {
            if (rooms[i] == null || rooms[i].getBoss() != null && rooms[i].getBoss() != RaidRoom.Boss.UNKNOWN) continue;
            rooms[i].setBoss((RaidRoom.Boss)((Object)match.get(index + i)));
        }
        return true;
    }

    private static class Rotation<E>
    extends ArrayList<E> {
        Rotation(Collection<? extends E> bosses) {
            super(bosses);
        }

        @Override
        public E get(int index) {
            if (index < 0) {
                index += this.size();
            }
            return super.get(index % this.size());
        }
    }
}

