/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.raids;

import com.google.inject.Binder;
import com.google.inject.Provides;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InstanceTemplates;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.VarPlayer;
import net.runelite.api.Varbits;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.raids.Raid;
import net.runelite.client.plugins.raids.RaidRoom;
import net.runelite.client.plugins.raids.RaidsConfig;
import net.runelite.client.plugins.raids.RaidsOverlay;
import net.runelite.client.plugins.raids.RaidsTimer;
import net.runelite.client.plugins.raids.solver.Layout;
import net.runelite.client.plugins.raids.solver.LayoutSolver;
import net.runelite.client.plugins.raids.solver.RotationSolver;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chambers Of Xeric", description="Show helpful information for the Chambers of Xeric raid", tags={"combat", "raid", "overlay", "pve", "pvm", "bosses"})
public class RaidsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RaidsPlugin.class);
    private static final int LOBBY_PLANE = 3;
    private static final String RAID_START_MESSAGE = "The raid has begun!";
    private static final String LEVEL_COMPLETE_MESSAGE = "level complete!";
    private static final String RAID_COMPLETE_MESSAGE = "Congratulations - your raid is complete!";
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###.##");
    static final DecimalFormat POINTS_FORMAT = new DecimalFormat("#,###");
    private static final String SPLIT_REGEX = "\\s*,\\s*";
    private static final Pattern ROTATION_REGEX = Pattern.compile("\\[(.*?)]");
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private Client client;
    @Inject
    private RaidsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RaidsOverlay overlay;
    @Inject
    private LayoutSolver layoutSolver;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ClientThread clientThread;
    private final ArrayList<String> roomWhitelist = new ArrayList();
    private final ArrayList<String> roomBlacklist = new ArrayList();
    private final ArrayList<String> rotationWhitelist = new ArrayList();
    private final ArrayList<String> layoutWhitelist = new ArrayList();
    private Raid raid;
    private boolean inRaidChambers;
    private RaidsTimer timer;

    @Provides
    RaidsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(RaidsConfig.class);
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(RaidsOverlay.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.updateLists();
        this.clientThread.invokeLater(() -> this.checkRaidPresence(true));
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.infoBoxManager.removeInfoBox(this.timer);
        this.inRaidChambers = false;
        this.raid = null;
        this.timer = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("raids")) {
            return;
        }
        if (event.getKey().equals("raidsTimer")) {
            this.updateInfoBoxState();
            return;
        }
        this.updateLists();
        this.clientThread.invokeLater(() -> this.checkRaidPresence(true));
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.checkRaidPresence(false);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.inRaidChambers && event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION) {
            String message = Text.removeTags(event.getMessage());
            if (this.config.raidsTimer() && message.startsWith(RAID_START_MESSAGE)) {
                this.timer = new RaidsTimer(this.spriteManager.getSprite(1582, 0), this, Instant.now());
                this.infoBoxManager.addInfoBox(this.timer);
            }
            if (this.timer != null && message.contains(LEVEL_COMPLETE_MESSAGE)) {
                this.timer.timeFloor();
            }
            if (message.startsWith(RAID_COMPLETE_MESSAGE)) {
                if (this.timer != null) {
                    this.timer.timeOlm();
                    this.timer.setStopped(true);
                }
                if (this.config.pointsMessage()) {
                    int totalPoints = this.client.getVar(Varbits.TOTAL_POINTS);
                    int personalPoints = this.client.getVar(Varbits.PERSONAL_POINTS);
                    double percentage = (double)personalPoints / ((double)totalPoints / 100.0);
                    String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Total points: ").append(ChatColorType.HIGHLIGHT).append(POINTS_FORMAT.format(totalPoints)).append(ChatColorType.NORMAL).append(", Personal points: ").append(ChatColorType.HIGHLIGHT).append(POINTS_FORMAT.format(personalPoints)).append(ChatColorType.NORMAL).append(" (").append(ChatColorType.HIGHLIGHT).append(DECIMAL_FORMAT.format(percentage)).append(ChatColorType.NORMAL).append("%)").build();
                    this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(chatMessage).build());
                }
            }
        }
    }

    private void checkRaidPresence(boolean force) {
        boolean setting;
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        boolean bl = setting = this.client.getVar(Varbits.IN_RAID) == 1;
        if (force || this.inRaidChambers != setting) {
            this.inRaidChambers = setting;
            this.updateInfoBoxState();
            if (this.inRaidChambers) {
                this.raid = this.buildRaid();
                if (this.raid == null) {
                    log.debug("Failed to build raid");
                    return;
                }
                Layout layout = this.layoutSolver.findLayout(this.raid.toCode());
                if (layout == null) {
                    log.debug("Could not find layout match");
                    return;
                }
                this.raid.updateLayout(layout);
                RotationSolver.solve(this.raid.getCombatRooms());
                this.overlay.setScoutOverlayShown(true);
                this.sendRaidLayoutMessage();
            } else if (!this.config.scoutOverlayAtBank()) {
                this.overlay.setScoutOverlayShown(false);
            }
        }
        if (!(this.client.getVar(VarPlayer.IN_RAID_PARTY) != -1 || this.inRaidChambers && this.config.scoutOverlayInRaid())) {
            this.overlay.setScoutOverlayShown(false);
        }
    }

    private void sendRaidLayoutMessage() {
        if (!this.config.layoutMessage()) {
            return;
        }
        String layout = this.getRaid().getLayout().toCodeString();
        String rooms = this.getRaid().toRoomString();
        String raidData = "[" + layout + "]: " + rooms;
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Layout: ").append(ChatColorType.NORMAL).append(raidData).build()).build());
    }

    private void updateInfoBoxState() {
        if (this.timer == null) {
            return;
        }
        if (this.inRaidChambers && this.config.raidsTimer()) {
            if (!this.infoBoxManager.getInfoBoxes().contains(this.timer)) {
                this.infoBoxManager.addInfoBox(this.timer);
            }
        } else {
            this.infoBoxManager.removeInfoBox(this.timer);
        }
        if (!this.inRaidChambers) {
            this.timer = null;
        }
    }

    private void updateLists() {
        this.updateList(this.roomWhitelist, this.config.whitelistedRooms());
        this.updateList(this.roomBlacklist, this.config.blacklistedRooms());
        this.updateList(this.rotationWhitelist, this.config.whitelistedRotations());
        this.updateList(this.layoutWhitelist, this.config.whitelistedLayouts());
    }

    private void updateList(ArrayList<String> list, String input) {
        list.clear();
        if (list == this.rotationWhitelist) {
            Matcher m = ROTATION_REGEX.matcher(input);
            while (m.find()) {
                String rotation = m.group(1).toLowerCase();
                if (list.contains(rotation)) continue;
                list.add(rotation);
            }
        } else {
            list.addAll(Arrays.asList(input.toLowerCase().split(SPLIT_REGEX)));
        }
    }

    int getRotationMatches() {
        String rotation = this.raid.getRotationString().toLowerCase();
        String[] bosses = rotation.split(SPLIT_REGEX);
        if (this.rotationWhitelist.contains(rotation)) {
            return bosses.length;
        }
        for (String whitelisted : this.rotationWhitelist) {
            int matches = 0;
            String[] whitelistedBosses = whitelisted.split(SPLIT_REGEX);
            for (int i = 0; i < whitelistedBosses.length; ++i) {
                if (i < bosses.length && whitelistedBosses[i].equals(bosses[i])) {
                    ++matches;
                    continue;
                }
                matches = 0;
                break;
            }
            if (matches < 2) continue;
            return matches;
        }
        return 0;
    }

    private Point findLobbyBase() {
        Tile[][] tiles = this.client.getScene().getTiles()[3];
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                if (tiles[x][y] == null || tiles[x][y].getWallObject() == null || tiles[x][y].getWallObject().getId() != 12231) continue;
                return tiles[x][y].getSceneLocation();
            }
        }
        return null;
    }

    private Raid buildRaid() {
        Point gridBase = this.findLobbyBase();
        if (gridBase == null) {
            return null;
        }
        Raid raid = new Raid();
        int startX = -2;
        for (int plane = 3; plane > 1; --plane) {
            Tile[][] tiles = this.client.getScene().getTiles()[plane];
            int position = tiles[gridBase.getX() + 32][gridBase.getY()] == null ? 1 : 0;
            block1: for (int i = 1; i > -2; --i) {
                int y = gridBase.getY() + i * 32;
                for (int j = startX; j < 4; ++j) {
                    int x = gridBase.getX() + j * 32;
                    int offsetX = 0;
                    if (x > 104 && position > 1 && position < 4) {
                        ++position;
                    }
                    if (x < 0) {
                        offsetX = Math.abs(x) + 1;
                    }
                    if (x >= 104 || y < 0 || y >= 104) continue;
                    if (tiles[x + offsetX][y] == null) {
                        if (position != 4) continue;
                        ++position;
                        continue block1;
                    }
                    if (position == 0 && startX != j) {
                        startX = j;
                    }
                    Tile base = tiles[offsetX > 0 ? 1 : x][y];
                    RaidRoom room = this.determineRoom(base);
                    raid.setRoom(room, position + Math.abs((plane - 3) * 8));
                    ++position;
                }
            }
        }
        return raid;
    }

    private RaidRoom determineRoom(Tile base) {
        RaidRoom room = new RaidRoom(base, RaidRoom.Type.EMPTY);
        int chunkData = this.client.getInstanceTemplateChunks()[base.getPlane()][base.getSceneLocation().getX() / 8][base.getSceneLocation().getY() / 8];
        InstanceTemplates template = InstanceTemplates.findMatch(chunkData);
        if (template == null) {
            return room;
        }
        switch (template) {
            case RAIDS_LOBBY: 
            case RAIDS_START: {
                room.setType(RaidRoom.Type.START);
                break;
            }
            case RAIDS_END: {
                room.setType(RaidRoom.Type.END);
                break;
            }
            case RAIDS_SCAVENGERS: 
            case RAIDS_SCAVENGERS2: {
                room.setType(RaidRoom.Type.SCAVENGERS);
                break;
            }
            case RAIDS_SHAMANS: {
                room.setType(RaidRoom.Type.COMBAT);
                room.setBoss(RaidRoom.Boss.SHAMANS);
                break;
            }
            case RAIDS_VASA: {
                room.setType(RaidRoom.Type.COMBAT);
                room.setBoss(RaidRoom.Boss.VASA);
                break;
            }
            case RAIDS_VANGUARDS: {
                room.setType(RaidRoom.Type.COMBAT);
                room.setBoss(RaidRoom.Boss.VANGUARDS);
                break;
            }
            case RAIDS_ICE_DEMON: {
                room.setType(RaidRoom.Type.PUZZLE);
                room.setPuzzle(RaidRoom.Puzzle.ICE_DEMON);
                break;
            }
            case RAIDS_THIEVING: {
                room.setType(RaidRoom.Type.PUZZLE);
                room.setPuzzle(RaidRoom.Puzzle.THIEVING);
                break;
            }
            case RAIDS_FARMING: 
            case RAIDS_FARMING2: {
                room.setType(RaidRoom.Type.FARMING);
                break;
            }
            case RAIDS_MUTTADILES: {
                room.setType(RaidRoom.Type.COMBAT);
                room.setBoss(RaidRoom.Boss.MUTTADILES);
                break;
            }
            case RAIDS_MYSTICS: {
                room.setType(RaidRoom.Type.COMBAT);
                room.setBoss(RaidRoom.Boss.MYSTICS);
                break;
            }
            case RAIDS_TEKTON: {
                room.setType(RaidRoom.Type.COMBAT);
                room.setBoss(RaidRoom.Boss.TEKTON);
                break;
            }
            case RAIDS_TIGHTROPE: {
                room.setType(RaidRoom.Type.PUZZLE);
                room.setPuzzle(RaidRoom.Puzzle.TIGHTROPE);
                break;
            }
            case RAIDS_GUARDIANS: {
                room.setType(RaidRoom.Type.COMBAT);
                room.setBoss(RaidRoom.Boss.GUARDIANS);
                break;
            }
            case RAIDS_CRABS: {
                room.setType(RaidRoom.Type.PUZZLE);
                room.setPuzzle(RaidRoom.Puzzle.CRABS);
                break;
            }
            case RAIDS_VESPULA: {
                room.setType(RaidRoom.Type.COMBAT);
                room.setBoss(RaidRoom.Boss.VESPULA);
            }
        }
        return room;
    }

    public ArrayList<String> getRoomWhitelist() {
        return this.roomWhitelist;
    }

    public ArrayList<String> getRoomBlacklist() {
        return this.roomBlacklist;
    }

    public ArrayList<String> getRotationWhitelist() {
        return this.rotationWhitelist;
    }

    public ArrayList<String> getLayoutWhitelist() {
        return this.layoutWhitelist;
    }

    public Raid getRaid() {
        return this.raid;
    }

    public boolean isInRaidChambers() {
        return this.inRaidChambers;
    }
}

