/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.raids;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.raids.RaidRoom;
import net.runelite.client.plugins.raids.RaidsConfig;
import net.runelite.client.plugins.raids.RaidsPlugin;
import net.runelite.client.plugins.raids.solver.Room;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class RaidsOverlay
extends Overlay {
    private static final int OLM_PLANE = 0;
    private Client client;
    private RaidsPlugin plugin;
    private RaidsConfig config;
    private final PanelComponent panelComponent = new PanelComponent();
    private boolean scoutOverlayShown = false;

    @Inject
    private RaidsOverlay(Client client2, RaidsPlugin plugin, RaidsConfig config) {
        super(plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.client = client2;
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Raids overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.config.scoutOverlay() || !this.scoutOverlayShown || this.plugin.isInRaidChambers() && this.client.getPlane() == 0) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        if (this.plugin.getRaid() == null || this.plugin.getRaid().getLayout() == null) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Unable to scout this raid!").color(Color.RED).build());
            return this.panelComponent.render(graphics);
        }
        Color color = Color.WHITE;
        String layout = this.plugin.getRaid().getLayout().toCodeString();
        if (this.config.enableLayoutWhitelist() && !this.plugin.getLayoutWhitelist().contains(layout.toLowerCase())) {
            color = Color.RED;
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text(layout).color(color).build());
        int bossMatches = 0;
        int bossCount = 0;
        if (this.config.enableRotationWhitelist()) {
            bossMatches = this.plugin.getRotationMatches();
        }
        for (Room layoutRoom : this.plugin.getRaid().getLayout().getRooms()) {
            int position = layoutRoom.getPosition();
            RaidRoom room = this.plugin.getRaid().getRoom(position);
            if (room == null) continue;
            color = Color.WHITE;
            switch (room.getType()) {
                case COMBAT: {
                    ++bossCount;
                    if (this.plugin.getRoomWhitelist().contains(room.getBoss().getName().toLowerCase())) {
                        color = Color.GREEN;
                    } else if (this.plugin.getRoomBlacklist().contains(room.getBoss().getName().toLowerCase()) || this.config.enableRotationWhitelist() && bossCount > bossMatches) {
                        color = Color.RED;
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().left(room.getType().getName()).right(room.getBoss().getName()).rightColor(color).build());
                    break;
                }
                case PUZZLE: {
                    if (this.plugin.getRoomWhitelist().contains(room.getPuzzle().getName().toLowerCase())) {
                        color = Color.GREEN;
                    } else if (this.plugin.getRoomBlacklist().contains(room.getPuzzle().getName().toLowerCase())) {
                        color = Color.RED;
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().left(room.getType().getName()).right(room.getPuzzle().getName()).rightColor(color).build());
                }
            }
        }
        return this.panelComponent.render(graphics);
    }

    public void setScoutOverlayShown(boolean scoutOverlayShown) {
        this.scoutOverlayShown = scoutOverlayShown;
    }
}

