/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.raids;

import net.runelite.api.Tile;

public class RaidRoom {
    public static final int ROOM_MAX_SIZE = 32;
    private final Tile base;
    private Type type;
    private Boss boss;
    private Puzzle puzzle;
    private RaidRoom previousRoom;
    private RaidRoom nextRoom;

    public RaidRoom(Tile base, Type type) {
        this.base = base;
        this.type = type;
    }

    public String toString() {
        switch (this.type) {
            case COMBAT: {
                return "RaidRoom (type: " + this.type.getName() + ", " + this.boss.getName() + ")";
            }
            case PUZZLE: {
                return "RaidRoom (type: " + this.type.getName() + ", " + this.puzzle.getName() + ")";
            }
        }
        return "RaidRoom (type: " + this.type.getName() + ")";
    }

    public Tile getBase() {
        return this.base;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Boss getBoss() {
        return this.boss;
    }

    public void setBoss(Boss boss) {
        this.boss = boss;
    }

    public Puzzle getPuzzle() {
        return this.puzzle;
    }

    public void setPuzzle(Puzzle puzzle) {
        this.puzzle = puzzle;
    }

    public RaidRoom getPreviousRoom() {
        return this.previousRoom;
    }

    public void setPreviousRoom(RaidRoom previousRoom) {
        this.previousRoom = previousRoom;
    }

    public RaidRoom getNextRoom() {
        return this.nextRoom;
    }

    public void setNextRoom(RaidRoom nextRoom) {
        this.nextRoom = nextRoom;
    }

    public static enum Puzzle {
        CRABS("Crabs"),
        ICE_DEMON("Ice Demon"),
        TIGHTROPE("Tightrope"),
        THIEVING("Thieving"),
        UNKNOWN("Unknown");

        private final String name;

        public static Puzzle fromString(String name) {
            for (Puzzle puzzle : Puzzle.values()) {
                if (!puzzle.getName().equalsIgnoreCase(name)) continue;
                return puzzle;
            }
            return null;
        }

        private Puzzle(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Boss {
        TEKTON("Tekton"),
        MUTTADILES("Muttadiles"),
        GUARDIANS("Guardians"),
        VESPULA("Vespula"),
        SHAMANS("Shamans"),
        VASA("Vasa"),
        VANGUARDS("Vanguards"),
        MYSTICS("Mystics"),
        UNKNOWN("Unknown");

        private final String name;

        public static Boss fromString(String name) {
            for (Boss boss : Boss.values()) {
                if (!boss.getName().equalsIgnoreCase(name)) continue;
                return boss;
            }
            return null;
        }

        private Boss(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Type {
        START("Start", "#"),
        END("End", "\u00a4"),
        SCAVENGERS("Scavengers", "S"),
        FARMING("Farming", "F"),
        COMBAT("Combat", "C"),
        PUZZLE("Puzzle", "P"),
        EMPTY("Empty", " ");

        private final String name;
        private final String code;

        public static Type fromCode(char code) {
            for (Type type : Type.values()) {
                if (!type.getCode().equalsIgnoreCase(String.valueOf(code))) continue;
                return type;
            }
            return EMPTY;
        }

        private Type(String name, String code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }
    }
}

