/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.raids;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import net.runelite.client.plugins.raids.RaidRoom;
import net.runelite.client.plugins.raids.solver.Layout;
import net.runelite.client.plugins.raids.solver.Room;

public class Raid {
    private final RaidRoom[] rooms = new RaidRoom[16];
    private Layout layout;

    public void updateLayout(Layout layout) {
        if (layout == null) {
            return;
        }
        this.layout = layout;
        for (int i = 0; i < this.rooms.length; ++i) {
            RaidRoom room;
            if (layout.getRoomAt(i) == null || (room = this.rooms[i]) != null) continue;
            RaidRoom.Type type = RaidRoom.Type.fromCode(layout.getRoomAt(i).getSymbol());
            room = new RaidRoom(null, type);
            if (type == RaidRoom.Type.COMBAT) {
                room.setBoss(RaidRoom.Boss.UNKNOWN);
            }
            if (type == RaidRoom.Type.PUZZLE) {
                room.setPuzzle(RaidRoom.Puzzle.UNKNOWN);
            }
            this.setRoom(room, i);
        }
    }

    public RaidRoom getRoom(int position) {
        return this.rooms[position];
    }

    public void setRoom(RaidRoom room, int position) {
        if (position < this.rooms.length) {
            this.rooms[position] = room;
        }
    }

    public RaidRoom[] getCombatRooms() {
        ArrayList<RaidRoom> combatRooms = new ArrayList<RaidRoom>();
        for (Room room : this.layout.getRooms()) {
            if (room == null || this.rooms[room.getPosition()].getType() != RaidRoom.Type.COMBAT) continue;
            combatRooms.add(this.rooms[room.getPosition()]);
        }
        return combatRooms.toArray(new RaidRoom[combatRooms.size()]);
    }

    public String getRotationString() {
        return Joiner.on(",").join(Arrays.stream(this.getCombatRooms()).map(r -> r.getBoss().getName()).toArray());
    }

    public String toCode() {
        StringBuilder builder = new StringBuilder();
        for (RaidRoom room : this.rooms) {
            if (room != null) {
                builder.append(room.getType().getCode());
                continue;
            }
            builder.append(" ");
        }
        return builder.toString();
    }

    public String toRoomString() {
        StringBuilder sb = new StringBuilder();
        for (Room r : this.getLayout().getRooms()) {
            int position = r.getPosition();
            RaidRoom room = this.getRoom(position);
            if (room == null || room.getType() != RaidRoom.Type.COMBAT && room.getType() != RaidRoom.Type.PUZZLE) continue;
            switch (room.getType()) {
                case PUZZLE: {
                    RaidRoom.Puzzle puzzle = room.getPuzzle();
                    sb.append(puzzle.getName());
                    if (puzzle == RaidRoom.Puzzle.UNKNOWN) {
                        sb.append(" (puzzle)");
                    }
                    sb.append(", ");
                    break;
                }
                case COMBAT: {
                    RaidRoom.Boss boss = room.getBoss();
                    sb.append(boss.getName());
                    if (boss == RaidRoom.Boss.UNKNOWN) {
                        sb.append(" (combat)");
                    }
                    sb.append(", ");
                }
            }
        }
        String roomsString = sb.toString();
        return roomsString.substring(0, roomsString.length() - 2);
    }

    public RaidRoom[] getRooms() {
        return this.rooms;
    }

    public Layout getLayout() {
        return this.layout;
    }
}

