/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.questlist;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.VarClientInt;
import net.runelite.api.Varbits;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.game.chatbox.ChatboxTextInput;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Quest List", description="Adds searching and filtering to the quest list")
public class QuestListPlugin
extends Plugin {
    private static final int ENTRY_PADDING = 8;
    private static final List<String> QUEST_HEADERS = ImmutableList.of("Free Quests", "Members' Quests", "Miniquests");
    private static final String MENU_OPEN = "Open";
    private static final String MENU_CLOSE = "Close";
    private static final String MENU_TOGGLE = "Toggle";
    private static final String MENU_SEARCH = "Search";
    private static final String MENU_SHOW = "Show";
    @Inject
    private Client client;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private ClientThread clientThread;
    private ChatboxTextInput searchInput;
    private Widget questSearchButton;
    private Widget questHideButton;
    private EnumMap<QuestContainer, Collection<QuestWidget>> questSet;
    private QuestState currentFilterState;

    @Subscribe
    public void onGameStateChanged(GameStateChanged e) {
        if (e.getGameState() == GameState.LOGGING_IN) {
            this.currentFilterState = QuestState.ALL;
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!event.getEventName().equals("questProgressUpdated")) {
            return;
        }
        Widget header = this.client.getWidget(WidgetInfo.QUESTLIST_BOX);
        if (header != null) {
            this.questSearchButton = header.createChild(-1, 5);
            this.questSearchButton.setSpriteId(1113);
            this.questSearchButton.setOriginalWidth(18);
            this.questSearchButton.setOriginalHeight(17);
            this.questSearchButton.setXPositionMode(2);
            this.questSearchButton.setOriginalX(5);
            this.questSearchButton.setOriginalY(0);
            this.questSearchButton.setHasListener(true);
            this.questSearchButton.setAction(1, MENU_OPEN);
            this.questSearchButton.setOnOpListener(e -> this.openSearch());
            this.questSearchButton.setName(MENU_SEARCH);
            this.questSearchButton.revalidate();
            this.questHideButton = header.createChild(-1, 5);
            this.redrawHideButton();
            this.questHideButton.setOriginalWidth(13);
            this.questHideButton.setOriginalHeight(13);
            this.questHideButton.setXPositionMode(2);
            this.questHideButton.setOriginalX(24);
            this.questHideButton.setOriginalY(2);
            this.questHideButton.setHasListener(true);
            this.questHideButton.setOnOpListener(e -> this.toggleHidden());
            this.questHideButton.setAction(1, MENU_TOGGLE);
            this.questHideButton.revalidate();
            this.questSet = new EnumMap(QuestContainer.class);
            this.updateFilter();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (this.isChatboxOpen() && !this.isOnQuestTab()) {
            this.chatboxPanelManager.close();
        }
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged varClientIntChanged) {
        if (varClientIntChanged.getIndex() == VarClientInt.INVENTORY_TAB.getIndex() && this.isChatboxOpen() && !this.isOnQuestTab()) {
            this.chatboxPanelManager.close();
        }
    }

    private void toggleHidden() {
        QuestState[] questStates = QuestState.values();
        int nextState = (this.currentFilterState.ordinal() + 1) % questStates.length;
        this.currentFilterState = questStates[nextState];
        this.redrawHideButton();
        this.updateFilter();
        this.client.playSoundEffect(2266);
    }

    private void redrawHideButton() {
        this.questHideButton.setSpriteId(this.currentFilterState.getSpriteId());
        this.questHideButton.setName("Show " + this.currentFilterState.getName());
    }

    private boolean isOnQuestTab() {
        return this.client.getVar(Varbits.QUEST_TAB) == 0 && this.client.getVar(VarClientInt.INVENTORY_TAB) == 2;
    }

    private boolean isChatboxOpen() {
        return this.searchInput != null && this.chatboxPanelManager.getCurrentInput() == this.searchInput;
    }

    private void closeSearch() {
        this.updateFilter("");
        this.chatboxPanelManager.close();
        this.client.playSoundEffect(2266);
    }

    private void openSearch() {
        this.updateFilter("");
        this.client.playSoundEffect(2266);
        this.questSearchButton.setAction(1, MENU_CLOSE);
        this.questSearchButton.setOnOpListener(e -> this.closeSearch());
        this.searchInput = this.chatboxPanelManager.openTextInput("Search quest list").onChanged(s -> this.clientThread.invokeLater(() -> this.updateFilter((String)s))).onClose(() -> {
            this.clientThread.invokeLater(() -> this.updateFilter(""));
            this.questSearchButton.setOnOpListener(e -> this.openSearch());
            this.questSearchButton.setAction(1, MENU_OPEN);
        }).build();
    }

    private void updateFilter() {
        String filter = "";
        if (this.isChatboxOpen()) {
            filter = this.searchInput.getValue();
        }
        this.updateFilter(filter);
    }

    private void updateFilter(String filter) {
        filter = filter.toLowerCase();
        Widget container = this.client.getWidget(WidgetInfo.QUESTLIST_CONTAINER);
        Widget freeList = this.client.getWidget(QuestContainer.FREE_QUESTS.widgetInfo);
        Widget memberList = this.client.getWidget(QuestContainer.MEMBER_QUESTS.widgetInfo);
        Widget miniList = this.client.getWidget(QuestContainer.MINI_QUESTS.widgetInfo);
        if (container == null || freeList == null || memberList == null || miniList == null) {
            return;
        }
        this.updateList(QuestContainer.FREE_QUESTS, filter);
        this.updateList(QuestContainer.MEMBER_QUESTS, filter);
        this.updateList(QuestContainer.MINI_QUESTS, filter);
        memberList.setOriginalY(freeList.getOriginalY() + freeList.getOriginalHeight() + 8);
        miniList.setOriginalY(memberList.getOriginalY() + memberList.getOriginalHeight() + 8);
        freeList.revalidate();
        memberList.revalidate();
        miniList.revalidate();
        int y = miniList.getRelativeY() + miniList.getHeight() + 10;
        int newHeight = container.getScrollHeight() > 0 ? container.getScrollY() * y / container.getScrollHeight() : 0;
        container.setScrollHeight(y);
        container.revalidateScroll();
        this.clientThread.invokeLater(() -> this.client.runScript(72, WidgetInfo.QUESTLIST_SCROLLBAR.getId(), WidgetInfo.QUESTLIST_CONTAINER.getId(), newHeight));
    }

    private void updateList(QuestContainer questContainer, String filter) {
        Widget list = this.client.getWidget(questContainer.widgetInfo);
        if (list == null) {
            return;
        }
        Collection quests = this.questSet.get((Object)questContainer);
        if (quests != null && quests.stream().noneMatch(w -> {
            Widget codeWidget = w.getQuest();
            if (codeWidget == null) {
                return false;
            }
            return list.getChild(codeWidget.getIndex()) == codeWidget;
        })) {
            quests = null;
        }
        if (quests == null) {
            quests = Arrays.stream(list.getDynamicChildren()).sorted(Comparator.comparing(Widget::getRelativeY)).filter(w -> !QUEST_HEADERS.contains(w.getText())).map(w -> new QuestWidget((Widget)w, Text.removeTags(w.getText()).toLowerCase())).collect(Collectors.toList());
            this.questSet.put(questContainer, quests);
        }
        int y = 20;
        for (QuestWidget questInfo : quests) {
            Widget quest = questInfo.getQuest();
            QuestState questState = QuestState.getByColor(quest.getTextColor());
            boolean hidden = !filter.isEmpty() ? !questInfo.getTitle().contains(filter) : this.currentFilterState != QuestState.ALL && questState != this.currentFilterState;
            quest.setHidden(hidden);
            quest.setOriginalY(y);
            quest.revalidate();
            if (hidden) continue;
            y += quest.getHeight();
        }
        list.setOriginalHeight(y);
    }

    private static class QuestWidget {
        private Widget quest;
        private String title;

        public Widget getQuest() {
            return this.quest;
        }

        public String getTitle() {
            return this.title;
        }

        public void setQuest(Widget quest) {
            this.quest = quest;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QuestWidget)) {
                return false;
            }
            QuestWidget other = (QuestWidget)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Widget this$quest = this.getQuest();
            Widget other$quest = other.getQuest();
            if (this$quest == null ? other$quest != null : !this$quest.equals(other$quest)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QuestWidget;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Widget $quest = this.getQuest();
            result = result * 59 + ($quest == null ? 43 : $quest.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }

        public String toString() {
            return "QuestListPlugin.QuestWidget(quest=" + this.getQuest() + ", title=" + this.getTitle() + ")";
        }

        public QuestWidget(Widget quest, String title) {
            this.quest = quest;
            this.title = title;
        }
    }

    private static enum QuestState {
        NOT_STARTED(0xFF0000, "Not started", 1060),
        IN_PROGRESS(0xFFFF00, "In progress", 1062),
        COMPLETE(901389, "Completed", 1061),
        ALL(0, "All", 1063);

        private final int color;
        private final String name;
        private final int spriteId;

        static QuestState getByColor(int color) {
            for (QuestState value : QuestState.values()) {
                if (value.getColor() != color) continue;
                return value;
            }
            return null;
        }

        private QuestState(int color, String name, int spriteId) {
            this.color = color;
            this.name = name;
            this.spriteId = spriteId;
        }

        public int getColor() {
            return this.color;
        }

        public String getName() {
            return this.name;
        }

        public int getSpriteId() {
            return this.spriteId;
        }
    }

    private static enum QuestContainer {
        FREE_QUESTS(WidgetInfo.QUESTLIST_FREE_CONTAINER),
        MEMBER_QUESTS(WidgetInfo.QUESTLIST_MEMBERS_CONTAINER),
        MINI_QUESTS(WidgetInfo.QUESTLIST_MINIQUEST_CONTAINER);

        private final WidgetInfo widgetInfo;

        private QuestContainer(WidgetInfo widgetInfo) {
            this.widgetInfo = widgetInfo;
        }

        public WidgetInfo getWidgetInfo() {
            return this.widgetInfo;
        }
    }
}

