/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.profiles;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ConfigChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.profiles.ProfilesConfig;
import net.runelite.client.plugins.profiles.ProfilesPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Account Switcher", description="Allow for a allows you to easily switch between multiple OSRS Accounts", tags={"profile", "account", "login", "log in", "pklite"})
public class ProfilesPlugin
extends Plugin {
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    private ProfilesConfig config;
    private ProfilesPanel panel;
    private NavigationButton navButton;

    @Provides
    ProfilesConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(ProfilesConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.panel = this.injector.getInstance(ProfilesPanel.class);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), "profiles_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Profiles").icon(icon).priority(8).panel(this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Override
    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) throws Exception {
        if (event.getGroup().equals("profiles") && event.getKey().equals("rememberPassword")) {
            this.panel = this.injector.getInstance(ProfilesPanel.class);
            this.shutDown();
            this.startUp();
        }
    }
}

