/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.profiles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.plugins.profiles.ProfilePanel;
import net.runelite.client.plugins.profiles.ProfilesConfig;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProfilesPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ProfilesPanel.class);
    private static final int iterations = 100000;
    private static final String UNLOCK_PASSWORD = "Encryption Password";
    private static final String LOAD_ACCOUNTS = "Load Accounts";
    private static final String ACCOUNT_USERNAME = "Account Username";
    private static final String ACCOUNT_LABEL = "Account Label";
    private static final String PASSWORD_LABEL = "Account Password";
    private static final String HELP = "To add and load accounts, first enter a password into the Encryption Password field then press Load Accounts. You can now add as many accounts as you would like. The next time you restart Zenyte, enter your encryption password and click load accounts to see the accounts you entered";
    private static final Dimension PREFERRED_SIZE = new Dimension(205, 30);
    private static final Dimension HELP_PREFERRED_SIZE = new Dimension(205, 130);
    private static final Dimension MINIMUM_SIZE = new Dimension(0, 30);
    private final Client client;
    private static ProfilesConfig profilesConfig;
    private final JPasswordField txtDecryptPassword = new JPasswordField("Encryption Password");
    private final JButton btnLoadAccounts = new JButton("Load Accounts");
    private final JTextField txtAccountLabel = new JTextField("Account Label");
    private final JPasswordField txtAccountLogin = new JPasswordField("Account Username");
    private final JPasswordField txtPasswordLogin = new JPasswordField("Account Password");
    private final JPanel profilesPanel = new JPanel();
    private final JPanel helpPanel = new JPanel(new BorderLayout());
    private GridBagConstraints c;

    @Inject
    public ProfilesPanel(Client client2, final ProfilesConfig config) {
        this.client = client2;
        profilesConfig = config;
        this.setBorder(new EmptyBorder(18, 10, 0, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(0, 0, 4, 0);
        this.helpPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JLabel helpLabel = new JLabel("<html> <p>To add and load accounts, first enter a password into the Encryption Password field then press Load Accounts. You can now add as many accounts as you would like. The next time you restart Zenyte, enter your encryption password and click load accounts to see the accounts you entered</p></html>");
        helpLabel.setFont(FontManager.getRunescapeSmallFont());
        this.helpPanel.setPreferredSize(HELP_PREFERRED_SIZE);
        this.helpPanel.add((Component)helpLabel, "North");
        this.add(this.helpPanel);
        this.c.gridy += 3;
        ++this.c.gridy;
        this.txtDecryptPassword.setEchoChar('\u0000');
        this.txtDecryptPassword.setPreferredSize(PREFERRED_SIZE);
        this.txtDecryptPassword.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        this.txtDecryptPassword.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.txtDecryptPassword.setMinimumSize(MINIMUM_SIZE);
        this.txtDecryptPassword.setToolTipText(UNLOCK_PASSWORD);
        this.txtDecryptPassword.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ProfilesPanel.this.txtDecryptPassword.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                if (String.valueOf(ProfilesPanel.this.txtDecryptPassword.getPassword()).equals(ProfilesPanel.UNLOCK_PASSWORD)) {
                    ProfilesPanel.this.txtDecryptPassword.setText("");
                    ProfilesPanel.this.txtDecryptPassword.setEchoChar('*');
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ProfilesPanel.this.txtDecryptPassword.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
                if (ProfilesPanel.this.txtDecryptPassword.getPassword().length == 0) {
                    ProfilesPanel.this.txtDecryptPassword.setText(ProfilesPanel.UNLOCK_PASSWORD);
                    ProfilesPanel.this.txtDecryptPassword.setEchoChar('\u0000');
                }
            }
        });
        this.add((Component)this.txtDecryptPassword, this.c);
        ++this.c.gridy;
        this.btnLoadAccounts.setPreferredSize(PREFERRED_SIZE);
        this.btnLoadAccounts.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.btnLoadAccounts.setMinimumSize(MINIMUM_SIZE);
        this.btnLoadAccounts.setToolTipText(LOAD_ACCOUNTS);
        this.btnLoadAccounts.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                try {
                    ProfilesPanel.this.redrawProfiles();
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
                    ProfilesPanel.showErrorMessage("Unable to load data", "Incorrect password!");
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.add((Component)this.btnLoadAccounts, this.c);
        ++this.c.gridy;
        this.txtAccountLabel.setPreferredSize(PREFERRED_SIZE);
        this.txtAccountLabel.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        this.txtAccountLabel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.txtAccountLabel.setMinimumSize(MINIMUM_SIZE);
        this.txtAccountLabel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ProfilesPanel.this.txtAccountLabel.getText().equals(ProfilesPanel.ACCOUNT_LABEL)) {
                    ProfilesPanel.this.txtAccountLabel.setText("");
                    ProfilesPanel.this.txtAccountLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ProfilesPanel.this.txtAccountLabel.getText().isEmpty()) {
                    ProfilesPanel.this.txtAccountLabel.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
                    ProfilesPanel.this.txtAccountLabel.setText(ProfilesPanel.ACCOUNT_LABEL);
                }
            }
        });
        this.add((Component)this.txtAccountLabel, this.c);
        ++this.c.gridy;
        this.txtAccountLogin.setEchoChar('\u0000');
        this.txtAccountLogin.setPreferredSize(PREFERRED_SIZE);
        this.txtAccountLogin.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        this.txtAccountLogin.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.txtAccountLogin.setMinimumSize(MINIMUM_SIZE);
        this.txtAccountLogin.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ProfilesPanel.ACCOUNT_USERNAME.equals(String.valueOf(ProfilesPanel.this.txtAccountLogin.getPassword()))) {
                    ProfilesPanel.this.txtAccountLogin.setText("");
                    if (config.isStreamerMode()) {
                        ProfilesPanel.this.txtAccountLogin.setEchoChar('*');
                    }
                    ProfilesPanel.this.txtAccountLogin.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ProfilesPanel.this.txtAccountLogin.getPassword().length == 0) {
                    ProfilesPanel.this.txtAccountLogin.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
                    ProfilesPanel.this.txtAccountLogin.setText(ProfilesPanel.ACCOUNT_USERNAME);
                    ProfilesPanel.this.txtAccountLogin.setEchoChar('\u0000');
                }
            }
        });
        this.add((Component)this.txtAccountLogin, this.c);
        ++this.c.gridy;
        this.txtPasswordLogin.setEchoChar('\u0000');
        this.txtPasswordLogin.setPreferredSize(PREFERRED_SIZE);
        this.txtPasswordLogin.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        this.txtPasswordLogin.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.txtPasswordLogin.setToolTipText(PASSWORD_LABEL);
        this.txtPasswordLogin.setMinimumSize(MINIMUM_SIZE);
        this.txtPasswordLogin.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ProfilesPanel.PASSWORD_LABEL.equals(String.valueOf(ProfilesPanel.this.txtPasswordLogin.getPassword()))) {
                    ProfilesPanel.this.txtPasswordLogin.setText("");
                    ProfilesPanel.this.txtPasswordLogin.setEchoChar('*');
                    ProfilesPanel.this.txtPasswordLogin.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ProfilesPanel.this.txtPasswordLogin.getPassword().length == 0) {
                    ProfilesPanel.this.txtPasswordLogin.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
                    ProfilesPanel.this.txtPasswordLogin.setText(ProfilesPanel.PASSWORD_LABEL);
                    ProfilesPanel.this.txtPasswordLogin.setEchoChar('\u0000');
                }
            }
        });
        if (config.rememberPassword()) {
            this.add((Component)this.txtPasswordLogin, this.c);
            ++this.c.gridy;
        }
        this.c.insets = new Insets(0, 0, 15, 0);
        final JButton btnAddAccount = new JButton("Add Account");
        btnAddAccount.setPreferredSize(PREFERRED_SIZE);
        btnAddAccount.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        btnAddAccount.setMinimumSize(MINIMUM_SIZE);
        btnAddAccount.addActionListener(e -> {
            String labelText = String.valueOf(this.txtAccountLabel.getText());
            String loginText = String.valueOf(this.txtAccountLogin.getPassword());
            String passwordText = String.valueOf(this.txtPasswordLogin.getPassword());
            if (labelText.equals(ACCOUNT_LABEL) || loginText.equals(ACCOUNT_USERNAME)) {
                return;
            }
            String data = config.rememberPassword() && this.txtPasswordLogin.getPassword() != null ? labelText + ":" + loginText + ":" + passwordText : labelText + ":" + loginText;
            try {
                if (!this.addProfile(data)) {
                    return;
                }
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
                ex.printStackTrace();
            }
            this.addAccount(data);
            this.txtAccountLabel.setText(ACCOUNT_LABEL);
            this.txtAccountLabel.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
            this.txtAccountLogin.setText(ACCOUNT_USERNAME);
            this.txtAccountLogin.setEchoChar('\u0000');
            this.txtAccountLogin.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
            this.txtPasswordLogin.setText(PASSWORD_LABEL);
            this.txtPasswordLogin.setEchoChar('\u0000');
            this.txtPasswordLogin.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        });
        this.txtAccountLogin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    btnAddAccount.doClick();
                    btnAddAccount.requestFocus();
                }
            }
        });
        this.txtAccountLogin.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.add((Component)btnAddAccount, this.c);
        ++this.c.gridy;
        this.profilesPanel.setLayout(new GridBagLayout());
        this.add((Component)this.profilesPanel, this.c);
        this.c.gridy = 0;
        this.c.insets = new Insets(0, 0, 5, 0);
    }

    void redrawProfiles() throws InvalidKeySpecException, NoSuchAlgorithmException {
        this.profilesPanel.removeAll();
        this.c.gridy = 0;
        this.addAccounts(this.getProfileData());
        this.revalidate();
        this.repaint();
    }

    private void addAccount(String data) {
        ProfilePanel profile = new ProfilePanel(this.client, data, profilesConfig, this);
        ++this.c.gridy;
        this.profilesPanel.add((Component)profile, this.c);
        this.revalidate();
        this.repaint();
    }

    void addAccounts(String data) {
        if (!(data = data.trim()).contains(":")) {
            return;
        }
        Arrays.stream(data.split("\\n")).forEach(this::addAccount);
    }

    boolean addProfile(String data) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return this.setProfileData(this.getProfileData() + data + "\n");
    }

    void removeProfile(String data) throws InvalidKeySpecException, NoSuchAlgorithmException {
        this.setProfileData(this.getProfileData().replaceAll(data + "\\n", ""));
        this.revalidate();
        this.repaint();
    }

    void setSalt(byte[] bytes) {
        profilesConfig.salt(this.base64Encode(bytes));
    }

    byte[] getSalt() {
        if (profilesConfig.salt().length() == 0) {
            return new byte[0];
        }
        return this.base64Decode(profilesConfig.salt());
    }

    SecretKey getAesKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.getSalt().length == 0) {
            byte[] b = new byte[16];
            SecureRandom.getInstanceStrong().nextBytes(b);
            this.setSalt(b);
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(this.txtDecryptPassword.getPassword(), this.getSalt(), 100000, 128);
        SecretKey key = factory.generateSecret(spec);
        return key;
    }

    String getProfileData() throws InvalidKeySpecException, NoSuchAlgorithmException {
        String tmp = profilesConfig.profilesData();
        if (tmp.startsWith("\u00ac")) {
            if (this.txtDecryptPassword.getPassword().length == 0 || String.valueOf(this.txtDecryptPassword.getPassword()).equals(UNLOCK_PASSWORD)) {
                ProfilesPanel.showErrorMessage("Unable to load data", "Please enter a password!");
                return tmp;
            }
            tmp = tmp.substring(1);
            return ProfilesPanel.decryptText(this.base64Decode(tmp), this.getAesKey());
        }
        return tmp;
    }

    boolean setProfileData(String data) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (this.txtDecryptPassword.getPassword().length == 0 || String.valueOf(this.txtDecryptPassword.getPassword()).equals(UNLOCK_PASSWORD)) {
            ProfilesPanel.showErrorMessage("Unable to save data", "Please enter a password!");
            return false;
        }
        byte[] enc = ProfilesPanel.encryptText(data, this.getAesKey());
        if (enc.length == 0) {
            return false;
        }
        String s = "\u00ac" + this.base64Encode(enc);
        profilesConfig.profilesData(s);
        return true;
    }

    public byte[] base64Decode(String data) {
        return Base64.getDecoder().decode(data);
    }

    public String base64Encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] encryptText(String text, SecretKey aesKey) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            SecretKeySpec newKey = new SecretKeySpec(aesKey.getEncoded(), "AES");
            cipher.init(1, newKey);
            return cipher.doFinal(text.getBytes());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static String decryptText(byte[] enc, SecretKey aesKey) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            SecretKeySpec newKey = new SecretKeySpec(aesKey.getEncoded(), "AES");
            cipher.init(2, newKey);
            return new String(cipher.doFinal(enc));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void showErrorMessage(String title, String text) {
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, text, title, 0));
    }
}

