/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.prayer;

import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Prayer;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.prayer.PrayerBarOverlay;
import net.runelite.client.plugins.prayer.PrayerConfig;
import net.runelite.client.plugins.prayer.PrayerCounter;
import net.runelite.client.plugins.prayer.PrayerDoseOverlay;
import net.runelite.client.plugins.prayer.PrayerFlickLocation;
import net.runelite.client.plugins.prayer.PrayerFlickOverlay;
import net.runelite.client.plugins.prayer.PrayerItems;
import net.runelite.client.plugins.prayer.PrayerRestoreType;
import net.runelite.client.plugins.prayer.PrayerType;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;

@PluginDescriptor(name="Prayer", description="Show various information related to prayer", tags={"combat", "flicking", "overlay"})
public class PrayerPlugin
extends Plugin {
    private final PrayerCounter[] prayerCounter = new PrayerCounter[PrayerType.values().length];
    private Instant startOfLastTick = Instant.now();
    private boolean prayersActive = false;
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PrayerFlickOverlay flickOverlay;
    @Inject
    private PrayerDoseOverlay doseOverlay;
    @Inject
    private PrayerBarOverlay barOverlay;
    @Inject
    private PrayerConfig config;

    @Provides
    PrayerConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(PrayerConfig.class);
    }

    @Override
    protected void startUp() {
        this.overlayManager.add(this.flickOverlay);
        this.overlayManager.add(this.doseOverlay);
        this.overlayManager.add(this.barOverlay);
    }

    @Override
    protected void shutDown() {
        this.overlayManager.remove(this.flickOverlay);
        this.overlayManager.remove(this.doseOverlay);
        this.overlayManager.remove(this.barOverlay);
        this.removeIndicators();
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("prayer")) {
            if (!this.config.prayerIndicator()) {
                this.removeIndicators();
            } else if (!this.config.prayerIndicatorOverheads()) {
                this.removeOverheadsIndicators();
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer container = event.getItemContainer();
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (container == inventory || container == equipment) {
            this.doseOverlay.setHasHolyWrench(false);
            this.doseOverlay.setHasPrayerRestore(false);
            this.doseOverlay.setBonusPrayer(0);
            if (inventory != null) {
                this.checkContainerForPrayer(inventory.getItems());
            }
            if (equipment != null) {
                this.doseOverlay.setPrayerBonus(this.checkContainerForPrayer(equipment.getItems()));
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.prayersActive = this.isAnyPrayerActive();
        if (!this.config.prayerFlickLocation().equals((Object)PrayerFlickLocation.NONE)) {
            this.startOfLastTick = Instant.now();
        }
        if (this.config.showPrayerDoseIndicator()) {
            this.doseOverlay.onTick();
        }
        if (this.config.showPrayerBar()) {
            this.barOverlay.onTick();
        }
        if (!this.config.prayerIndicator()) {
            return;
        }
        for (PrayerType prayerType : PrayerType.values()) {
            Prayer prayer = prayerType.getPrayer();
            int ord = prayerType.ordinal();
            if (this.client.isPrayerActive(prayer)) {
                if (prayerType.isOverhead() && !this.config.prayerIndicatorOverheads() || this.prayerCounter[ord] != null) continue;
                PrayerCounter counter = this.prayerCounter[ord] = new PrayerCounter(this, prayerType);
                this.spriteManager.getSpriteAsync(prayerType.getSpriteID(), 0, counter::setImage);
                this.infoBoxManager.addInfoBox(counter);
                continue;
            }
            if (this.prayerCounter[ord] == null) continue;
            this.infoBoxManager.removeInfoBox(this.prayerCounter[ord]);
            this.prayerCounter[ord] = null;
        }
    }

    private int checkContainerForPrayer(Item[] items) {
        if (items == null) {
            return 0;
        }
        int total = 0;
        boolean hasPrayerPotion = false;
        boolean hasSuperRestore = false;
        boolean hasSanfew = false;
        for (Item item : items) {
            if (item == null) continue;
            PrayerRestoreType type = PrayerRestoreType.getType(item.getId());
            if (type != null) {
                switch (type) {
                    case PRAYERPOT: {
                        hasPrayerPotion = true;
                        break;
                    }
                    case RESTOREPOT: {
                        hasSuperRestore = true;
                        break;
                    }
                    case SANFEWPOT: {
                        hasSanfew = true;
                        break;
                    }
                    case HOLYWRENCH: {
                        this.doseOverlay.setHasHolyWrench(true);
                    }
                }
            }
            int bonus = PrayerItems.getItemPrayerBonus(item.getId());
            total += bonus;
        }
        if (hasSanfew || hasSuperRestore || hasPrayerPotion) {
            this.doseOverlay.setHasPrayerRestore(true);
            if (hasSanfew) {
                this.doseOverlay.setBonusPrayer(2);
            } else if (hasSuperRestore) {
                this.doseOverlay.setBonusPrayer(1);
            }
        }
        return total;
    }

    double getTickProgress() {
        long timeSinceLastTick = Duration.between(this.startOfLastTick, Instant.now()).toMillis();
        float tickProgress = (float)(timeSinceLastTick % 600L) / 600.0f;
        return (double)tickProgress * Math.PI;
    }

    private boolean isAnyPrayerActive() {
        for (Prayer pray : Prayer.values()) {
            if (!this.client.isPrayerActive(pray)) continue;
            return true;
        }
        return false;
    }

    private void removeIndicators() {
        this.infoBoxManager.removeIf(entry -> entry instanceof PrayerCounter);
    }

    private void removeOverheadsIndicators() {
        this.infoBoxManager.removeIf(entry -> entry instanceof PrayerCounter && ((PrayerCounter)entry).getPrayerType().isOverhead());
    }

    boolean isPrayersActive() {
        return this.prayersActive;
    }
}

