/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.prayer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.prayer.PrayerConfig;
import net.runelite.client.plugins.prayer.PrayerFlickLocation;
import net.runelite.client.plugins.prayer.PrayerPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

class PrayerFlickOverlay
extends Overlay {
    private final Client client;
    private final PrayerConfig config;
    private final PrayerPlugin plugin;

    @Inject
    private PrayerFlickOverlay(Client client2, PrayerConfig config, PrayerPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client2;
        this.config = config;
        this.plugin = plugin;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        int orbInnerHeight;
        if (!this.plugin.isPrayersActive() && !this.config.prayerFlickAlwaysOn() || this.config.prayerFlickLocation().equals((Object)PrayerFlickLocation.NONE) || this.config.prayerFlickLocation().equals((Object)PrayerFlickLocation.PRAYER_BAR)) {
            return null;
        }
        Widget xpOrb = this.client.getWidget(WidgetInfo.MINIMAP_QUICK_PRAYER_ORB);
        if (xpOrb == null) {
            return null;
        }
        Rectangle2D bounds = xpOrb.getBounds().getBounds2D();
        if (bounds.getX() <= 0.0) {
            return null;
        }
        int orbInnerWidth = orbInnerHeight = (int)bounds.getHeight();
        int orbInnerX = (int)(bounds.getX() + 24.0);
        int orbInnerY = (int)(bounds.getY() - 1.0);
        double t = this.plugin.getTickProgress();
        int xOffset = (int)(-Math.cos(t) * (double)orbInnerWidth / 2.0) + orbInnerWidth / 2;
        int indicatorHeight = (int)(Math.sin(t) * (double)orbInnerHeight);
        int yOffset = orbInnerHeight / 2 - indicatorHeight / 2;
        graphics.setColor(Color.cyan);
        graphics.fillRect(orbInnerX + xOffset, orbInnerY + yOffset, 1, indicatorHeight);
        return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
    }
}

