/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.prayer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.prayer.PrayerConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;
import org.apache.commons.lang3.StringUtils;

class PrayerDoseOverlay
extends Overlay {
    private static final float PULSE_TIME = 1200.0f;
    private static final Color START_COLOR = new Color(0, 255, 255);
    private static final Color END_COLOR = new Color(0, 92, 92);
    private final Client client;
    private final PrayerConfig config;
    private final TooltipManager tooltipManager;
    private Instant startOfLastTick = Instant.now();
    private boolean trackTick = true;
    private int prayerBonus;
    private boolean hasPrayerRestore;
    private int bonusPrayer;
    private boolean hasHolyWrench;

    @Inject
    private PrayerDoseOverlay(Client client2, TooltipManager tooltipManager, PrayerConfig config) {
        this.client = client2;
        this.tooltipManager = tooltipManager;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    void onTick() {
        if (this.trackTick) {
            this.startOfLastTick = Instant.now();
            this.trackTick = false;
        } else {
            this.trackTick = true;
        }
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Widget xpOrb = this.client.getWidget(WidgetInfo.MINIMAP_QUICK_PRAYER_ORB);
        if (xpOrb == null || xpOrb.isHidden()) {
            return null;
        }
        Rectangle bounds = xpOrb.getBounds();
        if (bounds.getX() <= 0.0) {
            return null;
        }
        Point mousePosition = this.client.getMouseCanvasPosition();
        if (this.config.showPrayerStatistics() && bounds.contains(mousePosition.getX(), mousePosition.getY())) {
            String tooltip = "Time Remaining: " + this.getEstimatedTimeRemaining() + "</br>Prayer Bonus: " + this.prayerBonus;
            this.tooltipManager.add(new Tooltip(tooltip));
        }
        if (!this.config.showPrayerDoseIndicator() || !this.hasPrayerRestore) {
            return null;
        }
        int currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        int maxPrayer = this.client.getRealSkillLevel(Skill.PRAYER);
        int prayerPointsMissing = maxPrayer - currentPrayer;
        if (prayerPointsMissing <= 0) {
            return null;
        }
        double dosePercentage = this.hasHolyWrench ? 0.27 : 0.25;
        int basePointsRestored = (int)Math.floor((double)maxPrayer * dosePercentage);
        int pointsRestored = basePointsRestored + 7 + this.bonusPrayer;
        if (prayerPointsMissing < pointsRestored) {
            return null;
        }
        int orbInnerSize = (int)bounds.getHeight();
        int orbInnerX = (int)(bounds.getX() + 24.0);
        int orbInnerY = (int)(bounds.getY() - 1.0);
        long timeSinceLastTick = Duration.between(this.startOfLastTick, Instant.now()).toMillis();
        float tickProgress = Math.min((float)timeSinceLastTick / 1200.0f, 1.0f);
        double t = (double)tickProgress * Math.PI;
        graphics.setColor(ColorUtil.colorLerp(START_COLOR, END_COLOR, Math.sin(t)));
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.drawOval(orbInnerX, orbInnerY, orbInnerSize, orbInnerSize);
        return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
    }

    private double getPrayerDrainRate(Client client2) {
        double drainRate = 0.0;
        for (Prayer prayer : Prayer.values()) {
            if (!client2.isPrayerActive(prayer)) continue;
            drainRate += prayer.getDrainRate();
        }
        return drainRate;
    }

    private String getEstimatedTimeRemaining() {
        double drainRate = this.getPrayerDrainRate(this.client);
        if (drainRate == 0.0) {
            return "N/A";
        }
        int currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        double secondsPerPoint = 60.0 / drainRate * (1.0 + (double)this.prayerBonus / 30.0);
        double secondsLeft = (double)currentPrayer * secondsPerPoint;
        int minutes = (int)Math.floor(secondsLeft / 60.0);
        int seconds = (int)Math.floor(secondsLeft - (double)minutes * 60.0);
        return Integer.toString(minutes) + ":" + StringUtils.leftPad(Integer.toString(seconds), 2, "0");
    }

    void setPrayerBonus(int prayerBonus) {
        this.prayerBonus = prayerBonus;
    }

    void setHasPrayerRestore(boolean hasPrayerRestore) {
        this.hasPrayerRestore = hasPrayerRestore;
    }

    void setBonusPrayer(int bonusPrayer) {
        this.bonusPrayer = bonusPrayer;
    }

    void setHasHolyWrench(boolean hasHolyWrench) {
        this.hasHolyWrench = hasHolyWrench;
    }
}

