/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.prayer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.prayer.PrayerConfig;
import net.runelite.client.plugins.prayer.PrayerFlickLocation;
import net.runelite.client.plugins.prayer.PrayerPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

@Singleton
class PrayerBarOverlay
extends Overlay {
    private static final Color BAR_FILL_COLOR = new Color(0, 149, 151);
    private static final Color BAR_BG_COLOR = Color.black;
    private static final Color FLICK_HELP_COLOR = Color.white;
    private static final Dimension PRAYER_BAR_SIZE = new Dimension(30, 5);
    private final Client client;
    private final PrayerConfig config;
    private final PrayerPlugin plugin;
    private boolean showingPrayerBar;

    @Inject
    private PrayerBarOverlay(Client client2, PrayerConfig config, PrayerPlugin plugin) {
        this.client = client2;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.config.showPrayerBar() || !this.showingPrayerBar) {
            return null;
        }
        int height = this.client.getLocalPlayer().getLogicalHeight() + 10;
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        Point canvasPoint = Perspective.localToCanvas(this.client, localLocation, this.client.getPlane(), height);
        int barX = canvasPoint.getX() - 15;
        int barY = canvasPoint.getY();
        int barWidth = PrayerBarOverlay.PRAYER_BAR_SIZE.width;
        int barHeight = PrayerBarOverlay.PRAYER_BAR_SIZE.height;
        float ratio = (float)this.client.getBoostedSkillLevel(Skill.PRAYER) / (float)this.client.getRealSkillLevel(Skill.PRAYER);
        int progressFill = (int)Math.ceil(Math.min((float)barWidth * ratio, (float)barWidth));
        graphics.setColor(BAR_BG_COLOR);
        graphics.fillRect(barX, barY, barWidth, barHeight);
        graphics.setColor(BAR_FILL_COLOR);
        graphics.fillRect(barX, barY, progressFill, barHeight);
        if ((this.plugin.isPrayersActive() || this.config.prayerFlickAlwaysOn()) && (this.config.prayerFlickLocation().equals((Object)PrayerFlickLocation.PRAYER_BAR) || this.config.prayerFlickLocation().equals((Object)PrayerFlickLocation.BOTH))) {
            double t = this.plugin.getTickProgress();
            int xOffset = (int)(-Math.cos(t) * (double)barWidth / 2.0) + barWidth / 2;
            graphics.setColor(FLICK_HELP_COLOR);
            graphics.fillRect(barX + xOffset, barY, 1, barHeight);
        }
        return new Dimension(barWidth, barHeight);
    }

    void onTick() {
        Player localPlayer = this.client.getLocalPlayer();
        this.showingPrayerBar = true;
        if (localPlayer == null) {
            this.showingPrayerBar = false;
            return;
        }
        if (this.config.hideIfNotPraying() && !this.plugin.isPrayersActive()) {
            this.showingPrayerBar = false;
            return;
        }
        if (this.config.hideIfOutOfCombat() && localPlayer.getHealth() == -1) {
            this.showingPrayerBar = false;
        }
    }
}

