/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.playerinfo;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.playerinfo.PlayerInfoConfig;
import net.runelite.client.plugins.playerinfo.PlayerInfoCustomIndicator;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;

@PluginDescriptor(name="Player Information", description="An alternative to the Minimap Orbs", tags={"combat", "overlay"}, enabledByDefault=false)
@Singleton
public class PlayerInfoPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private PlayerInfoConfig config;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private SkillIconManager skillIconManager;

    @Provides
    PlayerInfoConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(PlayerInfoConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState().ordinal() < GameState.LOGIN_SCREEN.ordinal()) {
                return false;
            }
            BufferedImage healthImg = this.spriteManager.getSprite(1067, 0);
            BufferedImage prayerImg = this.spriteManager.getSprite(1068, 0);
            BufferedImage energyImg = this.spriteManager.getSprite(1070, 0);
            BufferedImage combatImg = this.spriteManager.getSprite(1610, 0);
            BufferedImage worldImg = this.spriteManager.getSprite(1439, 0);
            this.infoBoxManager.addInfoBox(new PlayerInfoCustomIndicator(healthImg, this, this.config, this.client, PlayerInfoCustomIndicator.IndicatorType.HEALTH));
            this.infoBoxManager.addInfoBox(new PlayerInfoCustomIndicator(prayerImg, this, this.config, this.client, PlayerInfoCustomIndicator.IndicatorType.PRAYER));
            this.infoBoxManager.addInfoBox(new PlayerInfoCustomIndicator(energyImg, this, this.config, this.client, PlayerInfoCustomIndicator.IndicatorType.ENERGY));
            this.infoBoxManager.addInfoBox(new PlayerInfoCustomIndicator(combatImg, this, this.config, this.client, PlayerInfoCustomIndicator.IndicatorType.SPECIAL));
            this.infoBoxManager.addInfoBox(new PlayerInfoCustomIndicator(worldImg, this, this.config, this.client, PlayerInfoCustomIndicator.IndicatorType.WORLD));
            return true;
        });
    }

    @Override
    protected void shutDown() throws Exception {
        this.infoBoxManager.removeIf(i -> i instanceof PlayerInfoCustomIndicator);
    }
}

