/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.playerinfo;

import java.awt.Color;
import java.awt.Image;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.VarPlayer;
import net.runelite.client.plugins.playerinfo.PlayerInfoConfig;
import net.runelite.client.plugins.playerinfo.PlayerInfoPlugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.ColorUtil;

public class PlayerInfoCustomIndicator
extends InfoBox {
    private final PlayerInfoConfig config;
    private final Client client;
    private final IndicatorType type;

    PlayerInfoCustomIndicator(Image image, PlayerInfoPlugin plugin, PlayerInfoConfig config, Client client2, IndicatorType type) {
        super(image, plugin);
        this.config = config;
        this.client = client2;
        this.type = type;
        this.setTooltip(type.getDescription());
    }

    @Override
    public String getText() {
        switch (this.type) {
            case HEALTH: {
                return String.valueOf(this.client.getBoostedSkillLevel(Skill.HITPOINTS));
            }
            case PRAYER: {
                return String.valueOf(this.client.getBoostedSkillLevel(Skill.PRAYER));
            }
            case ENERGY: {
                return String.valueOf(this.client.getEnergy());
            }
            case SPECIAL: {
                return String.valueOf(this.client.getVar(VarPlayer.SPECIAL_ATTACK_PERCENT) / 10);
            }
            case WORLD: {
                return String.valueOf(this.client.getWorld());
            }
        }
        return null;
    }

    @Override
    public Color getTextColor() {
        float currLvl = 0.0f;
        switch (this.type) {
            case HEALTH: {
                currLvl = (float)this.client.getBoostedSkillLevel(Skill.HITPOINTS) / (float)this.client.getRealSkillLevel(Skill.HITPOINTS);
                break;
            }
            case PRAYER: {
                currLvl = (float)this.client.getBoostedSkillLevel(Skill.PRAYER) / (float)this.client.getRealSkillLevel(Skill.PRAYER);
                break;
            }
            case ENERGY: {
                currLvl = (float)this.client.getEnergy() / 100.0f;
                break;
            }
            case SPECIAL: {
                currLvl = (float)this.client.getVar(VarPlayer.SPECIAL_ATTACK_PERCENT) / 1000.0f;
            }
            case WORLD: {
                currLvl = 1000.0f;
            }
        }
        if ((double)currLvl > 1.0) {
            return this.config.colorHigh();
        }
        if ((double)currLvl > 0.5) {
            return ColorUtil.colorLerp(this.config.colorMed(), this.config.colorHigh(), currLvl * 2.0f - 1.0f);
        }
        return ColorUtil.colorLerp(this.config.colorLow(), this.config.colorMed(), currLvl * 2.0f);
    }

    @Override
    public boolean render() {
        switch (this.type) {
            case HEALTH: {
                return this.config.enableHealth();
            }
            case PRAYER: {
                return this.config.enablePrayer();
            }
            case ENERGY: {
                return this.config.enableEnergy();
            }
            case SPECIAL: {
                return this.config.enableSpec();
            }
            case WORLD: {
                return this.config.enableWorld();
            }
        }
        return false;
    }

    static enum IndicatorType {
        HEALTH("Current Hitpoints"),
        PRAYER("Current Prayer Points"),
        ENERGY("Current Run Energy"),
        SPECIAL("Current Special Attack"),
        WORLD("Current World");

        private final String description;

        private IndicatorType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

