/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.playerindicators;

import java.awt.Color;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsConfig;

@Singleton
public class PlayerIndicatorsService {
    private final Client client;
    private final PlayerIndicatorsConfig config;

    @Inject
    private PlayerIndicatorsService(Client client2, PlayerIndicatorsConfig config) {
        this.config = config;
        this.client = client2;
    }

    public void forEachPlayer(BiConsumer<Player, Color> consumer) {
        if (!(this.config.highlightOwnPlayer() || this.config.drawClanMemberNames() || this.config.highlightFriends() || this.config.highlightNonClanMembers())) {
            return;
        }
        Player localPlayer = this.client.getLocalPlayer();
        for (Player player : this.client.getPlayers()) {
            if (player == null || player.getName() == null) continue;
            boolean isClanMember = player.isClanMember();
            if (player == localPlayer) {
                if (!this.config.highlightOwnPlayer()) continue;
                consumer.accept(player, this.config.getOwnPlayerColor());
                continue;
            }
            if (this.config.highlightFriends() && player.isFriend()) {
                consumer.accept(player, this.config.getFriendColor());
                continue;
            }
            if (this.config.drawClanMemberNames() && isClanMember) {
                consumer.accept(player, this.config.getClanMemberColor());
                continue;
            }
            if (this.config.highlightTeamMembers() && localPlayer.getTeam() > 0 && localPlayer.getTeam() == player.getTeam()) {
                consumer.accept(player, this.config.getTeamMemberColor());
                continue;
            }
            if (!this.config.highlightNonClanMembers() || isClanMember) continue;
            consumer.accept(player, this.config.getNonClanMemberColor());
        }
    }
}

