/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.playerindicators;

import com.google.inject.Provides;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.ClanMemberRank;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ClanManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsConfig;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsMinimapOverlay;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsOverlay;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsTileOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;

@PluginDescriptor(name="Player Indicators", description="Highlight players on-screen and/or on the minimap", tags={"highlight", "minimap", "overlay", "players"})
public class PlayerIndicatorsPlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PlayerIndicatorsConfig config;
    @Inject
    private PlayerIndicatorsOverlay playerIndicatorsOverlay;
    @Inject
    private PlayerIndicatorsTileOverlay playerIndicatorsTileOverlay;
    @Inject
    private PlayerIndicatorsMinimapOverlay playerIndicatorsMinimapOverlay;
    @Inject
    private Client client;
    @Inject
    private ClanManager clanManager;

    @Provides
    PlayerIndicatorsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(PlayerIndicatorsConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.playerIndicatorsOverlay);
        this.overlayManager.add(this.playerIndicatorsTileOverlay);
        this.overlayManager.add(this.playerIndicatorsMinimapOverlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.playerIndicatorsOverlay);
        this.overlayManager.remove(this.playerIndicatorsTileOverlay);
        this.overlayManager.remove(this.playerIndicatorsMinimapOverlay);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded menuEntryAdded) {
        int type = menuEntryAdded.getType();
        if (type >= 2000) {
            type -= 2000;
        }
        int identifier = menuEntryAdded.getIdentifier();
        if (type == MenuAction.FOLLOW.getId() || type == MenuAction.TRADE.getId() || type == MenuAction.SPELL_CAST_ON_PLAYER.getId() || type == MenuAction.ITEM_USE_ON_PLAYER.getId() || type == MenuAction.PLAYER_FIRST_OPTION.getId() || type == MenuAction.PLAYER_SECOND_OPTION.getId() || type == MenuAction.PLAYER_THIRD_OPTION.getId() || type == MenuAction.PLAYER_FOURTH_OPTION.getId() || type == MenuAction.PLAYER_FIFTH_OPTION.getId() || type == MenuAction.PLAYER_SIXTH_OPTION.getId() || type == MenuAction.PLAYER_SEVENTH_OPTION.getId() || type == MenuAction.PLAYER_EIGTH_OPTION.getId() || type == MenuAction.RUNELITE.getId()) {
            Player localPlayer = this.client.getLocalPlayer();
            Player[] players = this.client.getCachedPlayers();
            Player player = null;
            if (identifier >= 0 && identifier < players.length) {
                player = players[identifier];
            }
            if (player == null) {
                return;
            }
            int image = -1;
            Color color = null;
            if (this.config.highlightFriends() && player.isFriend()) {
                color = this.config.getFriendColor();
            } else if (this.config.drawClanMemberNames() && player.isClanMember()) {
                color = this.config.getClanMemberColor();
                ClanMemberRank rank = this.clanManager.getRank(player.getName());
                if (rank != ClanMemberRank.UNRANKED) {
                    image = this.clanManager.getIconNumber(rank);
                }
            } else if (this.config.highlightTeamMembers() && player.getTeam() > 0 && localPlayer.getTeam() == player.getTeam()) {
                color = this.config.getTeamMemberColor();
            } else if (this.config.highlightNonClanMembers() && !player.isClanMember()) {
                color = this.config.getNonClanMemberColor();
            }
            if (image != -1 || color != null) {
                MenuEntry[] menuEntries = this.client.getMenuEntries();
                MenuEntry lastEntry = menuEntries[menuEntries.length - 1];
                if (color != null && this.config.colorPlayerMenu()) {
                    String target = lastEntry.getTarget();
                    int idx = target.indexOf(62);
                    if (idx != -1) {
                        target = target.substring(idx + 1);
                    }
                    lastEntry.setTarget(ColorUtil.prependColorTag(target, color));
                }
                if (image != -1 && this.config.showClanRanks()) {
                    lastEntry.setTarget("<img=" + image + ">" + lastEntry.getTarget());
                }
                this.client.setMenuEntries(menuEntries);
            }
        }
    }
}

