/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.playerindicators;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ClanMemberRank;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.client.game.ClanManager;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsConfig;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsService;
import net.runelite.client.plugins.playerindicators.PlayerNameLocation;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.Text;

@Singleton
public class PlayerIndicatorsOverlay
extends Overlay {
    private static final int ACTOR_OVERHEAD_TEXT_MARGIN = 40;
    private static final int ACTOR_HORIZONTAL_TEXT_MARGIN = 10;
    private final PlayerIndicatorsService playerIndicatorsService;
    private final PlayerIndicatorsConfig config;
    private final ClanManager clanManager;

    @Inject
    private PlayerIndicatorsOverlay(PlayerIndicatorsConfig config, PlayerIndicatorsService playerIndicatorsService, ClanManager clanManager) {
        this.config = config;
        this.playerIndicatorsService = playerIndicatorsService;
        this.clanManager = clanManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.MED);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        this.playerIndicatorsService.forEachPlayer((player, color) -> this.renderPlayerOverlay(graphics, (Player)player, (Color)color));
        return null;
    }

    private void renderPlayerOverlay(Graphics2D graphics, Player actor, Color color) {
        BufferedImage clanchatImage;
        ClanMemberRank rank;
        int zOffset;
        PlayerNameLocation drawPlayerNamesConfig = this.config.playerNamePosition();
        if (drawPlayerNamesConfig == PlayerNameLocation.DISABLED) {
            return;
        }
        switch (drawPlayerNamesConfig) {
            case MODEL_CENTER: 
            case MODEL_RIGHT: {
                zOffset = actor.getLogicalHeight() / 2;
                break;
            }
            default: {
                zOffset = actor.getLogicalHeight() + 40;
            }
        }
        String name = Text.sanitize(actor.getName());
        Point textLocation = actor.getCanvasTextLocation(graphics, name, zOffset);
        if (drawPlayerNamesConfig == PlayerNameLocation.MODEL_RIGHT) {
            textLocation = actor.getCanvasTextLocation(graphics, "", zOffset);
            if (textLocation == null) {
                return;
            }
            textLocation = new Point(textLocation.getX() + 10, textLocation.getY());
        }
        if (textLocation == null) {
            return;
        }
        if (this.config.showClanRanks() && actor.isClanMember() && (rank = this.clanManager.getRank(name)) != ClanMemberRank.UNRANKED && (clanchatImage = this.clanManager.getClanImage(rank)) != null) {
            int clanImageNegativeMargin;
            int clanImageTextMargin;
            int clanImageWidth = clanchatImage.getWidth();
            if (drawPlayerNamesConfig == PlayerNameLocation.MODEL_RIGHT) {
                clanImageTextMargin = clanImageWidth;
                clanImageNegativeMargin = 0;
            } else {
                clanImageTextMargin = clanImageWidth / 2;
                clanImageNegativeMargin = clanImageWidth / 2;
            }
            int textHeight = graphics.getFontMetrics().getHeight() - graphics.getFontMetrics().getMaxDescent();
            Point imageLocation = new Point(textLocation.getX() - clanImageNegativeMargin - 1, textLocation.getY() - textHeight / 2 - clanchatImage.getHeight() / 2);
            OverlayUtil.renderImageLocation(graphics, imageLocation, clanchatImage);
            textLocation = new Point(textLocation.getX() + clanImageTextMargin, textLocation.getY());
        }
        OverlayUtil.renderTextLocation(graphics, textLocation, name, color);
    }
}

