/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.playerindicators;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.plugins.playerindicators.PlayerNameLocation;

@ConfigGroup(value="playerindicators")
public interface PlayerIndicatorsConfig
extends Config {
    @ConfigItem(position=0, keyName="drawOwnName", name="Highlight own player", description="Configures whether or not your own player should be highlighted")
    default public boolean highlightOwnPlayer() {
        return false;
    }

    @ConfigItem(position=1, keyName="ownNameColor", name="Own player color", description="Color of your own player")
    default public Color getOwnPlayerColor() {
        return new Color(0, 184, 212);
    }

    @ConfigItem(position=2, keyName="drawFriendNames", name="Highlight friends", description="Configures whether or not friends should be highlighted")
    default public boolean highlightFriends() {
        return true;
    }

    @ConfigItem(position=3, keyName="friendNameColor", name="Friend color", description="Color of friend names")
    default public Color getFriendColor() {
        return new Color(0, 200, 83);
    }

    @ConfigItem(position=4, keyName="drawClanMemberNames", name="Highlight clan members", description="Configures whether or clan members should be highlighted")
    default public boolean drawClanMemberNames() {
        return false;
    }

    @ConfigItem(position=5, keyName="clanMemberColor", name="Clan member color", description="Color of clan members")
    default public Color getClanMemberColor() {
        return new Color(170, 0, 255);
    }

    @ConfigItem(position=6, keyName="drawTeamMemberNames", name="Highlight team members", description="Configures whether or not team members should be highlighted")
    default public boolean highlightTeamMembers() {
        return true;
    }

    @ConfigItem(position=7, keyName="teamMemberColor", name="Team member color", description="Color of team members")
    default public Color getTeamMemberColor() {
        return new Color(19, 110, 247);
    }

    @ConfigItem(position=8, keyName="drawNonClanMemberNames", name="Highlight non-clan members", description="Configures whether or not non-clan members should be highlighted")
    default public boolean highlightNonClanMembers() {
        return false;
    }

    @ConfigItem(position=9, keyName="nonClanMemberColor", name="Non-clan member color", description="Color of non-clan member names")
    default public Color getNonClanMemberColor() {
        return Color.RED;
    }

    @ConfigItem(position=10, keyName="drawPlayerTiles", name="Draw tiles under players", description="Configures whether or not tiles under highlighted players should be drawn")
    default public boolean drawTiles() {
        return false;
    }

    @ConfigItem(position=11, keyName="playerNamePosition", name="Name position", description="Configures the position of drawn player names, or if they should be disabled")
    default public PlayerNameLocation playerNamePosition() {
        return PlayerNameLocation.ABOVE_HEAD;
    }

    @ConfigItem(position=12, keyName="drawMinimapNames", name="Draw names on minimap", description="Configures whether or not minimap names for players with rendered names should be drawn")
    default public boolean drawMinimapNames() {
        return false;
    }

    @ConfigItem(position=13, keyName="colorPlayerMenu", name="Colorize player menu", description="Color right click menu for players")
    default public boolean colorPlayerMenu() {
        return true;
    }

    @ConfigItem(position=14, keyName="clanMenuIcons", name="Show clan ranks", description="Add clan rank to right click menu and next to player names")
    default public boolean showClanRanks() {
        return true;
    }
}

