/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.party;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.party.PartyConfig;
import net.runelite.client.plugins.party.PartyPlugin;
import net.runelite.client.plugins.party.data.PartyData;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.ProgressBarComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.ws.PartyService;

public class PartyStatsOverlay
extends Overlay {
    private static final Color HP_FG = new Color(0, 146, 54, 230);
    private static final Color HP_BG = new Color(102, 15, 16, 230);
    private static final Color PRAY_FG = new Color(0, 149, 151);
    private static final Color PRAY_BG = Color.black;
    private final PartyPlugin plugin;
    private final PartyService party;
    private final PartyConfig config;
    private final PanelComponent body = new PanelComponent();

    @Inject
    private PartyStatsOverlay(PartyPlugin plugin, PartyService party, PartyConfig config) {
        super(plugin);
        this.plugin = plugin;
        this.party = party;
        this.config = config;
        this.body.setBorder(new Rectangle());
        this.body.setGap(new Point(0, 2));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Leave", "Party"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension render(Graphics2D graphics) {
        if (!this.config.stats()) {
            return null;
        }
        Map<UUID, PartyData> partyDataMap = this.plugin.getPartyDataMap();
        if (partyDataMap.isEmpty()) {
            return null;
        }
        this.body.getChildren().clear();
        this.body.setBackgroundColor(null);
        boolean only1 = this.plugin.getPartyDataMap().size() == 1;
        Map<UUID, PartyData> map = this.plugin.getPartyDataMap();
        synchronized (map) {
            partyDataMap.forEach((k, v) -> {
                if (this.party.getLocalMember() != null && this.party.getLocalMember().getMemberId().equals(k)) {
                    if (only1) {
                        this.body.getChildren().add(TitleComponent.builder().text("No other party members").color(Color.RED).build());
                    }
                    return;
                }
                PanelComponent panel = v.getPanel();
                panel.getChildren().clear();
                TitleComponent name = TitleComponent.builder().text(v.getName()).color(this.config.recolorNames() ? v.getColor() : Color.WHITE).build();
                panel.getChildren().add(name);
                if (v.getMaxHitpoints() > 0) {
                    ProgressBarComponent hpBar = new ProgressBarComponent();
                    hpBar.setBackgroundColor(HP_BG);
                    hpBar.setForegroundColor(HP_FG);
                    hpBar.setMaximum(v.getMaxHitpoints());
                    hpBar.setValue(v.getHitpoints());
                    hpBar.setLabelDisplayMode(ProgressBarComponent.LabelDisplayMode.FULL);
                    panel.getChildren().add(hpBar);
                }
                if (v.getMaxPrayer() > 0) {
                    ProgressBarComponent prayBar = new ProgressBarComponent();
                    prayBar.setBackgroundColor(PRAY_BG);
                    prayBar.setForegroundColor(PRAY_FG);
                    prayBar.setMaximum(v.getMaxPrayer());
                    prayBar.setValue(v.getPrayer());
                    prayBar.setLabelDisplayMode(ProgressBarComponent.LabelDisplayMode.FULL);
                    panel.getChildren().add(prayBar);
                }
                this.body.getChildren().add(panel);
            });
        }
        return this.body.render(graphics);
    }
}

