/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.party;

import com.google.inject.Binder;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Skill;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.party.PartyConfig;
import net.runelite.client.plugins.party.PartyPingOverlay;
import net.runelite.client.plugins.party.PartyPluginService;
import net.runelite.client.plugins.party.PartyPluginServiceImpl;
import net.runelite.client.plugins.party.PartyStatsOverlay;
import net.runelite.client.plugins.party.PartyWorldMapPoint;
import net.runelite.client.plugins.party.data.PartyData;
import net.runelite.client.plugins.party.data.PartyTilePingData;
import net.runelite.client.plugins.party.messages.LocationUpdate;
import net.runelite.client.plugins.party.messages.SkillUpdate;
import net.runelite.client.plugins.party.messages.TilePing;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.ws.PartyMember;
import net.runelite.client.ws.PartyService;
import net.runelite.client.ws.WSClient;
import net.runelite.http.api.ws.messages.party.UserJoin;
import net.runelite.http.api.ws.messages.party.UserPart;
import net.runelite.http.api.ws.messages.party.UserSync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Party", description="Shows useful information about current party")
public class PartyPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(PartyPlugin.class);
    @Inject
    private Client client;
    @Inject
    private PartyService party;
    @Inject
    private WSClient ws;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PartyStatsOverlay partyStatsOverlay;
    @Inject
    private PartyPingOverlay partyPingOverlay;
    @Inject
    private KeyManager keyManager;
    @Inject
    private WSClient wsClient;
    @Inject
    private WorldMapPointManager worldMapManager;
    @Inject
    private PartyConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    private final Map<UUID, PartyData> partyDataMap = Collections.synchronizedMap(new HashMap());
    private final List<PartyTilePingData> pendingTilePings = Collections.synchronizedList(new ArrayList());
    private int lastHp;
    private int lastPray;
    private boolean hotkeyDown;
    private boolean doSync;
    private boolean sendAlert;

    @Override
    public void configure(Binder binder) {
        binder.bind(PartyPluginService.class).to(PartyPluginServiceImpl.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.partyStatsOverlay);
        this.overlayManager.add(this.partyPingOverlay);
        this.wsClient.registerMessage(SkillUpdate.class);
        this.wsClient.registerMessage(TilePing.class);
        this.wsClient.registerMessage(LocationUpdate.class);
        this.keyManager.registerKeyListener(this);
        this.doSync = true;
    }

    @Override
    protected void shutDown() throws Exception {
        this.partyDataMap.clear();
        this.pendingTilePings.clear();
        this.worldMapManager.removeIf(PartyWorldMapPoint.class::isInstance);
        this.overlayManager.remove(this.partyStatsOverlay);
        this.overlayManager.remove(this.partyPingOverlay);
        this.wsClient.unregisterMessage(SkillUpdate.class);
        this.wsClient.unregisterMessage(TilePing.class);
        this.wsClient.unregisterMessage(LocationUpdate.class);
        this.keyManager.unregisterKeyListener(this);
        this.hotkeyDown = false;
        this.doSync = false;
        this.sendAlert = false;
    }

    @Provides
    public PartyConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(PartyConfig.class);
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getEntry().getMenuAction() == MenuAction.RUNELITE_OVERLAY && event.getEntry().getTarget().equals("Party") && event.getEntry().getOption().equals("Leave")) {
            this.party.changeParty(null);
            if (!this.config.messages()) {
                return;
            }
            String leaveMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("You have left the party.").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(leaveMessage).build());
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (!this.hotkeyDown || this.client.isMenuOpen() || this.party.getMembers().isEmpty() || !this.config.pings()) {
            return;
        }
        Tile selectedSceneTile = this.client.getSelectedSceneTile();
        if (selectedSceneTile == null) {
            return;
        }
        boolean isOnCanvas = false;
        for (MenuEntry menuEntry : this.client.getMenuEntries()) {
            if (menuEntry == null || !"walk here".equalsIgnoreCase(menuEntry.getOption())) continue;
            isOnCanvas = true;
        }
        if (!isOnCanvas) {
            return;
        }
        event.consume();
        TilePing tilePing = new TilePing(selectedSceneTile.getWorldLocation());
        tilePing.setMemberId(this.party.getLocalMember().getMemberId());
        this.wsClient.send(tilePing);
    }

    @Subscribe
    public void onTilePing(TilePing event) {
        if (this.config.pings()) {
            PartyData partyData = this.getPartyData(event.getMemberId());
            Color color = partyData != null ? partyData.getColor() : Color.RED;
            this.pendingTilePings.add(new PartyTilePingData(event.getPoint(), color));
        }
        if (this.config.sounds()) {
            WorldPoint point = event.getPoint();
            if (point.getPlane() != this.client.getPlane() || !WorldPoint.isInScene(this.client, point.getX(), point.getY())) {
                return;
            }
            this.client.playSoundEffect(3790);
        }
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS)
    public void shareLocation() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        PartyMember localMember = this.party.getLocalMember();
        if (localMember == null) {
            return;
        }
        LocationUpdate locationUpdate = new LocationUpdate(this.client.getLocalPlayer().getWorldLocation());
        locationUpdate.setMemberId(localMember.getMemberId());
        this.wsClient.send(locationUpdate);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.sendAlert && this.client.getGameState() == GameState.LOGGED_IN) {
            this.sendAlert = false;
            this.sendInstructionMessage();
        }
        if (this.doSync && !this.party.getMembers().isEmpty()) {
            UserSync userSync = new UserSync();
            userSync.setMemberId(this.party.getLocalMember().getMemberId());
            this.ws.send(userSync);
        }
        this.doSync = false;
        int currentHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        int currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        int realHealth = this.client.getRealSkillLevel(Skill.HITPOINTS);
        int realPrayer = this.client.getRealSkillLevel(Skill.PRAYER);
        PartyMember localMember = this.party.getLocalMember();
        if (localMember != null) {
            SkillUpdate update;
            if (currentHealth != this.lastHp) {
                update = new SkillUpdate(Skill.HITPOINTS, currentHealth, realHealth);
                update.setMemberId(localMember.getMemberId());
                this.ws.send(update);
            }
            if (currentPrayer != this.lastPray) {
                update = new SkillUpdate(Skill.PRAYER, currentPrayer, realPrayer);
                update.setMemberId(localMember.getMemberId());
                this.ws.send(update);
            }
        }
        this.lastHp = currentHealth;
        this.lastPray = currentPrayer;
    }

    @Subscribe
    public void onSkillUpdate(SkillUpdate event) {
        PartyData partyData = this.getPartyData(event.getMemberId());
        if (partyData == null) {
            return;
        }
        if (event.getSkill() == Skill.HITPOINTS) {
            partyData.setHitpoints(event.getValue());
            partyData.setMaxHitpoints(event.getMax());
        } else if (event.getSkill() == Skill.PRAYER) {
            partyData.setPrayer(event.getValue());
            partyData.setMaxPrayer(event.getMax());
        }
    }

    @Subscribe
    public void onLocationUpdate(LocationUpdate event) {
        PartyData partyData = this.getPartyData(event.getMemberId());
        if (partyData == null) {
            return;
        }
        partyData.getWorldMapPoint().setWorldPoint(event.getWorldPoint());
    }

    @Subscribe
    public void onUserJoin(UserJoin event) {
        PartyData partyData = this.getPartyData(event.getMemberId());
        if (partyData == null || !this.config.messages()) {
            return;
        }
        String joinMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(partyData.getName()).append(" has joined the party!").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(joinMessage).build());
        PartyMember localMember = this.party.getLocalMember();
        if (localMember != null && partyData.getMemberId().equals(localMember.getMemberId())) {
            this.sendAlert = true;
        }
    }

    @Subscribe
    public void onUserSync(UserSync event) {
        int currentHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        int currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        int realHealth = this.client.getRealSkillLevel(Skill.HITPOINTS);
        int realPrayer = this.client.getRealSkillLevel(Skill.PRAYER);
        PartyMember localMember = this.party.getLocalMember();
        if (localMember != null) {
            SkillUpdate hpUpdate = new SkillUpdate(Skill.HITPOINTS, currentHealth, realHealth);
            hpUpdate.setMemberId(localMember.getMemberId());
            this.ws.send(hpUpdate);
            SkillUpdate prayUpdate = new SkillUpdate(Skill.PRAYER, currentPrayer, realPrayer);
            prayUpdate.setMemberId(localMember.getMemberId());
            this.ws.send(prayUpdate);
        }
    }

    @Subscribe
    public void onUserPart(UserPart event) {
        PartyData removed = this.partyDataMap.remove(event.getMemberId());
        if (removed != null) {
            if (this.config.messages()) {
                String joinMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(removed.getName()).append(" has left the party!").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(joinMessage).build());
            }
            this.worldMapManager.remove(removed.getWorldMapPoint());
        }
    }

    @Subscribe
    public void onPartyChanged(PartyChanged event) {
        this.partyDataMap.clear();
        this.pendingTilePings.clear();
        this.worldMapManager.removeIf(PartyWorldMapPoint.class::isInstance);
    }

    @Nullable
    PartyData getPartyData(UUID uuid) {
        PartyMember memberById = this.party.getMemberById(uuid);
        if (memberById == null) {
            return null;
        }
        return this.partyDataMap.computeIfAbsent(uuid, u -> {
            String name = memberById.getName();
            PartyWorldMapPoint worldMapPoint = new PartyWorldMapPoint(new WorldPoint(0, 0, 0), memberById);
            worldMapPoint.setTooltip(name);
            PartyMember partyMember = this.party.getLocalMember();
            if (partyMember == null || !u.equals(partyMember.getMemberId())) {
                this.worldMapManager.add(worldMapPoint);
            }
            return new PartyData((UUID)u, name, worldMapPoint, ColorUtil.fromObject(name));
        });
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        if (!event.isFocused()) {
            this.hotkeyDown = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.hotkeyDown = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.hotkeyDown = false;
        }
    }

    private void sendInstructionMessage() {
        String helpMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("To leave party hold SHIFT and right click party stats overlay.").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(helpMessage).build());
    }

    public Map<UUID, PartyData> getPartyDataMap() {
        return this.partyDataMap;
    }

    public List<PartyTilePingData> getPendingTilePings() {
        return this.pendingTilePings;
    }
}

