/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.party;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.party.PartyPlugin;
import net.runelite.client.plugins.party.data.PartyTilePingData;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class PartyPingOverlay
extends Overlay {
    private final Client client;
    private final PartyPlugin plugin;

    @Inject
    private PartyPingOverlay(Client client2, PartyPlugin plugin) {
        this.client = client2;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getPartyDataMap().isEmpty()) {
            return null;
        }
        if (!this.client.isMenuOpen()) {
            Point p = this.client.getMouseCanvasPosition();
            p = new Point(p.getX() - this.client.getViewportXOffset(), p.getY() - this.client.getViewportYOffset());
            this.client.setCheckClick(true);
            this.client.setMouseCanvasHoverPosition(p);
        }
        List<PartyTilePingData> list = this.plugin.getPendingTilePings();
        synchronized (list) {
            Iterator<PartyTilePingData> iterator = this.plugin.getPendingTilePings().iterator();
            while (iterator.hasNext()) {
                PartyTilePingData next = iterator.next();
                if (next.getAlpha() <= 0) {
                    iterator.remove();
                    continue;
                }
                this.renderPing(graphics, next);
                next.setAlpha(next.getAlpha() - 5);
            }
        }
        return null;
    }

    private void renderPing(Graphics2D graphics, PartyTilePingData ping) {
        LocalPoint localPoint = LocalPoint.fromWorld(this.client, ping.getPoint());
        if (localPoint == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly(this.client, localPoint);
        if (poly == null) {
            return;
        }
        Color color = new Color(ping.getColor().getRed(), ping.getColor().getGreen(), ping.getColor().getBlue(), ping.getAlpha());
        OverlayUtil.renderPolygon(graphics, poly, color);
    }
}

